-- SQL --  dm 授权方案改为创建执行完SQL语句后，增加创建所有用户对unisql下表视图访问执行权限，和对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
-- SQL --  创建unisql模式
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = 'UNISQL';
    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
    END IF;
    EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_TAB_PARTITIONS TO unisql';
    EXECUTE IMMEDIATE 'GRANT SELECT ON SYS.DBA_PART_TABLES TO unisql';
    COMMIT;
END;

-- SQL --  创建 date_format 函数：处理 timestamp 类型输入
CREATE OR REPLACE FUNCTION unisql.date_format(p_time TIMESTAMP, p_format VARCHAR2)
RETURN VARCHAR2
AS
BEGIN
    IF p_time IS NULL OR p_format IS NULL THEN
        RETURN NULL;
    END IF;
    RETURN TO_CHAR(p_time, p_format);
END;

-- SQL --  创建 date_format 函数：处理 text 类型输入
CREATE OR REPLACE FUNCTION unisql.date_format(p_time_str VARCHAR2, p_format VARCHAR2)
RETURN VARCHAR2
AS
    v_time TIMESTAMP;
BEGIN
    IF p_time_str IS NULL OR p_format IS NULL THEN
        RETURN NULL;
    END IF;
    v_time := TO_TIMESTAMP(p_time_str, 'YYYY-MM-DD HH24:MI:SS.FF');
    RETURN TO_CHAR(v_time, p_format);
END;

-- SQL --  创建timestamp函数
CREATE OR REPLACE FUNCTION UNISQL.TIMESTAMP(
    p_date TIMESTAMP,
    p_time text
) RETURN DATETIME
AS
BEGIN
    IF p_date IS NULL OR p_time IS NULL THEN
        RETURN NULL;
END IF;
	IF  p_time = '' THEN
        RETURN NULL;
END IF;
RETURN CAST(p_date AS DATETIME) + TO_DSINTERVAL('0 ' || p_time);
END;

-- SQL --  创建 PARTITIONS 视图
CREATE OR REPLACE VIEW UNISQL.PARTITIONS AS
SELECT 
    t.OWNER AS TABLE_SCHEMA,
    t.TABLE_NAME,
    p.PARTITION_NAME,
    t.PARTITIONING_TYPE AS PARTITION_METHOD,
    CASE 
        WHEN p.HIGH_VALUE = 'MAXVALUE' THEN 'MAXVALUE'
        ELSE p.HIGH_VALUE
    END AS PARTITION_DESCRIPTION
FROM 
    DBA_TAB_PARTITIONS p
JOIN 
    DBA_PART_TABLES t 
    ON p.TABLE_OWNER = t.OWNER 
    AND p.TABLE_NAME = t.TABLE_NAME
WHERE 
    t.PARTITIONING_TYPE IN ('RANGE', 'LIST', 'HASH');


-- SQL --  创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下表视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;
