-- SQL --  解决 pb to_number(date-date)，临时修复缺陷：LIGHTDB-3308，只有在gaussdb-oracleV505.0版本才执行
DECLARE
    v_banner VARCHAR2(100);
    v_has_target BOOLEAN := FALSE;
    BEGIN
    SELECT banner
    INTO v_banner
    FROM v$version
    WHERE banner LIKE 'gaussdb%'
      AND ROWNUM = 1;
IF INSTR(v_banner, '505.0.0') > 0 THEN
        v_has_target := TRUE;
END IF;
IF v_has_target THEN
    EXECUTE IMMEDIATE '
        CREATE OR REPLACE FUNCTION public.to_number(interval)
        RETURNS int4
        AS $$
        BEGIN
            RETURN EXTRACT(day FROM $1);
        END;
        $$ LANGUAGE plpgsql STRICT IMMUTABLE;
    ';
    RAISE NOTICE 'banner包含"505.0.0"（实际banner：%），已创建interval转day整数函数', v_banner;
ELSE
    RAISE NOTICE 'banner不包含"505.0.0"（实际banner：%），不创建函数', v_banner;
END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE NOTICE '未查询到GaussDB内核版本信息';
WHEN OTHERS THEN
        RAISE NOTICE '执行失败：%', SQLERRM;
END;


-- SQL --  oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value ANYELEMENT)
    RETURNS ANYELEMENT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;

    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- SQL --  oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value TEXT)
    RETURNS TEXT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;
    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- SQL --  创建dual视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark
from information_schema.views
where table_schema = 'public'
  and table_name = 'dual';
if create_mark = 0 then
        create or replace view public.dual as
select 'X' as dummy;
raise notice 'create view %', 'public.dual';
else
        raise notice 'do not create view %', 'public.dual';
end if;
end
$$;