/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolUtils {
    private static final int DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_MAX_POOL_SIZE = DEFAULT_CORE_POOL_SIZE * 2;
    private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;
    private static volatile ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<ThreadPoolUtils> clazz = ThreadPoolUtils.class;
        synchronized (ThreadPoolUtils.class) {
            if (executorService != null) return executorService;
            executorService = ThreadPoolUtils.createThreadPool(DEFAULT_CORE_POOL_SIZE, DEFAULT_MAX_POOL_SIZE, 60L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    public static ExecutorService createThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime) {
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new CustomThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    public static Future<?> submit(Runnable task) {
        return ThreadPoolUtils.getExecutorService().submit(task);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return ThreadPoolUtils.getExecutorService().submit(task);
    }

    public static void shutdown() {
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    public static void shutdownNow() {
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    public static boolean isShutdown() {
        return executorService != null && executorService.isShutdown();
    }

    public static boolean isTerminated() {
        return executorService != null && executorService.isTerminated();
    }

    public static boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (executorService != null) {
            return executorService.awaitTermination(timeout, unit);
        }
        return true;
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "custom-thread-pool-";

        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, NAME_PREFIX + this.threadNumber.getAndIncrement());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

