/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final int SUCCESS_CODE = 0;
    public static final int INTERNAL_CODE = -1;
    private int count = 0;
    private int code;
    private T data;
    private String message;

    private Result(int code, int count, T data, String message) {
        this.code = code;
        this.count = count;
        this.data = data;
        this.message = message;
    }

    private Result(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    private Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(0, data, "");
    }

    public static <T> Result<T> successWithoutData(String message) {
        return new Result<Object>(0, null, message);
    }

    public static <T> Result<T> successWithDataAndMessage(T data, String message) {
        return new Result<T>(0, data, message);
    }

    public static <T> Result<T> successWithDataCountAndMessage(T data, int count, String message) {
        return new Result<T>(0, count, data, message);
    }

    public static <T> Result<T> fail(String message) {
        return new Result<T>(-1, message);
    }

    public static <T> Result<T> fail(int code, String message) {
        return new Result<T>(code, message);
    }

    public static <T> Result<T> fail(T data, String message) {
        return new Result<T>(-1, data, message);
    }

    public static <T> Result<T> fail(T data, int code, String message) {
        return new Result<T>(code, data, message);
    }

    public static <T> Result<T> fail(ErrorMessages errorMessages) {
        return new Result<T>(errorMessages.getCode(), errorMessages.getMsg());
    }

    public static <T> Result<T> fail(T data, ErrorMessages errorMessages) {
        return new Result<T>(errorMessages.getCode(), data, errorMessages.getMsg());
    }

    public static <T> Result<T> failFormat(ErrorMessages errorMessages, String ... args) {
        return new Result<T>(errorMessages.getCode(), ErrorMessages.format(errorMessages, args));
    }

    public static <T> Result<T> failFormat(T data, ErrorMessages errorMessages, String ... args) {
        return new Result<T>(errorMessages.getCode(), data, ErrorMessages.format(errorMessages, args));
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

