/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.hundsun.lightdb.unisql.model.MultiplexContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSqlMonitor {
    private static final Logger log = LoggerFactory.getLogger(MultiSqlMonitor.class);
    private static final ThreadLocal<MultiSqlMonitor> THREAD_LOCAL_MONITOR = new ThreadLocal();
    private static final Queue<MultiSqlMonitor> MONITORS_QUEUE = new LinkedList<MultiSqlMonitor>();
    private final List<String> actualExecutedSqls = new ArrayList<String>();
    private final List<SqlPair> transReturningSqls = new ArrayList<SqlPair>();
    public static final int MONITOR_TIMEOUT = 60000;
    private String traceId;
    private final long creationTime = System.currentTimeMillis();
    private final boolean mockSqlMonitorFlag;
    private static boolean hasSchedulerStarted = false;
    private static final ThreadFactory DAEMON_THREAD_FACTORY = runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("multisql-monitor");
        thread.setDaemon(true);
        return thread;
    };
    private static final ScheduledExecutorService MONITOR_SCHEDULER = new ScheduledThreadPoolExecutor(1, DAEMON_THREAD_FACTORY);
    private static final MultiSqlMonitor MOCK_SQLMONITOR = new MultiSqlMonitor(true);

    private MultiSqlMonitor(boolean mockSqlMonitorFlag) {
        this.mockSqlMonitorFlag = mockSqlMonitorFlag;
    }

    public static MultiSqlMonitor getInstance(String traceId) {
        if (MultiplexContext.inValidTraceId(traceId)) {
            return MOCK_SQLMONITOR;
        }
        MultiSqlMonitor instance = THREAD_LOCAL_MONITOR.get();
        if (instance != null && !instance.traceId.equals(traceId)) {
            THREAD_LOCAL_MONITOR.remove();
            instance = null;
        }
        if (instance == null) {
            instance = new MultiSqlMonitor(false);
            instance.traceId = traceId;
            THREAD_LOCAL_MONITOR.set(instance);
            MONITORS_QUEUE.offer(instance);
        }
        MultiSqlMonitor.startScheduler();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startScheduler() {
        if (hasSchedulerStarted) return;
        Class<MultiSqlMonitor> clazz = MultiSqlMonitor.class;
        synchronized (MultiSqlMonitor.class) {
            if (hasSchedulerStarted) return;
            hasSchedulerStarted = true;
            Runnable task = () -> {
                try {
                    MultiSqlMonitor.cleanUpTimedOutInstances();
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            };
            MONITOR_SCHEDULER.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.SECONDS);
            log.info("\u542f\u52a8\u591a\u53d1SQL\u76d1\u63a7\u7ebf\u7a0b\u5b8c\u6210");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void cleanUpTimedOutInstances() {
        MultiSqlMonitor instance;
        while (!MONITORS_QUEUE.isEmpty() && (instance = MONITORS_QUEUE.peek()) != null && instance.isInstanceTimedOut()) {
            MONITORS_QUEUE.poll();
            instance.infoMonitor();
        }
    }

    public boolean isInstanceTimedOut() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.creationTime > 60000L;
    }

    public void addActualExecutedSql(String sql) {
        if (this.mockSqlMonitorFlag) {
            return;
        }
        this.actualExecutedSqls.add(sql);
    }

    public void addConvertRetuningSql(String sourceSql, String targetSql) {
        if (this.mockSqlMonitorFlag) {
            return;
        }
        this.transReturningSqls.add(new SqlPair(sourceSql, targetSql));
    }

    private void infoMonitor() {
        if (this.mockSqlMonitorFlag) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info(this.format());
        }
    }

    private String inlineSql(String sql) {
        if (sql == null) {
            return sql;
        }
        return sql.replace("\n", " ");
    }

    public String format() {
        int i;
        String prefix = String.format("[%s-%s]", "monitor", this.traceId);
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("========= MonitorReport =========").append("\n");
        if (!this.actualExecutedSqls.isEmpty()) {
            sb.append(prefix).append("--- EXECUTE ---").append("\n");
            for (i = 0; i < this.actualExecutedSqls.size(); ++i) {
                sb.append(prefix).append("SQL ").append(i + 1).append(": ").append(this.inlineSql(this.actualExecutedSqls.get(i))).append("\n");
            }
        }
        if (!this.transReturningSqls.isEmpty()) {
            sb.append(prefix).append("--- INSERT2RETURN ---").append("\n");
            for (i = 0; i < this.transReturningSqls.size(); ++i) {
                SqlPair pair = this.transReturningSqls.get(i);
                sb.append(prefix).append("Pair ").append(i + 1).append(":\n");
                sb.append(prefix).append("  Original: ").append(this.inlineSql(pair.getOriginalSql())).append("\n");
                sb.append(prefix).append("  Converted: ").append(this.inlineSql(pair.getConvertedSql())).append("\n");
            }
        }
        return sb.toString();
    }

    private static class SqlPair {
        private final String originalSql;
        private final String convertedSql;

        public SqlPair(String originalSql, String convertedSql) {
            this.originalSql = originalSql != null ? originalSql : "NULL";
            this.convertedSql = convertedSql != null ? convertedSql : "NULL";
        }

        public String getOriginalSql() {
            return this.originalSql;
        }

        public String getConvertedSql() {
            return this.convertedSql;
        }
    }
}

