/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.GoParserFactory;
import com.hundsun.lightdb.unisql.golang.IGoParser;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.SqlKeywordChecker;
import com.hundsun.lightdb.unisql.golang.SqlState;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.Murmur32HashFunction;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerInternal {
    private static final Logger log = LoggerFactory.getLogger(TransformerInternal.class);
    private static final Object GO_SYNCHRONIZED_LOCK = new Object();
    private static String SUCCESS_CODE = "00000";
    private static String SUCCESS_MESSAGE = "SUCCESS";
    private static Pattern PATTERN_SKIP = Pattern.compile("/\\*\\+.*?\\bskiptransform\\b.*?\\*/", 34);
    private static Pattern PATTERN_NO_SKIP = Pattern.compile("/\\*\\+.*?\\bnoskiptransform\\b.*?\\*/", 34);
    public static ConcurrentLinkedHashMap<String, Transformer.TableNameValue> TableNameCache;
    public static ConcurrentLinkedHashMap<String, ReturnParameter> Cache;
    private static final Pattern LAST_INSERT_ID_PATTERN;
    private static final Pattern INSERT_VALUES_PATTERN;
    private static final ThreadLocal<String> genLastInsertIdSql;

    public static ReturnParameter parsePro(VariableParameter variableParameter) {
        return TransformerInternal.parseLastInsertIdInterceptor(variableParameter);
    }

    private static ReturnParameter parseLastInsertIdInterceptor(VariableParameter variableParameter) {
        String[] splitSqlByLastSemicolon;
        boolean isLastInsertIdEnable = 1 == UnisqlProperties.getGenLastInsertIdAfterInsert() && variableParameter.getSourceDialect().equalsIgnoreCase(DbType.MYSQL.name());
        String sql = variableParameter.getSourceSql();
        if (isLastInsertIdEnable && TransformerInternal.matchesLastInsertIdSql(sql)) {
            String lastInsertIdSql = TransformerInternal.getGenLastInsertIdSql();
            if (StringUtils.isNotBlank((CharSequence)lastInsertIdSql)) {
                return TransformerInternal.returnSourceSql(lastInsertIdSql);
            }
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0026, sql));
        }
        ReturnParameter returnParameter = TransformerInternal.parseCacheInterceptor(variableParameter);
        int insertWithLastInsertIdStmtCount = 2;
        if (isLastInsertIdEnable && SqlState.SUCCESS.getState().equals(returnParameter.getState()) && TransformerInternal.matchesInsertValuesSql(sql) && (splitSqlByLastSemicolon = TransformerInternal.splitSqlByLastSemicolon(returnParameter.getTargetSql())).length == 2) {
            returnParameter.setTargetSql(splitSqlByLastSemicolon[0]);
            TransformerInternal.setGenLastInsertIdSql(splitSqlByLastSemicolon[1]);
        }
        return returnParameter;
    }

    private static ReturnParameter parseCacheInterceptor(VariableParameter variableParameter) {
        String key;
        ReturnParameter parameter;
        String cacheKey = "";
        if (Transformer.globalStaticParameter.getIsCache() == 1 && (parameter = (ReturnParameter)Cache.get((Object)(cacheKey = Murmur32HashFunction.calcHash(key = String.join((CharSequence)":", variableParameter.getSourceDialect(), variableParameter.getTargetDialect(), variableParameter.getSourceSql()))))) != null && parameter.getSourceSql().equals(variableParameter.getSourceSql())) {
            return parameter.copy();
        }
        ReturnParameter returnParameter = TransformerInternal.parseSkipInterceptor(variableParameter);
        if (Transformer.globalStaticParameter.getIsCache() == 1 && !returnParameter.isDontCache()) {
            Cache.put((Object)cacheKey, (Object)returnParameter.copy());
        }
        return returnParameter;
    }

    private static ReturnParameter parseSkipInterceptor(VariableParameter variableParameter) {
        boolean sqlSkip;
        boolean sqlNoSkip;
        String sql = variableParameter.getSourceSql();
        if (Transformer.globalStaticParameter.getGlobalSkip() == 1 ? !(sqlNoSkip = PATTERN_NO_SKIP.matcher(sql).find()) && !SqlKeywordChecker.isSqlHaveKeyword(sql, Transformer.globalStaticParameter.getUnisqlSkipExceptionKeywords()) : (sqlSkip = PATTERN_SKIP.matcher(sql).find())) {
            return TransformerInternal.returnSourceSql(sql);
        }
        return TransformerInternal.parseInternal(variableParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReturnParameter parseInternal(VariableParameter variableParameter) {
        Pointer transformResultPointer = null;
        try {
            IGoParser parser = GoParserFactory.getGoParser();
            Runtime runtime = Runtime.getSystemRuntime();
            byte[] parameterBytes = variableParameter.encodeToBytes();
            Pointer transformParamPointer = Pointer.wrap((Runtime)runtime, (ByteBuffer)ByteBuffer.wrap(parameterBytes));
            if (MultiProperties.RUN_WHAT == 2) {
                Object object = GO_SYNCHRONIZED_LOCK;
                synchronized (object) {
                    transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
                }
            } else {
                transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
            }
            ReturnParameter returnParameter = ReturnParameter.decode(transformResultPointer);
            returnParameter.setSourceSql(variableParameter.getSourceSql());
            return returnParameter;
        }
        catch (Exception e) {
            log.error("Transformer.transform error, variableParameter: {}", (Object)variableParameter, (Object)e);
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter getDqlByDml(VariableParameter variableParameter) {
        Pointer p = null;
        String resultString = "";
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        try {
            Object object;
            if (MultiProperties.RUN_WHAT == 2) {
                object = GO_SYNCHRONIZED_LOCK;
                synchronized (object) {
                    p = parser.GetDqlByDml(encode);
                }
            } else {
                p = parser.GetDqlByDml(encode);
            }
            resultString = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            object = ReturnParameter.decode(resultString);
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, resultString));
        }
        finally {
            if (p != null) {
                parser.FreePointer(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableName(VariableParameter variableParameter) {
        String key;
        Transformer.TableNameValue parameter;
        String cacheKey = "";
        if (Transformer.globalStaticParameter.getIsCache() == 1 && (parameter = (Transformer.TableNameValue)TableNameCache.get((Object)(cacheKey = Murmur32HashFunction.calcHash(key = String.join((CharSequence)":", variableParameter.getSourceDialect(), variableParameter.getTargetDialect(), variableParameter.getSourceSql()))))) != null && parameter.sourceSql.equals(variableParameter.getSourceSql())) {
            return parameter.tableNames;
        }
        String encode = variableParameter.encode();
        Pointer p = null;
        IGoParser parser = GoParserFactory.getGoParser();
        try {
            Object object;
            if (MultiProperties.RUN_WHAT == 2) {
                object = GO_SYNCHRONIZED_LOCK;
                synchronized (object) {
                    p = parser.GetTableName(encode);
                }
            } else {
                p = parser.GetTableName(encode);
            }
            String tableNames = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            if (Transformer.globalStaticParameter.getIsCache() == 1) {
                TableNameCache.put((Object)cacheKey, (Object)new Transformer.TableNameValue(variableParameter.getSourceSql(), tableNames));
            }
            object = tableNames;
            return object;
        }
        finally {
            if (p != null) {
                parser.FreePointer(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter IdentifySqlType(VariableParameter variableParameter) {
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        Pointer p = null;
        String resultString = "";
        try {
            Object object;
            if (MultiProperties.RUN_WHAT == 2) {
                object = GO_SYNCHRONIZED_LOCK;
                synchronized (object) {
                    p = parser.UnisqlIdentifySQLType(encode);
                }
            } else {
                p = parser.UnisqlIdentifySQLType(encode);
            }
            resultString = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            object = ReturnParameter.decode(resultString);
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, resultString));
        }
        finally {
            if (p != null) {
                parser.FreePointer(p);
            }
        }
    }

    public static void cleanCache() {
        if (log.isInfoEnabled()) {
            log.info("\u5f00\u59cb\u6e05\u7406\u7f13\u5b58\uff0c\u5f53\u524d\u7f13\u5b58\u6570\u91cf\uff1a" + Cache.size());
        }
        Cache.clear();
        if (log.isInfoEnabled()) {
            log.info("\u6e05\u7406\u7f13\u5b58\u7ed3\u675f\uff0c\u5f53\u524d\u7f13\u5b58\u6570\u91cf\uff1a" + Cache.size());
        }
    }

    private static ReturnParameter returnSourceSql(String sql) {
        ReturnParameter returnParameter = new ReturnParameter();
        returnParameter.setSourceSql(sql);
        returnParameter.setTargetSql(sql);
        returnParameter.setState(SUCCESS_CODE);
        returnParameter.setMessage(SUCCESS_MESSAGE);
        return returnParameter;
    }

    private static boolean matchesLastInsertIdSql(String sql) {
        if (sql == null) {
            return false;
        }
        Matcher matcher = LAST_INSERT_ID_PATTERN.matcher(sql);
        return matcher.matches();
    }

    public static void main(String[] args) {
        System.out.println(TransformerInternal.matchesInsertValuesSql("SELECT unisql.LAST_INSERT_ID('T_USER') AS LAST_INSERT_ID FROM DUAL"));
    }

    private static boolean matchesInsertValuesSql(String sql) {
        if (sql == null) {
            return false;
        }
        Matcher matcher = INSERT_VALUES_PATTERN.matcher(sql);
        return matcher.matches();
    }

    private static String[] splitSqlByLastSemicolon(String sql) {
        if (sql == null || sql.isEmpty()) {
            return new String[]{sql};
        }
        int lastIndex = sql.lastIndexOf(59);
        if (lastIndex == -1) {
            return new String[]{sql};
        }
        String firstPart = sql.substring(0, lastIndex).trim();
        String secondPart = sql.substring(lastIndex + 1).trim();
        return new String[]{firstPart, secondPart};
    }

    public static void setGenLastInsertIdSql(String sql) {
        genLastInsertIdSql.set(sql);
    }

    public static String getGenLastInsertIdSql() {
        return genLastInsertIdSql.get();
    }

    public static void removeGenLastInsertIdSql() {
        genLastInsertIdSql.remove();
    }

    static {
        Cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).weigher(Weighers.singleton()).build();
        TableNameCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000L).weigher(Weighers.singleton()).build();
        LAST_INSERT_ID_PATTERN = Pattern.compile("^\\s*SELECT\\s+LAST_INSERT_ID\\s*\\(\\s*\\)\\s*;?\\s*$", 2);
        INSERT_VALUES_PATTERN = Pattern.compile("^\\s*INSERT\\s+INTO\\s+(.+?)\\s+(VALUES)\\s*\\((.+?)\\)\\s*;?\\s*$", 34);
        genLastInsertIdSql = ThreadLocal.withInitial(() -> null);
    }
}

