/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Encoder {
    protected static final int INT = 1;
    protected static final int STRING = 2;
    protected static final int BOOL = 3;
    protected static final int NULL = 4;
    protected static final int INT_ARRAY = 5;
    protected static final int INT64 = 6;
    protected static final int VERSION = 250201;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public Encoder() {
        this.writeIntValue(250201);
        this.writeIntValue(0);
    }

    public void writeInt(int value) {
        int tag = 0x10000000;
        this.writeIntValue(tag);
        this.writeIntValue(value);
    }

    private void writeIntValue(int value) {
        this.outputStream.write(value & 0xFF);
        this.outputStream.write(value >> 8 & 0xFF);
        this.outputStream.write(value >> 16 & 0xFF);
        this.outputStream.write(value >> 24 & 0xFF);
    }

    public void writeNull() {
        int tag = 0x40000000;
        this.writeIntValue(tag);
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.writeNull();
            return;
        }
        byte[] byteValue = value.getBytes(StandardCharsets.UTF_8);
        if (byteValue.length > 0xFFFFFFF) {
            throw new IllegalArgumentException("String length exceeds maximum value");
        }
        int tag = 0x20000000 | byteValue.length;
        this.writeIntValue(tag);
        this.outputStream.write(byteValue);
    }

    public void writeBool(boolean value) {
        int tag = 0x30000000;
        this.writeIntValue(tag);
        this.outputStream.write(value ? 1 : 0);
    }

    public void writeInt64(long value) {
        int tag = 0x60000000;
        this.writeIntValue(tag);
        this.outputStream.write((int)(value & 0xFFL));
        this.outputStream.write((int)(value >> 8) & 0xFF);
        this.outputStream.write((int)(value >> 16) & 0xFF);
        this.outputStream.write((int)(value >> 24) & 0xFF);
        this.outputStream.write((int)(value >> 32) & 0xFF);
        this.outputStream.write((int)(value >> 40) & 0xFF);
        this.outputStream.write((int)(value >> 48) & 0xFF);
        this.outputStream.write((int)(value >> 56) & 0xFF);
    }

    public byte[] toByteArray() {
        byte[] data = this.outputStream.toByteArray();
        if (data.length < 8) {
            throw new IllegalArgumentException("Data length is less than 8");
        }
        data[4] = (byte)(data.length & 0xFF);
        data[5] = (byte)(data.length >> 8 & 0xFF);
        data[6] = (byte)(data.length >> 16 & 0xFF);
        data[7] = (byte)(data.length >> 24 & 0xFF);
        return data;
    }
}

