/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import shaded.net.sf.jsqlparser.expression.Alias;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.OracleHint;
import shaded.net.sf.jsqlparser.schema.Table;
import shaded.net.sf.jsqlparser.statement.OutputClause;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.merge.MergeInsert;
import shaded.net.sf.jsqlparser.statement.merge.MergeUpdate;
import shaded.net.sf.jsqlparser.statement.select.FromItem;
import shaded.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import shaded.net.sf.jsqlparser.statement.select.WithItem;

public class Merge
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private OracleHint oracleHint = null;
    private FromItem fromItem;
    private Expression onCondition;
    private MergeInsert mergeInsert;
    private MergeUpdate mergeUpdate;
    private boolean insertFirst = false;
    private OutputClause outputClause;

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Merge withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public Merge addWithItemsList(WithItem ... withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemsList);
        return this.withWithItemsList(collection);
    }

    public Merge addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    @Deprecated
    public Table getUsingTable() {
        return this.fromItem instanceof Table ? (Table)this.fromItem : null;
    }

    @Deprecated
    public void setUsingTable(Table usingTable) {
        this.fromItem = usingTable;
    }

    @Deprecated
    public void setUsingSelect(ParenthesedSelect usingSelect) {
        this.fromItem = usingSelect;
    }

    @Deprecated
    public Alias getUsingAlias() {
        return this.fromItem.getAlias();
    }

    @Deprecated
    public void setUsingAlias(Alias usingAlias) {
        this.fromItem.setAlias(usingAlias);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public Merge withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public void setOnCondition(Expression onCondition) {
        this.onCondition = onCondition;
    }

    public MergeInsert getMergeInsert() {
        return this.mergeInsert;
    }

    public void setMergeInsert(MergeInsert insert) {
        this.mergeInsert = insert;
    }

    public MergeUpdate getMergeUpdate() {
        return this.mergeUpdate;
    }

    public void setMergeUpdate(MergeUpdate mergeUpdate) {
        this.mergeUpdate = mergeUpdate;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    public void setInsertFirst(boolean insertFirst) {
        this.insertFirst = insertFirst;
    }

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public Merge setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            b.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                b.append(withItem);
                if (iter.hasNext()) {
                    b.append(",");
                }
                b.append(" ");
            }
        }
        b.append("MERGE ");
        if (this.oracleHint != null) {
            b.append(this.oracleHint).append(" ");
        }
        b.append("INTO ");
        b.append(this.table);
        b.append(" USING ");
        b.append(this.fromItem);
        b.append(" ON ");
        b.append(this.onCondition);
        if (this.insertFirst && this.mergeInsert != null) {
            b.append(this.mergeInsert);
        }
        if (this.mergeUpdate != null) {
            b.append(this.mergeUpdate);
        }
        if (!this.insertFirst && this.mergeInsert != null) {
            b.append(this.mergeInsert);
        }
        if (this.outputClause != null) {
            b.append(this.outputClause);
        }
        return b.toString();
    }

    @Deprecated
    public Merge withUsingTable(Table usingTable) {
        this.setUsingTable(usingTable);
        return this;
    }

    @Deprecated
    public Merge withUsingSelect(ParenthesedSelect usingSelect) {
        this.setUsingSelect(usingSelect);
        return this;
    }

    @Deprecated
    public Merge withUsingAlias(Alias usingAlias) {
        this.setUsingAlias(usingAlias);
        return this;
    }

    public Merge withOnCondition(Expression onCondition) {
        this.setOnCondition(onCondition);
        return this;
    }

    public Merge withMergeUpdate(MergeUpdate mergeUpdate) {
        this.setMergeUpdate(mergeUpdate);
        return this;
    }

    public Merge withInsertFirst(boolean insertFirst) {
        this.setInsertFirst(insertFirst);
        return this;
    }

    public Merge withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Merge withMergeInsert(MergeInsert mergeInsert) {
        this.setMergeInsert(mergeInsert);
        return this;
    }

    public <E extends Expression> E getOnCondition(Class<E> type) {
        return (E)((Expression)type.cast(this.getOnCondition()));
    }
}

