/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.statement.execute;

import java.util.List;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;

public class Execute
implements Statement {
    private ExecType execType = ExecType.EXECUTE;
    private String name;
    private ExpressionList exprList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(List<String> names) {
        for (String item : names) {
            if (this.name != null) {
                this.name = this.name + "." + item;
                continue;
            }
            this.name = item;
        }
    }

    public ExpressionList getExprList() {
        return this.exprList;
    }

    public void setExprList(ExpressionList exprList) {
        this.exprList = exprList;
    }

    public ExecType getExecType() {
        return this.execType;
    }

    public void setExecType(ExecType execType) {
        this.execType = execType;
    }

    @Deprecated
    public boolean isParenthesis() {
        return this.exprList instanceof ParenthesedExpressionList;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        return this.execType.name() + " " + this.name + (this.exprList != null ? " " + PlainSelect.getStringList(this.exprList, true, this.exprList instanceof ParenthesedExpressionList) : "");
    }

    public Execute withExecType(ExecType execType) {
        this.setExecType(execType);
        return this;
    }

    public Execute withName(String name) {
        this.setName(name);
        return this;
    }

    public Execute withExprList(ExpressionList exprList) {
        this.setExprList(exprList);
        return this;
    }

    public static enum ExecType {
        EXECUTE,
        EXEC,
        CALL;


        public static ExecType from(String type) {
            return Enum.valueOf(ExecType.class, type.toUpperCase());
        }
    }
}

