/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.ExpressionVisitor;
import shaded.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JsonExpression
extends ASTNodeAccessImpl
implements Expression {
    private Expression expr;
    private final List<Map.Entry<String, String>> idents = new ArrayList<Map.Entry<String, String>>();

    public JsonExpression() {
    }

    public JsonExpression(Expression expr) {
        this.expr = expr;
    }

    public JsonExpression(Expression expr, List<Map.Entry<String, String>> idents) {
        this.expr = expr;
        this.idents.addAll(idents);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public void addIdent(String ident, String operator) {
        this.idents.add(new AbstractMap.SimpleEntry<String, String>(ident, operator));
    }

    public void addAllIdents(Collection<Map.Entry<String, String>> idents) {
        this.idents.addAll(idents);
    }

    public List<Map.Entry<String, String>> getIdentList() {
        return this.idents;
    }

    public Map.Entry<String, String> getIdent(int index) {
        return this.idents.get(index);
    }

    @Deprecated
    public List<String> getIdents() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> ident : this.idents) {
            l.add(ident.getKey());
        }
        return l;
    }

    @Deprecated
    public List<String> getOperators() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> ident : this.idents) {
            l.add(ident.getValue());
        }
        return l;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.expr.toString());
        for (Map.Entry<String, String> ident : this.idents) {
            b.append(ident.getValue()).append(ident.getKey());
        }
        return b.toString();
    }

    public JsonExpression withExpression(Expression expr) {
        this.setExpression(expr);
        return this;
    }
}

