/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shaded.net.sf.jsqlparser.statement.create.table.ColDataType;

public class Alias
implements Serializable {
    private String name;
    private boolean useAs = true;
    private List<AliasColumn> aliasColumns;

    public Alias(String name) {
        this.name = name;
    }

    public Alias(String name, boolean useAs) {
        this.name = name;
        this.useAs = useAs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseAs() {
        return this.useAs;
    }

    public void setUseAs(boolean useAs) {
        this.useAs = useAs;
    }

    public List<AliasColumn> getAliasColumns() {
        return this.aliasColumns;
    }

    public void setAliasColumns(List<AliasColumn> aliasColumns) {
        this.aliasColumns = aliasColumns;
    }

    public String toString() {
        String alias = (this.useAs ? " AS " : " ") + this.name;
        if (this.aliasColumns != null && !this.aliasColumns.isEmpty()) {
            String ac = "";
            for (AliasColumn col : this.aliasColumns) {
                if (ac.length() > 0) {
                    ac = ac + ", ";
                }
                ac = ac + col.name;
                if (col.colDataType == null) continue;
                ac = ac + " " + col.colDataType.toString();
            }
            alias = alias + "(" + ac + ")";
        }
        return alias;
    }

    public Alias withName(String name) {
        this.setName(name);
        return this;
    }

    public Alias withUseAs(boolean useAs) {
        this.setUseAs(useAs);
        return this;
    }

    public Alias withAliasColumns(List<AliasColumn> aliasColumns) {
        this.setAliasColumns(aliasColumns);
        return this;
    }

    public Alias addAliasColumns(AliasColumn ... aliasColumns) {
        List collection = Optional.ofNullable(this.getAliasColumns()).orElseGet(ArrayList::new);
        Collections.addAll(collection, aliasColumns);
        return this.withAliasColumns(collection);
    }

    public Alias addAliasColumns(Collection<? extends AliasColumn> aliasColumns) {
        List collection = Optional.ofNullable(this.getAliasColumns()).orElseGet(ArrayList::new);
        collection.addAll(aliasColumns);
        return this.withAliasColumns(collection);
    }

    public static class AliasColumn
    implements Serializable {
        public final String name;
        public final ColDataType colDataType;

        public AliasColumn(String name, ColDataType colDataType) {
            Objects.requireNonNull(name);
            this.name = name;
            this.colDataType = colDataType;
        }

        public AliasColumn(String name) {
            this(name, null);
        }
    }
}

