/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FieldWriterEnumMethod
extends FieldWriterEnum {
    final Method method;

    protected FieldWriterEnumMethod(String name, int ordinal, long features, String format, String label, Class fieldType, Method method) {
        super(name, ordinal, features, format, label, fieldType);
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.name, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        Enum value = (Enum)this.getFieldValue(object);
        jsonWriter.writeEnum(value);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, Object object) {
        Enum value = (Enum)this.getFieldValue(object);
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNull();
                return true;
            }
            return false;
        }
        this.writeEnum(jsonWriter, value);
        return true;
    }
}

