/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class JodaSupport {
    static final long HASH_YEAR = Fnv.hashCode64("year");
    static final long HASH_MONTH = Fnv.hashCode64("month");
    static final long HASH_DAY = Fnv.hashCode64("day");
    static final long HASH_HOUR = Fnv.hashCode64("hour");
    static final long HASH_MINUTE = Fnv.hashCode64("minute");
    static final long HASH_SECOND = Fnv.hashCode64("second");
    static final long HASH_MILLIS = Fnv.hashCode64("millis");
    static final long HASH_CHRONOLOGY = Fnv.hashCode64("chronology");

    public static ObjectWriter createLocalDateTimeWriter(Class objectClass, String format) {
        return new LocalDateTimeWriter(objectClass, format);
    }

    public static ObjectWriter createLocalDateWriter(Class objectClass, String format) {
        return new LocalDateWriter(objectClass, format);
    }

    public static ObjectReader createChronologyReader(Class objectClass) {
        return new ChronologyReader(objectClass);
    }

    public static ObjectReader createLocalDateReader(Class objectClass) {
        return new LocalDateReader(objectClass);
    }

    public static ObjectReader createLocalDateTimeReader(Class objectClass) {
        return new LocalDateTimeReader(objectClass);
    }

    public static ObjectReader createInstantReader(Class objectClass) {
        return new InstantReader(objectClass);
    }

    public static ObjectWriter createGregorianChronologyWriter(Class objectClass) {
        return new GregorianChronologyWriter(objectClass);
    }

    public static ObjectWriter createISOChronologyWriter(Class objectClass) {
        return new ISOChronologyWriter(objectClass);
    }

    static class LocalDateTimeWriter
    extends DateTimeCodec
    implements ObjectWriter {
        final Class objectClass;
        final Method getYear;
        final Method getMonthOfYear;
        final Method getDayOfMonth;
        final Method getHourOfDay;
        final Method getMinuteOfHour;
        final Method getSecondOfMinute;
        final Method getMillisOfSecond;
        final Method getChronology;
        final Class isoChronology;
        final Object utc;

        LocalDateTimeWriter(Class objectClass, String fromat) {
            super(fromat);
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.isoChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                Object instance = this.isoChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                this.utc = this.isoChronology.getMethod("withUTC", new Class[0]).invoke(instance, new Object[0]);
                this.getYear = objectClass.getMethod("getYear", new Class[0]);
                this.getMonthOfYear = objectClass.getMethod("getMonthOfYear", new Class[0]);
                this.getDayOfMonth = objectClass.getMethod("getDayOfMonth", new Class[0]);
                this.getHourOfDay = objectClass.getMethod("getHourOfDay", new Class[0]);
                this.getMinuteOfHour = objectClass.getMethod("getMinuteOfHour", new Class[0]);
                this.getSecondOfMinute = objectClass.getMethod("getSecondOfMinute", new Class[0]);
                this.getMillisOfSecond = objectClass.getMethod("getMillisOfSecond", new Class[0]);
                this.getChronology = objectClass.getMethod("getChronology", new Class[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                int hour = (Integer)this.getHourOfDay.invoke(object, new Object[0]);
                int minute = (Integer)this.getMinuteOfHour.invoke(object, new Object[0]);
                int second = (Integer)this.getSecondOfMinute.invoke(object, new Object[0]);
                int millis = (Integer)this.getMillisOfSecond.invoke(object, new Object[0]);
                Object chronology = this.getChronology.invoke(object, new Object[0]);
                if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                    jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
                }
                if (chronology == this.utc || chronology == null) {
                    jsonWriter.writeLocalDateTime(LocalDateTime.of(year, monthOfYear, dayOfMonth, hour, minute, second, millis * 1000000));
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("hour");
                jsonWriter.writeInt32(hour);
                jsonWriter.writeName("minute");
                jsonWriter.writeInt32(minute);
                jsonWriter.writeName("second");
                jsonWriter.writeInt32(second);
                jsonWriter.writeName("millis");
                jsonWriter.writeInt32(millis);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                int hour = (Integer)this.getHourOfDay.invoke(object, new Object[0]);
                int minute = (Integer)this.getMinuteOfHour.invoke(object, new Object[0]);
                int second = (Integer)this.getSecondOfMinute.invoke(object, new Object[0]);
                int millis = (Integer)this.getMillisOfSecond.invoke(object, new Object[0]);
                Object chronology = this.getChronology.invoke(object, new Object[0]);
                if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                    jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
                }
                if (chronology == this.utc || chronology == null) {
                    int nanoOfSecond = millis * 1000000;
                    LocalDateTime ldt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hour, minute, second, nanoOfSecond);
                    DateTimeFormatter formatter = this.getDateFormatter();
                    if (formatter == null) {
                        formatter = jsonWriter.getContext().getDateFormatter();
                    }
                    if (formatter == null) {
                        jsonWriter.writeLocalDateTime(ldt);
                        return;
                    }
                    String str = formatter.format(ldt);
                    jsonWriter.writeString(str);
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("hour");
                jsonWriter.writeInt32(hour);
                jsonWriter.writeName("minute");
                jsonWriter.writeInt32(minute);
                jsonWriter.writeName("second");
                jsonWriter.writeInt32(second);
                jsonWriter.writeName("millis");
                jsonWriter.writeInt32(millis);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }
    }

    static class LocalDateWriter
    extends DateTimeCodec
    implements ObjectWriter {
        final Class objectClass;
        final Method getYear;
        final Method getMonthOfYear;
        final Method getDayOfMonth;
        final Method getChronology;
        final Class isoChronology;
        final Object utc;

        LocalDateWriter(Class objectClass, String format) {
            super(format);
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.isoChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                Object instance = this.isoChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                this.utc = this.isoChronology.getMethod("withUTC", new Class[0]).invoke(instance, new Object[0]);
                this.getYear = objectClass.getMethod("getYear", new Class[0]);
                this.getMonthOfYear = objectClass.getMethod("getMonthOfYear", new Class[0]);
                this.getDayOfMonth = objectClass.getMethod("getDayOfMonth", new Class[0]);
                this.getChronology = objectClass.getMethod("getChronology", new Class[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                Object chronology = this.getChronology.invoke(object, new Object[0]);
                if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                    jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
                }
                if (chronology == this.utc || chronology == null) {
                    jsonWriter.writeLocalDate(LocalDate.of(year, monthOfYear, dayOfMonth));
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                Object chronology = this.getChronology.invoke(object, new Object[0]);
                if (chronology == this.utc || chronology == null) {
                    LocalDate localDate = LocalDate.of(year, monthOfYear, dayOfMonth);
                    DateTimeFormatter formatter = this.getDateFormatter();
                    if (formatter == null) {
                        formatter = jsonWriter.getContext().getDateFormatter();
                    }
                    if (formatter == null) {
                        jsonWriter.writeLocalDate(localDate);
                        return;
                    }
                    String str = formatter.format(localDate);
                    jsonWriter.writeString(str);
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }
    }

    static class ChronologyReader
    implements ObjectReader {
        static final long HASH_MINIMUM_DAYS_IN_FIRST_WEEK = Fnv.hashCode64("minimumDaysInFirstWeek");
        static final long HASH_ZONE_ID = Fnv.hashCode64("zoneId");
        final Class objectClass;
        final Class gregorianChronology;
        final Class dateTimeZone;
        final Method forID;
        final Method getInstance;
        final Object utc;

        ChronologyReader(Class objectClass) {
            this.objectClass = objectClass;
            ClassLoader classLoader = objectClass.getClassLoader();
            try {
                this.gregorianChronology = classLoader.loadClass("org.joda.time.chrono.GregorianChronology");
                this.dateTimeZone = classLoader.loadClass("org.joda.time.DateTimeZone");
                this.utc = this.gregorianChronology.getMethod("getInstanceUTC", new Class[0]).invoke(null, new Object[0]);
                this.forID = this.dateTimeZone.getMethod("forID", String.class);
                this.getInstance = this.gregorianChronology.getMethod("getInstance", this.dateTimeZone);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create ChronologyReader error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            Integer minimumDaysInFirstWeek = null;
            String zoneId = null;
            jsonReader.nextIfObjectStart();
            while (!jsonReader.nextIfObjectEnd()) {
                long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                if (fieldNameHashCode == HASH_MINIMUM_DAYS_IN_FIRST_WEEK) {
                    minimumDaysInFirstWeek = jsonReader.readInt32Value();
                    continue;
                }
                if (fieldNameHashCode == HASH_ZONE_ID) {
                    zoneId = jsonReader.readString();
                    continue;
                }
                throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
            }
            if (minimumDaysInFirstWeek == null) {
                if ("UTC".equals(zoneId)) {
                    return this.utc;
                }
                try {
                    Object datetimeZone = this.forID.invoke(null, zoneId);
                    return this.getInstance.invoke(null, datetimeZone);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            throw new JSONException(jsonReader.info("not support"));
        }
    }

    static class LocalDateReader
    implements ObjectReader {
        final Class objectClass;
        final Constructor constructor3;
        final Constructor constructor4;
        final Class classISOChronology;
        final Class classChronology;
        final Object utc;

        LocalDateReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.classChronology = classLoader.loadClass("org.joda.time.Chronology");
                this.constructor3 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.constructor4 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, this.classChronology);
                this.classISOChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                this.utc = this.classISOChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            LocalDate localDate = jsonReader.readLocalDate();
            if (localDate == null) {
                return null;
            }
            try {
                return this.constructor4.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), null);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
            }
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            byte type = jsonReader.getType();
            if (type == -87) {
                LocalDate localDate = jsonReader.readLocalDate();
                try {
                    return this.constructor3.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (jsonReader.isObject()) {
                Integer year = null;
                Integer month = null;
                Integer day = null;
                Object chronology = null;
                jsonReader.nextIfObjectStart();
                while (!jsonReader.nextIfObjectEnd()) {
                    long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                    if (fieldNameHashCode == HASH_YEAR) {
                        year = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MONTH) {
                        month = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_DAY) {
                        day = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_CHRONOLOGY) {
                        chronology = jsonReader.read(this.classChronology);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
                }
                try {
                    return this.constructor4.newInstance(year, month, day, chronology);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support " + JSONB.typeName(type)));
        }
    }

    static class LocalDateTimeReader
    implements ObjectReader {
        final Class objectClass;
        final Constructor constructor7;
        final Constructor constructor8;
        final Class classISOChronology;
        final Class classChronology;
        final Object utc;

        LocalDateTimeReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.classChronology = classLoader.loadClass("org.joda.time.Chronology");
                this.constructor7 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.constructor8 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, this.classChronology);
                this.classISOChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                this.utc = this.classISOChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.isString() || jsonReader.isInt()) {
                LocalDateTime ldt = jsonReader.readLocalDateTime();
                if (ldt == null) {
                    return null;
                }
                try {
                    return this.constructor7.newInstance(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano() / 1000000);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            byte type = jsonReader.getType();
            if (type == -87) {
                LocalDate localDate = jsonReader.readLocalDate();
                try {
                    return this.constructor7.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), 0, 0, 0, 0);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (type == -88) {
                LocalDateTime ldt = jsonReader.readLocalDateTime();
                try {
                    return this.constructor7.newInstance(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano() / 1000000);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (jsonReader.isObject()) {
                Integer year = null;
                Integer month = null;
                Integer day = null;
                Integer hour = null;
                Integer minute = null;
                Integer second = null;
                Integer millis = null;
                Object chronology = null;
                jsonReader.nextIfObjectStart();
                while (!jsonReader.nextIfObjectEnd()) {
                    long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                    if (fieldNameHashCode == HASH_YEAR) {
                        year = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MONTH) {
                        month = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_DAY) {
                        day = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_HOUR) {
                        hour = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MINUTE) {
                        minute = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_SECOND) {
                        second = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MILLIS) {
                        millis = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_CHRONOLOGY) {
                        chronology = jsonReader.read(this.classChronology);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
                }
                try {
                    return this.constructor8.newInstance(year, month, day, hour, minute, second, millis, chronology);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support " + JSONB.typeName(type)));
        }
    }

    static class InstantReader
    implements ObjectReader {
        final Class objectClass;
        final Constructor constructor;

        InstantReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.constructor = objectClass.getConstructor(Long.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("create joda instant reader error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object createInstance(Map map, long features) {
            Long millis = (Long)map.get("millis");
            if (millis != null) {
                return this.createInstanceFromMillis(millis);
            }
            Number epochSecond = (Number)map.get("epochSecond");
            if (epochSecond != null) {
                long epochMillis = epochSecond.longValue() * 1000L;
                return this.createInstanceFromMillis(epochMillis);
            }
            throw new JSONException("create joda instant error");
        }

        public Object createInstanceFromMillis(long millis) {
            try {
                return this.constructor.newInstance(millis);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("create joda instant error", e);
            }
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return this.createInstanceFromMillis(millis);
            }
            if (jsonReader.isString()) {
                Instant jdkInstant = jsonReader.readInstant();
                if (jdkInstant == null) {
                    return null;
                }
                long millis = jdkInstant.toEpochMilli();
                return this.createInstanceFromMillis(millis);
            }
            if (jsonReader.isObject()) {
                Map<String, Object> object = jsonReader.readObject();
                return this.createInstance(object, features);
            }
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            return this.readObject(jsonReader, fieldType, fieldName, features);
        }
    }

    static class GregorianChronologyWriter
    implements ObjectWriter {
        final Class objectClass;
        final Method getMinimumDaysInFirstWeek;
        final Method getZone;
        final Method getID;

        GregorianChronologyWriter(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.getMinimumDaysInFirstWeek = objectClass.getMethod("getMinimumDaysInFirstWeek", new Class[0]);
                this.getZone = objectClass.getMethod("getZone", new Class[0]);
                this.getID = this.getZone.getReturnType().getMethod("getID", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("getMethod error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                Object zone = this.getZone.invoke(object, new Object[0]);
                String zoneId = (String)this.getID.invoke(zone, new Object[0]);
                int minDaysInFirstWeek = (Integer)this.getMinimumDaysInFirstWeek.invoke(object, new Object[0]);
                if (minDaysInFirstWeek == 4) {
                    jsonWriter.startObject();
                    jsonWriter.writeName("zoneId");
                    jsonWriter.writeString(zoneId);
                    jsonWriter.endObject();
                } else {
                    jsonWriter.startObject();
                    jsonWriter.writeName("minimumDaysInFirstWeek");
                    jsonWriter.writeInt32(minDaysInFirstWeek);
                    jsonWriter.writeName("zoneId");
                    jsonWriter.writeString(zoneId);
                    jsonWriter.endObject();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write joda GregorianChronology error", e);
            }
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                Object zone = this.getZone.invoke(object, new Object[0]);
                String zoneId = (String)this.getID.invoke(zone, new Object[0]);
                int minDaysInFirstWeek = (Integer)this.getMinimumDaysInFirstWeek.invoke(object, new Object[0]);
                jsonWriter.startObject();
                jsonWriter.writeName("minimumDaysInFirstWeek");
                jsonWriter.writeInt32(minDaysInFirstWeek);
                jsonWriter.writeName("zoneId");
                jsonWriter.writeString(zoneId);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write joda GregorianChronology error", e);
            }
        }
    }

    static class ISOChronologyWriter
    implements ObjectWriter {
        final Class objectClass;
        final Method getZone;
        final Method getID;

        ISOChronologyWriter(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.getZone = objectClass.getMethod("getZone", new Class[0]);
                this.getID = this.getZone.getReturnType().getMethod("getID", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("getMethod error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                Object zone = this.getZone.invoke(object, new Object[0]);
                String zoneId = (String)this.getID.invoke(zone, new Object[0]);
                jsonWriter.startObject();
                jsonWriter.writeName("zoneId");
                jsonWriter.writeString(zoneId);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write joda GregorianChronology error", e);
            }
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                Object zone = this.getZone.invoke(object, new Object[0]);
                String zoneId = (String)this.getID.invoke(zone, new Object[0]);
                jsonWriter.startObject();
                jsonWriter.writeName("zoneId");
                jsonWriter.writeString(zoneId);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write joda GregorianChronology error", e);
            }
        }
    }
}

