/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.AnyOf;
import com.alibaba.fastjson2.schema.DateTimeValidator;
import com.alibaba.fastjson2.schema.DateValidator;
import com.alibaba.fastjson2.schema.DurationValidator;
import com.alibaba.fastjson2.schema.EmailValidator;
import com.alibaba.fastjson2.schema.FormatValidator;
import com.alibaba.fastjson2.schema.IPAddressValidator;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.OneOf;
import com.alibaba.fastjson2.schema.TimeValidator;
import com.alibaba.fastjson2.schema.URIValidator;
import com.alibaba.fastjson2.schema.UUIDValidator;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.util.Objects;
import java.util.regex.Pattern;

final class StringSchema
extends JSONSchema {
    final int maxLength;
    final int minLength;
    final String format;
    final String patternFormat;
    final Pattern pattern;
    final boolean typed;
    final AnyOf anyOf;
    final OneOf oneOf;
    final FormatValidator formatValidator;

    StringSchema(JSONObject input) {
        super(input);
        this.typed = "string".equalsIgnoreCase(input.getString("type"));
        this.minLength = input.getIntValue("minLength", -1);
        this.maxLength = input.getIntValue("maxLength", -1);
        this.patternFormat = input.getString("pattern");
        this.pattern = this.patternFormat == null ? null : Pattern.compile(this.patternFormat);
        this.format = input.getString("format");
        Object anyOf = input.get("anyOf");
        this.anyOf = anyOf instanceof JSONArray ? StringSchema.anyOf((JSONArray)anyOf, String.class) : null;
        Object oneOf = input.get("oneOf");
        this.oneOf = oneOf instanceof JSONArray ? StringSchema.oneOf((JSONArray)oneOf, String.class) : null;
        if (this.format == null) {
            this.formatValidator = null;
        } else {
            switch (this.format) {
                case "email": {
                    this.formatValidator = EmailValidator.INSTANCE;
                    break;
                }
                case "ipv4": {
                    this.formatValidator = IPAddressValidator.IPV4;
                    break;
                }
                case "ipv6": {
                    this.formatValidator = IPAddressValidator.IPV6;
                    break;
                }
                case "uri": {
                    this.formatValidator = URIValidator.INSTANCE;
                    break;
                }
                case "date-time": {
                    this.formatValidator = DateTimeValidator.INSTANCE;
                    break;
                }
                case "date": {
                    this.formatValidator = DateValidator.INSTANCE;
                    break;
                }
                case "time": {
                    this.formatValidator = TimeValidator.INSTANCE;
                    break;
                }
                case "duration": {
                    this.formatValidator = DurationValidator.INSTANCE;
                    break;
                }
                case "uuid": {
                    this.formatValidator = UUIDValidator.INSTANCE;
                    break;
                }
                default: {
                    this.formatValidator = null;
                }
            }
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.String;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (value == null) {
            if (this.typed) {
                return REQUIRED_NOT_MATCH;
            }
            return SUCCESS;
        }
        if (value instanceof String) {
            ValidateResult result;
            String str = (String)value;
            if (this.minLength >= 0 || this.maxLength >= 0) {
                int count = str.codePointCount(0, str.length());
                if (this.minLength >= 0 && count < this.minLength) {
                    return new ValidateResult(false, "minLength not match, expect >= %s, but %s", this.minLength, str.length());
                }
                if (this.maxLength >= 0 && count > this.maxLength) {
                    return new ValidateResult(false, "maxLength not match, expect <= %s, but %s", this.maxLength, str.length());
                }
            }
            if (this.pattern != null && !this.pattern.matcher(str).find()) {
                return new ValidateResult(false, "pattern not match, expect %, but %s", this.patternFormat, str);
            }
            if (this.formatValidator != null && !this.formatValidator.isValid(str)) {
                return new ValidateResult(false, "format not match, expect %, but %s", this.format, str);
            }
            if (this.anyOf != null && !(result = this.anyOf.validate(str)).isSuccess()) {
                return result;
            }
            if (this.oneOf != null && !(result = this.oneOf.validate(str)).isSuccess()) {
                return result;
            }
            return SUCCESS;
        }
        if (!this.typed) {
            return SUCCESS;
        }
        return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.String, value.getClass()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringSchema that = (StringSchema)o;
        return this.maxLength == that.maxLength && this.minLength == that.minLength && this.typed == that.typed && Objects.equals(this.format, that.format) && Objects.equals(this.patternFormat, that.patternFormat) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.formatValidator, that.formatValidator);
    }

    public int hashCode() {
        return Objects.hash(this.maxLength, this.minLength, this.format, this.patternFormat, this.pattern, this.typed, this.formatValidator);
    }
}

