/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectReaderInterface<T>
extends ObjectReaderAdapter<T> {
    public ObjectReaderInterface(Class objectClass, String typeKey, String typeName, long features, Supplier creator, Function buildFunction, FieldReader[] fieldReaders) {
        super(objectClass, typeKey, typeName, features, null, creator, buildFunction, fieldReaders);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        JSONObject object = jsonReader.read(JSONObject.class);
        return (T)Proxy.newProxyInstance(this.objectClass.getClassLoader(), new Class[]{this.objectClass}, (InvocationHandler)object);
    }

    @Override
    public T createInstance(long features) {
        JSONObject object = new JSONObject();
        return (T)Proxy.newProxyInstance(this.objectClass.getClassLoader(), new Class[]{this.objectClass}, (InvocationHandler)object);
    }

    @Override
    public T createInstance(Map map, long features) {
        JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
        return (T)Proxy.newProxyInstance(this.objectClass.getClassLoader(), new Class[]{this.objectClass}, (InvocationHandler)object);
    }
}

