/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderImpl;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;

final class FieldReaderAtomicLongArrayReadOnly<T>
extends FieldReaderImpl<T> {
    final Method method;

    FieldReaderAtomicLongArrayReadOnly(String fieldName, Class fieldType, int ordinal, JSONSchema jsonSchema, Method method) {
        super(fieldName, fieldType, fieldType, ordinal, 0L, null, null, null, jsonSchema);
        this.method = method;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        try {
            AtomicLongArray atomic = (AtomicLongArray)this.method.invoke(object, new Object[0]);
            if (value instanceof AtomicLongArray) {
                AtomicLongArray array = (AtomicLongArray)value;
                for (int i = 0; i < array.length(); ++i) {
                    atomic.set(i, array.get(i));
                }
            } else {
                List values = (List)value;
                for (int i = 0; i < values.size(); ++i) {
                    int itemValue = TypeUtils.toIntValue(values.get(i));
                    atomic.set(i, itemValue);
                }
            }
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        AtomicLongArray atomic;
        if (jsonReader.readIfNull()) {
            return;
        }
        try {
            atomic = (AtomicLongArray)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
        if (jsonReader.nextIfMatch('[')) {
            int i = 0;
            while (!jsonReader.nextIfMatch(']')) {
                long value = jsonReader.readInt64Value();
                if (atomic != null && i < atomic.length()) {
                    atomic.set(i, value);
                }
                ++i;
            }
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        return jsonReader.readArray((Type)((Object)Long.class));
    }

    @Override
    public String toString() {
        return this.method.getName();
    }
}

