/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.FDBigInteger;

final class FloatingDecimal {
    static final int DOUBLE_SIGNIFICAND_WIDTH = 53;
    static final int DOUBLE_EXP_BIAS = 1023;
    static final long DOUBLE_SIGN_BIT_MASK = Long.MIN_VALUE;
    static final long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
    static final long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    static final int FLOAT_SIGNIFICAND_WIDTH = 24;
    static final int FLOAT_EXP_BIAS = 127;
    static final int FLOAT_SIGNIF_BIT_MASK = 0x7FFFFF;
    static final int FLOAT_EXP_BIT_MASK = 2139095040;
    static final int FLOAT_SIGN_BIT_MASK = Integer.MIN_VALUE;
    static final int EXP_SHIFT = 52;
    static final long FRACT_HOB = 0x10000000000000L;
    static final int MAX_DECIMAL_DIGITS = 15;
    static final int MAX_DECIMAL_EXPONENT = 308;
    static final int MIN_DECIMAL_EXPONENT = -324;
    static final int MAX_NDIGITS = 1100;
    static final int SINGLE_EXP_SHIFT = 23;
    static final int SINGLE_FRACT_HOB = 0x800000;
    static final int SINGLE_MAX_DECIMAL_DIGITS = 7;
    static final int SINGLE_MAX_DECIMAL_EXPONENT = 38;
    static final int SINGLE_MIN_DECIMAL_EXPONENT = -45;
    static final int SINGLE_MAX_NDIGITS = 200;
    static final int INT_DECIMAL_DIGITS = 9;
    static final int BIG_DECIMAL_EXPONENT = 324;
    private static final double[] SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] SINGLE_SMALL_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final double[] BIG_10_POW = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final double[] TINY_10_POW = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int MAX_SMALL_TEN = SMALL_10_POW.length - 1;
    private static final int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;

    FloatingDecimal() {
    }

    public static double parseDouble(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return FloatingDecimal.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double parseDouble(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0;
                    }
                    return FloatingDecimal.doubleValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static double doubleValue(boolean isNegative, int decExp, char[] digits, int nDigits) {
        boolean overvalue;
        double t;
        int j;
        int kDigits = Math.min(nDigits, 16);
        int iValue = digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (int i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        long lValue = iValue;
        for (int i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(digits[i] - 48);
        }
        double dValue = lValue;
        int exp = decExp - kDigits;
        if (nDigits <= 15) {
            if (exp == 0 || dValue == 0.0) {
                return isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= MAX_SMALL_TEN) {
                    double rValue = dValue * SMALL_10_POW[exp];
                    return isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= MAX_SMALL_TEN + slop) {
                    double rValue = (dValue *= SMALL_10_POW[slop]) * SMALL_10_POW[exp - slop];
                    return isNegative ? -rValue : rValue;
                }
            } else if (exp >= -MAX_SMALL_TEN) {
                double rValue = dValue / SMALL_10_POW[-exp];
                return isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (decExp > 309) {
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * BIG_10_POW[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= BIG_10_POW[j])) {
                        return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExp < -325) {
                return isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * TINY_10_POW[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= TINY_10_POW[j]) == 0.0) {
                        return isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        if (nDigits > 1100) {
            nDigits = 1101;
            digits[1100] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(lValue, digits, kDigits, nDigits);
        exp = decExp - nDigits;
        long ieeeBits = Double.doubleToRawLongBits(dValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            int cmpResult;
            int binexp = (int)(ieeeBits >>> 52);
            long bigBbits = ieeeBits & 0xFFFFFFFFFFFFFL;
            if (binexp > 0) {
                bigBbits |= 0x10000000000000L;
            } else {
                assert (bigBbits != 0L) : bigBbits;
                int leadingZeros = Long.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 11;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Long.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 1023) - 52 + lowOrderZeros;
            int bigIntNBits = 53 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -1023 ? binexp + lowOrderZeros + 1023 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -1022 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult != 0) continue;
            if ((ieeeBits & 1L) == 0L) break;
            ieeeBits += overvalue ? -1L : 1L;
            break;
        } while ((ieeeBits += overvalue ? -1L : 1L) != 0L && ieeeBits != 0x7FF0000000000000L);
        if (isNegative) {
            ieeeBits |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(ieeeBits);
    }

    public static float parseFloat(char[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                char c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return FloatingDecimal.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float parseFloat(byte[] in, int off, int len) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            int end = off + len;
            try {
                boolean isZero;
                byte c;
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = off;
                switch (in[i]) {
                    case 45: {
                        isNegative = true;
                    }
                    case 43: {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < end) {
                    c = in[i];
                    if (c == 48) {
                        ++nLeadZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < end) {
                    c = in[i];
                    if (c >= 49 && c <= 57) {
                        digits[nDigits++] = (char)c;
                        nTrailZero = 0;
                    } else if (c == 48) {
                        digits[nDigits++] = (char)c;
                        ++nTrailZero;
                    } else {
                        if (c != 46) break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i - off;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block30;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < end && ((c = in[i]) == 101 || c == 69)) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in[++i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < end) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in[i++]) >= 48 && c <= 57) {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= end || i == end - 1) {
                    if (isZero) {
                        return 0.0f;
                    }
                    return FloatingDecimal.floatValue(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(in, off, len) + "\"");
    }

    public static float floatValue(boolean isNegative, int decExponent, char[] digits, int nDigits) {
        boolean overvalue;
        int j;
        int kDigits = Math.min(nDigits, 8);
        int iValue = digits[0] - 48;
        for (int i = 1; i < kDigits; ++i) {
            iValue = iValue * 10 + digits[i] - 48;
        }
        float fValue = iValue;
        int exp = decExponent - kDigits;
        if (nDigits <= 7) {
            if (exp == 0 || fValue == 0.0f) {
                return isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= SINGLE_MAX_SMALL_TEN) {
                    return isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= SINGLE_MAX_SMALL_TEN + slop) {
                    fValue *= SINGLE_SMALL_10_POW[slop];
                    return isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp - slop]);
                }
            } else if (exp >= -SINGLE_MAX_SMALL_TEN) {
                return isNegative ? -fValue : (fValue /= SINGLE_SMALL_10_POW[-exp]);
            }
        } else if (decExponent >= nDigits && nDigits + decExponent <= 15) {
            long lValue = iValue;
            for (int i = kDigits; i < nDigits; ++i) {
                lValue = lValue * 10L + (long)(digits[i] - 48);
            }
            double dValue = lValue;
            exp = decExponent - nDigits;
            fValue = (float)(dValue *= SMALL_10_POW[exp]);
            return isNegative ? -fValue : fValue;
        }
        double dValue = fValue;
        if (exp > 0) {
            if (decExponent > 39) {
                return isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= BIG_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        } else if (exp < 0) {
            exp = -exp;
            if (decExponent < -46) {
                return isNegative ? -0.0f : 0.0f;
            }
            if ((exp & 0xF) != 0) {
                dValue /= SMALL_10_POW[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 0) {
                    if ((exp & 1) != 0) {
                        dValue *= TINY_10_POW[j];
                    }
                    ++j;
                    exp >>= 1;
                }
            }
        }
        fValue = Math.max(Float.MIN_VALUE, Math.min(Float.MAX_VALUE, (float)dValue));
        if (nDigits > 200) {
            nDigits = 201;
            digits[200] = 49;
        }
        FDBigInteger bigD0 = new FDBigInteger(iValue, digits, kDigits, nDigits);
        exp = decExponent - nDigits;
        int ieeeBits = Float.floatToRawIntBits(fValue);
        int B5 = Math.max(0, -exp);
        int D5 = Math.max(0, exp);
        bigD0 = bigD0.multByPow52(D5, 0);
        bigD0.makeImmutable();
        FDBigInteger bigD = null;
        int prevD2 = 0;
        do {
            FDBigInteger diff;
            int cmpResult;
            int binexp = ieeeBits >>> 23;
            int bigBbits = ieeeBits & 0x7FFFFF;
            if (binexp > 0) {
                bigBbits |= 0x800000;
            } else {
                assert (bigBbits != 0) : bigBbits;
                int leadingZeros = Integer.numberOfLeadingZeros(bigBbits);
                int shift = leadingZeros - 8;
                bigBbits <<= shift;
                binexp = 1 - shift;
            }
            int lowOrderZeros = Integer.numberOfTrailingZeros(bigBbits);
            bigBbits >>>= lowOrderZeros;
            int bigIntExp = (binexp -= 127) - 23 + lowOrderZeros;
            int bigIntNBits = 24 - lowOrderZeros;
            int B2 = B5;
            int D2 = D5;
            if (bigIntExp >= 0) {
                B2 += bigIntExp;
            } else {
                D2 -= bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = binexp <= -127 ? binexp + lowOrderZeros + 127 : 1 + lowOrderZeros;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
            if (bigD == null || prevD2 != (D2 -= common2)) {
                bigD = bigD0.leftShift(D2);
                prevD2 = D2;
            }
            if ((cmpResult = bigB.cmp(bigD)) > 0) {
                overvalue = true;
                diff = bigB.leftInplaceSub(bigD);
                if (bigIntNBits == 1 && bigIntExp > -126 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff = diff.leftShift(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.rightInplaceSub(bigB);
            }
            if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
            if (cmpResult != 0) continue;
            if ((ieeeBits & 1) == 0) break;
            ieeeBits += overvalue ? -1 : 1;
            break;
        } while ((ieeeBits += overvalue ? -1 : 1) != 0 && ieeeBits != 2139095040);
        if (isNegative) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(ieeeBits);
    }
}

