-- SQL --  创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
            raise notice 'do not create schema unisql';
end if;
end $body$;

-- SQL --  创建to_number函数，临时修复缺陷：LIGHTDB-3308，只有在gaussdb-oracleV505.0版本才执行
DECLARE
    v_banner VARCHAR2(100);
    v_has_target BOOLEAN := FALSE;
BEGIN
    SELECT banner
    INTO v_banner
    FROM v$version
    WHERE banner LIKE 'gaussdb%'
      AND ROWNUM = 1;
    IF INSTR(v_banner, '505.0.0') > 0 THEN
            v_has_target := TRUE;
END IF;
IF v_has_target THEN
    EXECUTE IMMEDIATE '
        CREATE OR REPLACE FUNCTION public.to_number(interval)
        RETURNS int4
        AS $$
        BEGIN
            RETURN EXTRACT(epoch FROM $1) / 86400;
        END;
        $$ LANGUAGE plpgsql STRICT IMMUTABLE;
    ';
    RAISE NOTICE 'banner包含"505.0.0"（实际banner：%），已创建interval转int4函数', v_banner;
ELSE
    RAISE NOTICE 'banner不包含"505.0.0"（实际banner：%），不创建函数', v_banner;
END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
    RAISE NOTICE '未查询到GaussDB内核版本信息';
WHEN OTHERS THEN
    RAISE NOTICE '执行失败：%', SQLERRM;
END;

-- SQL --  创建months_between函数。参与计算的年、月、日、时、分、秒，秒的其他精度不包含
CREATE OR REPLACE FUNCTION unisql.months_between(
    p_ts1 timestamptz,
    p_ts2 timestamptz
)
    RETURNS double precision
    IMMUTABLE strict
AS $$
DECLARE
result double precision;
BEGIN
    IF p_ts1 IS NULL OR p_ts2 IS NULL OR p_ts1 = '' OR p_ts2 = '' THEN
        RETURN NULL;
END IF;
SELECT CASE
           WHEN dd1 = dd2 OR (m1 = dd1 AND m2 = dd2) THEN
               yd * 12 + mmd
           ELSE
               yd * 12 + mmd
                   + (dd1 - dd2) / 31
                   + hd / 31 / 24
                   + md / 31 / 24 / 60
                   + sd / 31 / 24 / 60 / 60
           END INTO result
FROM (SELECT extract('day' FROM date_trunc('month', p_ts1) + interval '1 month -1 day') AS m1,
             extract('day' FROM date_trunc('month', p_ts2) + interval '1 month -1 day') AS m2,
             extract('year' FROM p_ts1) - extract('year' FROM p_ts2) AS yd,
             extract('month' FROM p_ts1) - extract('month' FROM p_ts2) AS mmd,
             extract('day' FROM p_ts1) AS dd1,
             extract('day' FROM p_ts2) AS dd2,
             extract('hour' FROM p_ts1) - extract('hour' FROM p_ts2) AS hd,
             extract('minute' FROM p_ts1) - extract('minute' FROM p_ts2) AS md,
             trunc(extract('second' FROM p_ts1)) - trunc(extract('second' FROM p_ts2)) AS sd) AS x;

RETURN result;
END;
$$ LANGUAGE plpgsql;

-- SQL --  创建tabs视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='tabs';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.tabs(
            OWNER,
            TABLE_NAME,
            TABLESPACE_NAME,
            STATUS,
            logging,
            PARTITIONED,
            temporary,
            DROPPED,
            READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            EXTERNAL
            ) AS
SELECT
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(TABLESPACE_NAME) TABLESPACE_NAME,
    upper(STATUS) STATUS,
    upper(logging) as logging,
    upper(PARTITIONED) PARTITIONED,
    upper(temporary) as temporary,
            DROPPED,
            upper(READ_ONLY) READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            external
FROM my_tables
WHERE owner = current_user;

raise notice 'create view %','unisql.tabs';
else
        raise notice 'do not create view %','unisql.tabs';
end if;
end $$;

-- SQL --  创建user_tables视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_tables';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_tables(
                                                  OWNER,
                                                  TABLE_NAME,
                                                  TABLESPACE_NAME,
                                                  STATUS,
                                                  logging,
                                                  PARTITIONED,
                                                  temporary,
                                                  DROPPED,
                                                  READ_ONLY,
                                                  SEGMENT_CREATED,
                                                  HAS_IDENTITY,
                                                  EXTERNAL
            ) AS
SELECT
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(TABLESPACE_NAME) TABLESPACE_NAME,
    upper(STATUS) STATUS,
    upper(logging) as logging,
    upper(PARTITIONED) PARTITIONED,
    upper(temporary) as temporary,
            DROPPED,
            upper(READ_ONLY) READ_ONLY,
            SEGMENT_CREATED,
            HAS_IDENTITY,
            external
FROM my_tables
WHERE owner = current_user;

raise notice 'create view %','unisql.user_tables';
else
        raise notice 'do not create view %','unisql.user_tables';
end if;
end $$;

-- SQL --  创建cols视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='cols';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.cols(
            OWNER,
            TABLE_NAME,
            COLUMN_NAME,
            DATA_TYPE,
            DATA_TYPE_MOD,
            DATA_TYPE_OWNER,
            DATA_LENGTH,
            DATA_PRECISION,
            DATA_SCALE,
            NULLABLE,
            COLUMN_ID,
            DEFAULT_LENGTH,
            DATA_DEFAULT,
            NUM_DISTINCT,
            LOW_VALUE,
            HIGH_VALUE,
            DENSITY,
            NUM_NULLS,
            NUM_BUCKETS,
            LAST_ANALYZED,
            SAMPLE_SIZE,
            CHARACTER_SET_NAME,
            CHAR_COL_DECL_LENGTH,
            GLOBAL_STATS,
            USER_STATS,
            AVG_COL_LEN,
            CHAR_LENGTH,
            CHAR_USED,
            DEFAULT_ON_NULL,
            IDENTITY_COLUMN,
            "COLLATION"
            ) as
select
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(COLUMN_NAME) COLUMN_NAME,
    upper(DATA_TYPE) DATA_TYPE,
    DATA_TYPE_MOD,
    DATA_TYPE_OWNER,
    DATA_LENGTH,
    DATA_PRECISION,
    DATA_SCALE,
    NULLABLE,
    COLUMN_ID,
    DEFAULT_LENGTH,
    CASE
        WHEN DATA_DEFAULT IS NULL OR DATA_DEFAULT = '' THEN NULL
        ELSE regexp_split_to_array(DATA_DEFAULT, '::')[1]
        END AS DATA_DEFAULT,
    NUM_DISTINCT,
    LOW_VALUE,
    HIGH_VALUE,
    DENSITY,
    NUM_NULLS,
    NUM_BUCKETS,
    LAST_ANALYZED,
    SAMPLE_SIZE,
    CHARACTER_SET_NAME,
    CHAR_COL_DECL_LENGTH,
    GLOBAL_STATS,
    USER_STATS,
    AVG_COL_LEN,
    CHAR_LENGTH,
    CHAR_USED,
    DEFAULT_ON_NULL,
    IDENTITY_COLUMN,
    "collation"
from my_tab_columns
WHERE owner = current_user;

raise notice 'create view %','unisql.cols';
else
        raise notice 'do not create view %','unisql.cols';
end if;
end $$;

-- SQL --  创建user_tab_columns视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_tab_columns';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_tab_columns(
            OWNER,
            TABLE_NAME,
            COLUMN_NAME,
            DATA_TYPE,
            DATA_TYPE_MOD,
            DATA_TYPE_OWNER,
            DATA_LENGTH,
            DATA_PRECISION,
            DATA_SCALE,
            NULLABLE,
            COLUMN_ID,
            DEFAULT_LENGTH,
            DATA_DEFAULT,
            NUM_DISTINCT,
            LOW_VALUE,
            HIGH_VALUE,
            DENSITY,
            NUM_NULLS,
            NUM_BUCKETS,
            LAST_ANALYZED,
            SAMPLE_SIZE,
            CHARACTER_SET_NAME,
            CHAR_COL_DECL_LENGTH,
            GLOBAL_STATS,
            USER_STATS,
            AVG_COL_LEN,
            CHAR_LENGTH,
            CHAR_USED,
            DEFAULT_ON_NULL,
            IDENTITY_COLUMN,
            "COLLATION"
            ) as
select
    upper(owner) as owner,
    upper(TABLE_NAME) TABLE_NAME,
    upper(COLUMN_NAME) COLUMN_NAME,
    upper(DATA_TYPE) DATA_TYPE,
    DATA_TYPE_MOD,
    DATA_TYPE_OWNER,
    DATA_LENGTH,
    DATA_PRECISION,
    DATA_SCALE,
    NULLABLE,
    COLUMN_ID,
    DEFAULT_LENGTH,
    CASE
        WHEN DATA_DEFAULT IS NULL OR DATA_DEFAULT = '' THEN NULL
        ELSE regexp_split_to_array(DATA_DEFAULT, '::')[1]
        END AS DATA_DEFAULT,
    NUM_DISTINCT,
    LOW_VALUE,
    HIGH_VALUE,
    DENSITY,
    NUM_NULLS,
    NUM_BUCKETS,
    LAST_ANALYZED,
    SAMPLE_SIZE,
    CHARACTER_SET_NAME,
    CHAR_COL_DECL_LENGTH,
    GLOBAL_STATS,
    USER_STATS,
    AVG_COL_LEN,
    CHAR_LENGTH,
    CHAR_USED,
    DEFAULT_ON_NULL,
    IDENTITY_COLUMN,
    "collation"
from my_tab_columns
WHERE owner = current_user;

raise notice 'create view %','unisql.user_tab_columns';
else
        raise notice 'do not create view %','unisql.user_tab_columns';
end if;
end $$;

-- SQL --  创建user_users视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='user_users';
if create_mark = 0 then
        CREATE OR REPLACE VIEW unisql.user_users AS
SELECT  UPPER(usename::text) AS USERNAME
     , usesysid as USER_ID
     , 'NORMAL' as account_status
     , NULL::date as LOCK_DATE
             , valuntil as EXPIRY_DATE
     , NULL::text as DEFAULT_TABLESPACE
             , NULL::text as TEMPORARY_TABLESPACE
             , NULL::date as CREATED
             , NULL::text as INITIAL_RSRC_CONSUMER_GROUP
             , NULL::text as EXTERNAL_NAME
FROM pg_catalog.pg_user WHERE USERNAME = upper(current_user::text);

raise notice 'create view %','unisql.user_users';
else
        raise notice 'do not create view %','unisql.user_users';
end if;
end $$;

-- SQL --  解决 pb to_number(date-date)，临时修复缺陷：LIGHTDB-3308，只有在gaussdb-oracleV505.0版本才执行
DECLARE
    v_banner VARCHAR2(100);
    v_has_target BOOLEAN := FALSE;
    BEGIN
    SELECT banner
    INTO v_banner
    FROM v$version
    WHERE banner LIKE 'gaussdb%'
      AND ROWNUM = 1;
IF INSTR(v_banner, '505.0.0') > 0 THEN
        v_has_target := TRUE;
END IF;
IF v_has_target THEN
    EXECUTE IMMEDIATE '
        CREATE OR REPLACE FUNCTION public.to_number(interval)
        RETURNS int4
        AS $$
        BEGIN
            RETURN EXTRACT(day FROM $1);
        END;
        $$ LANGUAGE plpgsql STRICT IMMUTABLE;
    ';
    RAISE NOTICE 'banner包含"505.0.0"（实际banner：%），已创建interval转day整数函数', v_banner;
ELSE
    RAISE NOTICE 'banner不包含"505.0.0"（实际banner：%），不创建函数', v_banner;
END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE NOTICE '未查询到GaussDB内核版本信息';
WHEN OTHERS THEN
        RAISE NOTICE '执行失败：%', SQLERRM;
END;


-- SQL --  oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value ANYELEMENT)
    RETURNS ANYELEMENT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;

    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- SQL --  oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value TEXT)
    RETURNS TEXT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;
    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- SQL --  创建dual视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark
from information_schema.views
where table_schema = 'public'
  and table_name = 'dual';
if create_mark = 0 then
        create or replace view public.dual as
select 'X' as dummy;
raise notice 'create view %', 'public.dual';
else
        raise notice 'do not create view %', 'public.dual';
end if;
end
$$;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric, VARIADIC combo text[]) returns numeric as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result text, VARIADIC combo text[]) returns text as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result date, VARIADIC combo text[]) returns date as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp, VARIADIC combo text[]) returns timestamp as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp) returns timestamp as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result date) returns date as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result text) returns text as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric) returns numeric as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  统一SQL - oracleToGaussdb-oracle 支持 to_number(number) 函数，临时修复缺陷：LIGHTDB-3308，只有在gaussdb-oracleV505.0版本才执行
-- 为什么加在public而不是在unisql下面？？
-- 因为： 因为数据库已经有to_number函数，本函数是给系统函数添加一个重载
-- 所以实际调用的时候是不带schema的调用，而public默认在search_path里面，
DECLARE
    v_banner VARCHAR2(100);
    v_has_target BOOLEAN := FALSE;
    BEGIN
    SELECT banner
    INTO v_banner
    FROM v$version
    WHERE banner LIKE 'gaussdb%'
      AND ROWNUM = 1;
IF INSTR(v_banner, '505.0.0') > 0 THEN
        v_has_target := TRUE;
END IF;
IF v_has_target THEN
    EXECUTE IMMEDIATE '
        CREATE OR REPLACE FUNCTION public.to_number(p_num NUMBER)
        RETURNS NUMBER
        AS $$
        BEGIN
            RETURN $1;
        END;
        $$ LANGUAGE plpgsql STRICT IMMUTABLE;
    ';
    RAISE NOTICE 'banner包含"505.0.0"（实际banner：%），已创建函数', v_banner;
ELSE
    RAISE NOTICE 'banner不包含"505.0.0"（实际banner：%），不创建函数', v_banner;
END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE NOTICE '未查询到版本信息';
    WHEN OTHERS THEN
	    RAISE NOTICE '执行失败：%', SQLERRM;
END;

-- SQL --  创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric, VARIADIC combo text[]) returns numeric as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result text, VARIADIC combo text[]) returns text as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result date, VARIADIC combo text[]) returns date as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp, VARIADIC combo text[]) returns timestamp as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp) returns timestamp as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result date) returns date as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result text) returns text as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;


-- SQL --  创建decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric) returns numeric as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;



-- SQL --  创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'do not create schema unisql';
end if;
end $body$;


-- SQL --  创建用于支持oracle的all_objects视图
CREATE OR REPLACE VIEW unisql.all_objects AS
SELECT
    UPPER(owner)                 AS owner,
    UPPER(object_name)           AS object_name,
    object_id,
    UPPER(object_type)           AS object_type,
    namespace,
    UPPER(temporary)             AS temporary,
    UPPER(status)                AS status,
    UPPER(subobject_name)        AS subobject_name,
    UPPER(generated)             AS generated,
    created,
    last_ddl_time,
    UPPER(default_collation)     AS default_collation,
    data_object_id,
    UPPER(timestamp)             AS timestamp,
    UPPER(secondary)             AS secondary,
    UPPER(edition_name)          AS edition_name,
    UPPER(sharing)               AS sharing,
    UPPER(editionable)           AS editionable,
    UPPER(oracle_maintained)     AS oracle_maintained,
    UPPER(application)           AS application,
    UPPER(duplicated)            AS duplicated,
    UPPER(sharded)               AS sharded,
    created_appid,
    modified_appid,
    created_vsnid,
    modified_vsnid
FROM db_objects;


