-- SQL --  Oracle19c 授权方案改为创建执行完SQL语句后，增加创建所有用户对unisql下表视图访问执行权限，和对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
-- SQL --  创建unisql模式
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = upper('UNISQL');

    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
    END IF;
    EXECUTE IMMEDIATE 'ALTER USER UNISQL QUOTA UNLIMITED ON USERS';
END;

-- SQL --  mysql8ToOracle19c 内置函数转换：Oracle 中没有 find_in_set 的对应改写方式，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.FIND_IN_SET(p_str IN VARCHAR2, p_list IN VARCHAR2)
RETURN NUMBER IS
    l_position NUMBER := 0;
    l_start_pos NUMBER := 1;
    l_comma_pos NUMBER;
    l_element VARCHAR2(32767);
BEGIN

    IF p_str IS NULL OR p_list IS NULL THEN
        RETURN NULL;
    END IF;


    IF p_list = '' THEN
        RETURN 0;
    END IF;


    IF INSTR(p_str, ',') > 0 THEN
        RETURN 0;
    END IF;


    LOOP
        l_comma_pos := INSTR(p_list, ',', l_start_pos);
        IF l_comma_pos = 0 THEN
            l_element := SUBSTR(p_list, l_start_pos);
        ELSE
            l_element := SUBSTR(p_list, l_start_pos, l_comma_pos - l_start_pos);
        END IF;


        IF l_element = p_str THEN
            RETURN l_position + 1;
        END IF;

        l_position := l_position + 1;
        EXIT WHEN l_comma_pos = 0;
        l_start_pos := l_comma_pos + 1;
    END LOOP;

    RETURN 0;
END FIND_IN_SET;

-- SQL --  mysql8ToOracle19c 内置函数转换：Oracle 中没有 SUBSTRING_INDEX 的对应改写方式，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.SUBSTRING_INDEX(str VARCHAR2, delimiter VARCHAR2, occurrence NUMBER) RETURN VARCHAR2 IS
    result VARCHAR2(4000);
    pos NUMBER;
    current_count NUMBER := 0;
    start_pos NUMBER;
    abs_occurrence NUMBER;

    positions DBMS_UTILITY.NUMBER_ARRAY;
    i NUMBER;
BEGIN
    IF occurrence = 0 THEN
        RETURN '';
    ELSIF occurrence > 0 THEN
        start_pos := 1;
        WHILE current_count < occurrence LOOP
            pos := INSTR(str, delimiter, start_pos);
            IF pos = 0 THEN
                result := str;
                EXIT;
            END IF;
            result := SUBSTR(str, 1, pos - 1);
            start_pos := pos + LENGTH(delimiter);
            current_count := current_count + 1;
        END LOOP;
    ELSE
        abs_occurrence := ABS(occurrence);
        start_pos := 1;

        LOOP
            pos := INSTR(str, delimiter, start_pos);
            IF pos = 0 THEN
                EXIT;
            END IF;
            current_count := current_count + 1;
            positions(current_count) := pos;
            start_pos := pos + LENGTH(delimiter);
        END LOOP;

        i := current_count - abs_occurrence + 1;
        IF i <= 0 THEN
            result := str;
        ELSE
            result := SUBSTR(str, positions(i) + LENGTH(delimiter));
        END IF;
    END IF;
    RETURN result;
END SUBSTRING_INDEX;

-- SQL --  mysql8ToOracle19c 内置函数转换：该函数用于转 IF(cond, expr1, expr2) ，输入 cond 输出 0 或 1
CREATE OR REPLACE FUNCTION unisql.is_nonzero(input_val IN VARCHAR2) RETURN NUMBER 
IS
  num_val NUMBER;
  trimmed_val VARCHAR2(4000);
BEGIN

  IF input_val IS NULL THEN
    RETURN 0;
  END IF;


  trimmed_val := TRIM(input_val);


  IF trimmed_val IS NULL THEN
    RETURN 0;
  END IF;


  BEGIN
    num_val := TO_NUMBER(trimmed_val);
  EXCEPTION
    WHEN VALUE_ERROR THEN
      RETURN 0;
  END;


  IF num_val = 0 THEN
    RETURN 0;
  ELSE
    RETURN 1;
  END IF;
END is_nonzero;

-- SQL --  在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- SQL --  创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;


-- SQL --  创建unisql模式
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = upper('UNISQL');

    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
    END IF;
    EXECUTE IMMEDIATE 'ALTER USER UNISQL QUOTA UNLIMITED ON USERS';
END;

-- SQL --  创建一个包，定义date_add,date_sub重载函数
CREATE OR REPLACE PACKAGE unisql.convert AS
    FUNCTION date_add(
        p_date_str    IN VARCHAR2,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_add(
        p_input_ts    IN TIMESTAMP,        
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_add(
        p_input_tztz  IN TIMESTAMP WITH TIME ZONE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_add(
        p_input_date  IN DATE,             
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN DATE DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION str_to_timestamp(p_input_str VARCHAR2) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION str_to_timestamp(p_input_timestamp TIMESTAMP) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION str_to_timestamp(p_input_timestamptz TIMESTAMP WITH TIME ZONE) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION str_to_timestamp(p_input_date DATE) RETURN DATE DETERMINISTIC PARALLEL_ENABLE;
	
    FUNCTION date_sub(
        p_date_str    IN VARCHAR2,        
        interval_val  IN NUMBER,           
        interval_unit IN VARCHAR2          
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_sub(
        p_input_ts    IN TIMESTAMP,        
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_sub(
        p_input_tztz  IN TIMESTAMP WITH TIME ZONE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION date_sub(
        p_input_date  IN DATE,             
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN DATE DETERMINISTIC PARALLEL_ENABLE;


    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN CLOB) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN CLOB) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION datediff(p_date1 IN DATE, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN DATE, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN DATE, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN DATE, p_date2 IN CLOB) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN CLOB) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN VARCHAR2,
        p_date2 IN VARCHAR2
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN VARCHAR2,
        p_date2 IN DATE
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN VARCHAR2,
        p_date2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN VARCHAR2,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN TIMESTAMP,
        p_date2 IN VARCHAR2
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN TIMESTAMP,
        p_date2 IN DATE
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN TIMESTAMP,
        p_date2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN TIMESTAMP,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN DATE,
        p_date2 IN VARCHAR2
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN DATE,
        p_date2 IN DATE
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN DATE,
        p_date2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN DATE,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN VARCHAR2
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN DATE
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;
    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE;

END;

-- SQL --  创建包体，实现包定义中重载的函数date_add,date_sub
CREATE OR REPLACE PACKAGE BODY unisql.convert AS

    FUNCTION apply_interval_ts(  
        p_base_ts     IN TIMESTAMP,        
        p_interval_val IN NUMBER,         
        p_interval_unit IN VARCHAR2        
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
        v_new_ts      TIMESTAMP;          
        v_original_day NUMBER;             
        v_last_day    TIMESTAMP;           
        v_time_part   INTERVAL DAY(9) TO SECOND; 
        v_interval_month NUMBER;           
    BEGIN
        v_time_part := p_base_ts - TRUNC(p_base_ts);

        CASE UPPER(TRIM(p_interval_unit)) 
            WHEN 'SECOND' THEN RETURN p_base_ts + NUMTODSINTERVAL(p_interval_val, 'SECOND');
            WHEN 'MINUTE' THEN RETURN p_base_ts + NUMTODSINTERVAL(p_interval_val, 'MINUTE');
            WHEN 'HOUR'   THEN RETURN p_base_ts + NUMTODSINTERVAL(p_interval_val, 'HOUR');
            WHEN 'DAY'    THEN RETURN p_base_ts + NUMTODSINTERVAL(p_interval_val, 'DAY');
            WHEN 'WEEK'   THEN RETURN p_base_ts + NUMTODSINTERVAL(p_interval_val * 7, 'DAY'); 
            WHEN 'MONTH'  THEN
                v_interval_month := p_interval_val;
                v_new_ts := ADD_MONTHS(p_base_ts, v_interval_month);
                v_original_day := EXTRACT(DAY FROM p_base_ts);
                v_last_day := LAST_DAY(v_new_ts);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN
                    v_new_ts := TO_TIMESTAMP(
                        TO_CHAR(EXTRACT(YEAR FROM v_new_ts), 'FM9999') || '-' ||
                        TO_CHAR(EXTRACT(MONTH FROM v_new_ts), 'FM09') || '-' ||
                        TO_CHAR(v_original_day, 'FM09'),
                        'YYYY-MM-DD'
                    ) + v_time_part;
                ELSE
                    v_new_ts := TO_TIMESTAMP(TO_CHAR(v_new_ts, 'YYYY-MM-DD'), 'YYYY-MM-DD') + v_time_part;
                END IF;
                RETURN v_new_ts;
            WHEN 'YEAR'   THEN
                v_interval_month := 12 * p_interval_val;
                v_new_ts := ADD_MONTHS(p_base_ts, v_interval_month);
                v_original_day := EXTRACT(DAY FROM p_base_ts);
                v_last_day := LAST_DAY(v_new_ts);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN
                    v_new_ts := TO_TIMESTAMP(
                        TO_CHAR(EXTRACT(YEAR FROM v_new_ts), 'FM9999') || '-' ||
                        TO_CHAR(EXTRACT(MONTH FROM v_new_ts), 'FM09') || '-' ||
                        TO_CHAR(v_original_day, 'FM09'),
                        'YYYY-MM-DD'
                    ) + v_time_part;
                ELSE
                    v_new_ts := TO_TIMESTAMP(TO_CHAR(v_new_ts, 'YYYY-MM-DD'), 'YYYY-MM-DD') + v_time_part;
                END IF;
                RETURN v_new_ts;
            ELSE
                RAISE_APPLICATION_ERROR(-20002, 'Unsupported interval unit: ' || TRIM(p_interval_unit));
        END CASE;
    END apply_interval_ts;  

    FUNCTION apply_interval_tztz(  
        p_base_tztz   IN TIMESTAMP WITH TIME ZONE, 
        p_interval_val IN NUMBER,                 
        p_interval_unit IN VARCHAR2                
    ) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE AS
        v_new_tztz    TIMESTAMP WITH TIME ZONE;    
        v_original_day NUMBER;                     
        v_last_day    TIMESTAMP WITH TIME ZONE;    
        v_time_part   INTERVAL DAY(9) TO SECOND;   
        v_interval_month NUMBER;                   
        v_tz_offset   VARCHAR2(10); 
    BEGIN
        v_tz_offset := TO_CHAR(p_base_tztz, 'TZH:TZM');
        v_time_part := (p_base_tztz AT TIME ZONE v_tz_offset) - TRUNC(p_base_tztz AT TIME ZONE v_tz_offset);

        CASE UPPER(TRIM(p_interval_unit))
            WHEN 'SECOND' THEN RETURN p_base_tztz + NUMTODSINTERVAL(p_interval_val, 'SECOND');
            WHEN 'MINUTE' THEN RETURN p_base_tztz + NUMTODSINTERVAL(p_interval_val, 'MINUTE');
            WHEN 'HOUR'   THEN RETURN p_base_tztz + NUMTODSINTERVAL(p_interval_val, 'HOUR');
            WHEN 'DAY'    THEN RETURN p_base_tztz + NUMTODSINTERVAL(p_interval_val, 'DAY');
            WHEN 'WEEK'   THEN RETURN p_base_tztz + NUMTODSINTERVAL(p_interval_val * 7, 'DAY'); 
            WHEN 'MONTH'  THEN
                v_interval_month := p_interval_val;
                v_new_tztz := ADD_MONTHS(p_base_tztz, v_interval_month);
                v_original_day := EXTRACT(DAY FROM p_base_tztz);
                v_last_day := LAST_DAY(v_new_tztz);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN
                    v_new_tztz := FROM_TZ(
                        TO_TIMESTAMP(
                            TO_CHAR(EXTRACT(YEAR FROM v_new_tztz), 'FM9999') || '-' ||
                            TO_CHAR(EXTRACT(MONTH FROM v_new_tztz), 'FM09') || '-' ||
                            TO_CHAR(v_original_day, 'FM09') || ' ' ||
                            TO_CHAR(v_time_part, 'HH24:MI:SS.FF'),
                            'YYYY-MM-DD HH24:MI:SS.FF'
                        ),
                        v_tz_offset
                    );
                ELSE
                    v_new_tztz := FROM_TZ(
                        TO_TIMESTAMP(
                            TO_CHAR(v_new_tztz, 'YYYY-MM-DD') || ' ' ||
                            TO_CHAR(v_time_part, 'HH24:MI:SS.FF'),
                            'YYYY-MM-DD HH24:MI:SS.FF'
                        ),
                        v_tz_offset
                    );
                END IF;
                RETURN v_new_tztz;
            WHEN 'YEAR'   THEN
                v_interval_month := 12 * p_interval_val;
                v_new_tztz := ADD_MONTHS(p_base_tztz, v_interval_month);
                v_original_day := EXTRACT(DAY FROM p_base_tztz);
                v_last_day := LAST_DAY(v_new_tztz);

                IF v_original_day <= EXTRACT(DAY FROM v_last_day) THEN
                    v_new_tztz := FROM_TZ(
                        TO_TIMESTAMP(
                            TO_CHAR(EXTRACT(YEAR FROM v_new_tztz), 'FM9999') || '-' ||
                            TO_CHAR(EXTRACT(MONTH FROM v_new_tztz), 'FM09') || '-' ||
                            TO_CHAR(v_original_day, 'FM09') || ' ' ||
                            TO_CHAR(v_time_part, 'HH24:MI:SS.FF'),
                            'YYYY-MM-DD HH24:MI:SS.FF'
                        ),
                        v_tz_offset
                    );
                ELSE
                    v_new_tztz := FROM_TZ(
                        TO_TIMESTAMP(
                            TO_CHAR(v_new_tztz, 'YYYY-MM-DD') || ' ' ||
                            TO_CHAR(v_time_part, 'HH24:MI:SS.FF'),
                            'YYYY-MM-DD HH24:MI:SS.FF'
                        ),
                        v_tz_offset
                    );
                END IF;
                RETURN v_new_tztz;
            ELSE
                RAISE_APPLICATION_ERROR(-20002, 'Unsupported interval unit: ' || TRIM(p_interval_unit));
        END CASE;
    END apply_interval_tztz;  

    FUNCTION str_to_timestamp(p_input_str VARCHAR2) 
        RETURN TIMESTAMP 
        DETERMINISTIC 
        PARALLEL_ENABLE 
    AS
        v_clean_str    VARCHAR2(30);  
        v_year         NUMBER;        
        v_length       NUMBER;        
        v_may_month    VARCHAR2(10); 
        v_default_flag BOOLEAN;       
    BEGIN
        IF p_input_str IS NULL THEN
            RAISE_APPLICATION_ERROR(-20000, 'Input string cannot be NULL');
        END IF;

        v_may_month := UPPER(SUBSTR(p_input_str, 4, 3));

        CASE 
            WHEN v_may_month IN ('JAN','FEB','MAR','APR','MAY','JUN',
                                'JUL','AUG','SEP','OCT','NOV','DEC') 
            THEN v_default_flag := TRUE;
            ELSE v_default_flag := FALSE;
        END CASE;

        IF v_default_flag THEN
            v_length := LENGTH(p_input_str);
            IF v_length < 9 THEN
                RAISE_APPLICATION_ERROR(-20000, 'Input too short (DD-MON-RR format)');
            END IF;

            IF v_length = 9 THEN
                RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR');
            END IF;

            IF INSTR(p_input_str, ' +') > 0 OR INSTR(p_input_str, ' -') > 0 THEN
                RETURN CAST(
                    TO_TIMESTAMP_TZ(p_input_str, 'DD-MON-RR HH.MI.SS.FF AM TZR')
                    AS TIMESTAMP
                );
            ELSE
                RETURN TO_TIMESTAMP(p_input_str, 'DD-MON-RR HH.MI.SS.FF AM');
            END IF;
        END IF;

        v_clean_str := REGEXP_REPLACE(p_input_str, '[^0-9]', ''); 
        v_length := LENGTH(v_clean_str);
        IF v_length < 6 THEN
            RAISE_APPLICATION_ERROR(-20000, 'Input too short (numeric format)');
        END IF;

        CASE v_length
            WHEN 6 THEN
                v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
                RETURN TO_TIMESTAMP(
                    CASE WHEN v_year BETWEEN 0 AND 69 THEN '20' ELSE '19' END || v_clean_str, 
                    'YYYYMMDD'
                );
            WHEN 8 THEN 
                RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDD');
            WHEN 12 THEN
                v_year := TO_NUMBER(SUBSTR(v_clean_str, 1, 2));
                RETURN TO_TIMESTAMP(
                    CASE WHEN v_year BETWEEN 0 AND 69 THEN '20' ELSE '19' END || v_clean_str, 
                    'YYYYMMDDHH24MISS'
                );
            WHEN 14 THEN 
                RETURN TO_TIMESTAMP(v_clean_str, 'YYYYMMDDHH24MISS');
            ELSE
                RETURN TO_TIMESTAMP(SUBSTR(v_clean_str, 1, 20), 'YYYYMMDDHH24MISSFF');
        END CASE;
    END str_to_timestamp;

    FUNCTION str_to_timestamp(p_input_timestamp TIMESTAMP) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
        BEGIN
        return p_input_timestamp;
    END str_to_timestamp;

    FUNCTION str_to_timestamp(p_input_timestamptz TIMESTAMP WITH TIME ZONE) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE AS
        BEGIN
        return p_input_timestamptz;
    END str_to_timestamp;

    FUNCTION str_to_timestamp(p_input_date DATE) RETURN DATE DETERMINISTIC PARALLEL_ENABLE AS
        BEGIN
        return p_input_date;
    END str_to_timestamp;

    FUNCTION date_add(
        p_date_str    IN VARCHAR2,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
        v_ts          TIMESTAMP;
    BEGIN
        IF p_date_str IS NULL THEN
            RETURN NULL;
        END IF;

        BEGIN
            v_ts := str_to_timestamp(p_date_str);
        EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
        END;

        RETURN apply_interval_ts(p_base_ts => v_ts, p_interval_val => interval_val, p_interval_unit => interval_unit);
    END date_add;


    FUNCTION date_add(
        p_input_ts    IN TIMESTAMP,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_input_ts IS NULL THEN
            RETURN NULL;
        END IF;

        RETURN apply_interval_ts(p_base_ts => p_input_ts, p_interval_val => interval_val, p_interval_unit => interval_unit);
    END date_add;

    FUNCTION date_add(
        p_input_tztz  IN TIMESTAMP WITH TIME ZONE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_input_tztz IS NULL THEN
            RETURN NULL;
        END IF;

        RETURN apply_interval_tztz(p_base_tztz => p_input_tztz, p_interval_val => interval_val, p_interval_unit => interval_unit);
    END date_add;

    FUNCTION date_add(
        p_input_date  IN DATE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN DATE DETERMINISTIC PARALLEL_ENABLE AS
        v_base_ts     TIMESTAMP;
        v_processed_ts TIMESTAMP;
    BEGIN
        IF p_input_date IS NULL THEN
            RETURN NULL;
        END IF;

        v_base_ts := CAST(p_input_date AS TIMESTAMP);

        v_processed_ts := apply_interval_ts(p_base_ts => v_base_ts, p_interval_val => interval_val, p_interval_unit => interval_unit);

        RETURN CAST(v_processed_ts AS DATE);
    END date_add;
	
    FUNCTION date_sub(
        p_date_str    IN VARCHAR2,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        RETURN date_add(p_date_str, -interval_val, interval_unit);
    END date_sub;

    FUNCTION date_sub(
        p_input_ts    IN TIMESTAMP,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        RETURN date_add(p_input_ts, -interval_val, interval_unit);
    END date_sub;

    FUNCTION date_sub(
        p_input_tztz  IN TIMESTAMP WITH TIME ZONE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN TIMESTAMP WITH TIME ZONE DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        RETURN date_add(p_input_tztz, -interval_val, interval_unit);
    END date_sub;

    FUNCTION date_sub(
        p_input_date  IN DATE,
        interval_val  IN NUMBER,
        interval_unit IN VARCHAR2
    ) RETURN DATE DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        RETURN date_add(p_input_date, -interval_val, interval_unit);
    END date_sub;

    FUNCTION apply_datediff_ts(
        p_ts1 IN TIMESTAMP,
        p_ts2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_ts1 IS NULL OR p_ts2 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN TRUNC(p_ts1) - TRUNC(p_ts2);
    END apply_datediff_ts;

    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
        v_ts2 TIMESTAMP;
    BEGIN
        IF p_date1 IS NULL OR TRIM(p_date1) = '' OR p_date2 IS NULL OR TRIM(p_date2) = '' THEN
            RETURN NULL;
    END IF;
    BEGIN
            v_ts1 := str_to_timestamp(p_date1);
    EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
    END;
    BEGIN
            v_ts2 := str_to_timestamp(p_date2);
    EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
    END;
    RETURN apply_datediff_ts(v_ts1, v_ts2);
    END datediff;

    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
    BEGIN
        IF p_date1 IS NULL OR TRIM(p_date1) = '' OR p_date2 IS NULL THEN
            RETURN NULL;
    END IF;
    BEGIN
            v_ts1 := str_to_timestamp(p_date1);
    EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
    END;
    RETURN apply_datediff_ts(v_ts1, p_date2);
    END datediff;

    FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
    BEGIN
        IF p_date1 IS NULL OR TRIM(p_date1) = '' OR p_date2 IS NULL THEN
        RETURN NULL;
    END IF;
    BEGIN
        v_ts1 := str_to_timestamp(p_date1);
    EXCEPTION WHEN OTHERS THEN
        RETURN NULL;
    END;
    RETURN apply_datediff_ts(v_ts1, CAST(p_date2 AS TIMESTAMP));
    END datediff;

    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts2 TIMESTAMP;
    BEGIN
        IF p_date1 IS NULL OR p_date2 IS NULL OR TRIM(p_date2) = '' THEN
            RETURN NULL;
    END IF;
    BEGIN
            v_ts2 := str_to_timestamp(p_date2);
    EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
    END;
    RETURN apply_datediff_ts(p_date1, v_ts2);
    END datediff;

    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN apply_datediff_ts(p_date1, p_date2);
    END datediff;

    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_date1 IS NULL OR p_date2 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN apply_datediff_ts(p_date1, CAST(p_date2 AS TIMESTAMP));
    END datediff;

    FUNCTION datediff(p_date1 IN DATE, p_date2 IN VARCHAR2) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts2 TIMESTAMP;
    BEGIN
        IF p_date1 IS NULL OR p_date2 IS NULL OR TRIM(p_date2) = '' THEN
            RETURN NULL;
    END IF;
    BEGIN
            v_ts2 := str_to_timestamp(p_date2);
    EXCEPTION WHEN OTHERS THEN
            RETURN NULL;
    END;
    RETURN apply_datediff_ts(CAST(p_date1 AS TIMESTAMP), v_ts2);
    END datediff;

    FUNCTION datediff(p_date1 IN DATE, p_date2 IN TIMESTAMP) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_date1 IS NULL OR p_date2 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN apply_datediff_ts(CAST(p_date1 AS TIMESTAMP), p_date2);
    END datediff;

    FUNCTION datediff(p_date1 IN DATE, p_date2 IN DATE) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
        IF p_date1 IS NULL OR p_date2 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN TRUNC(p_date1) - TRUNC(p_date2);
    END datediff;

    FUNCTION clob_to_varchar(p_clob CLOB) RETURN VARCHAR2 IS
    BEGIN
        IF p_clob IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN DBMS_LOB.SUBSTR(p_clob, 32767, 1);
    END;

    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN VARCHAR2)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
        IF p_date1 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN datediff(clob_to_varchar(p_date1), p_date2);
    END;

   FUNCTION datediff(p_date1 IN CLOB, p_date2 IN TIMESTAMP)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
        IF p_date1 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN datediff(clob_to_varchar(p_date1), p_date2);
    END;

    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN DATE)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
        IF p_date1 IS NULL THEN
            RETURN NULL;
    END IF;
    RETURN datediff(clob_to_varchar(p_date1), p_date2);
    END;

    FUNCTION datediff(p_date1 IN CLOB, p_date2 IN CLOB)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
    RETURN datediff(
        clob_to_varchar(p_date1),
        clob_to_varchar(p_date2)
    );
    END;

   FUNCTION datediff(p_date1 IN VARCHAR2, p_date2 IN CLOB)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
    RETURN datediff(p_date1, clob_to_varchar(p_date2));
    END;

    FUNCTION datediff(p_date1 IN TIMESTAMP, p_date2 IN CLOB)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
    RETURN datediff(p_date1, clob_to_varchar(p_date2));
    END;

    FUNCTION datediff(p_date1 IN DATE, p_date2 IN CLOB)
        RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE
    AS
    BEGIN
    RETURN datediff(p_date1, clob_to_varchar(p_date2));
    END;

	FUNCTION apply_timestampdiff_unit(
        p_unit IN VARCHAR2,
        p_ts1  IN TIMESTAMP,
        p_ts2  IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_diff INTERVAL DAY(9) TO SECOND(9);
        v_day    NUMBER;
        v_hour   NUMBER;
        v_minute NUMBER;
        v_second NUMBER;
        v_unit   VARCHAR2(30);
    BEGIN
        IF p_ts1 IS NULL OR p_ts2 IS NULL OR p_unit IS NULL THEN
            RETURN NULL;
    END IF;

    v_unit := UPPER(TRIM(p_unit));
    IF v_unit NOT IN ('SECOND','MINUTE','HOUR','DAY','WEEK','MONTH','YEAR') THEN
       RAISE_APPLICATION_ERROR(-20001, 'Unsupported unit: ' || p_unit);
    END IF;
    -- MONTH / YEAR 特殊处理
    IF v_unit = 'MONTH' OR v_unit = 'YEAR' THEN
        DECLARE
        -- 从 p_ts1 拆出年、月、日和当天经过的秒数（方便比较“时分秒”）
        -- 这里把时分秒合成秒数 s1，是为了用单一数值比较时间-of-day 的先后，
        -- 避免多层次比较（HOUR, MINUTE, SECOND）的繁琐。
            y1 NUMBER := EXTRACT(YEAR FROM p_ts1);
            m1 NUMBER := EXTRACT(MONTH FROM p_ts1);
            d1 NUMBER := EXTRACT(DAY FROM p_ts1);
            s1 NUMBER := EXTRACT(HOUR FROM p_ts1)*3600
                       + EXTRACT(MINUTE FROM p_ts1)*60
                       + EXTRACT(SECOND FROM p_ts1);

            y2 NUMBER := EXTRACT(YEAR FROM p_ts2);
            m2 NUMBER := EXTRACT(MONTH FROM p_ts2);
            d2 NUMBER := EXTRACT(DAY FROM p_ts2);
            s2 NUMBER := EXTRACT(HOUR FROM p_ts2)*3600
                       + EXTRACT(MINUTE FROM p_ts2)*60
                       + EXTRACT(SECOND FROM p_ts2);
        -- direction 保存时间差方向：1 意味着 p_ts2 在 p_ts1 之后（正向），-1 则相反
        -- 使用 direction 的好处是后面只需按“较早/较晚”归一化计算一次，然后再乘以方向得到带符号结果
            direction NUMBER;
        -- s* 表示“起点”（较早时间）的年/月/日/秒；e* 表示“终点”（较晚时间）
        -- 通过这种命名可以把计算逻辑写成“从 s 到 e 的整月差”，避免重复写两套分支
            sY NUMBER; sM NUMBER; sD NUMBER; sS NUMBER;
            eY NUMBER; eM NUMBER; eD NUMBER; eS NUMBER;
         -- months 用来保存计算出的“整月差”，可以为负
            months NUMBER;
        BEGIN
        -- 判断 p_ts1 与 p_ts2 的先后关系：
        -- 如果 p_ts2 > p_ts1，说明我们要计算的是正向差值（p_ts2 在后）
        -- 如果相等，直接返回 0（没有差距）
            IF p_ts2 > p_ts1 THEN
                direction := 1;
            ELSIF p_ts2 < p_ts1 THEN
                direction := -1;
            ELSE
                RETURN 0;
            END IF;

            -- 按 direction 把较早时间放入 s*，较晚时间放入 e*。
            -- 这样后面月差计算只需处理“从 s 到 e”的情况，代码更清晰且易于维护。
            IF direction = 1 THEN
                sY := y1; sM := m1; sD := d1; sS := s1;
                eY := y2; eM := m2; eD := d2; eS := s2;
            ELSE
                sY := y2; sM := m2; sD := d2; sS := s2;
                eY := y1; eM := m1; eD := d1; eS := s1;
            END IF;
        -- 先计算“粗略的”整月差：年份差×12 + 月份差
        -- 例如：s = 2020-03-xx, e = 2022-01-xx -> (2022-2020)*12 + (1-3) = 22 - 2 = 22? 实际为 22? (示例仅说明公式)
        -- 注意：此时还没考虑日与时间-of-day 是否已“到达”或“超过”起点日/时间，
        -- 所以还需要下面的调整（可能要减 1 个月）。
        --  还有一个用例就是 跨年的 '2026-01-01', '2025-12-31'，如果不考虑较晚-较早结果就不对
            months := (eY - sY) * 12 + (eM - sM);
        -- 判断“是否已满一个额外的月”
        -- 逻辑：如果终点的日比起点日小，说明终点的月份还没过到相同的“日”，
        -- 比如从 2020-01-31 到 2020-02-28（eD < sD），实际上不满 1 个月，
        -- 因此必须把 months 减 1。
        --
        -- 如果终点日等于起点日，但终点的时间-of-day（eS）小于起点时间-of-day（sS），
        -- 说明终点在同日但时间更早，也不算满整日差，所以同样要减 1。
        --
        -- 注意边界：
        --  - 当 sD = 31 且 eM 的月份没有 31 日（例如 2 月），比较 eD < sD 会为真，从而减 1，
        --    这与“自然月差”的直观期望一致（从 1 月 31 日到 2 月 28 日不算满 1 个自然月的）。
        --  - 该实现把“整月”定义为：每增加一个月，年+月组合变化且到达（或超过）起点的日+time。
            IF (eD < sD) OR (eD = sD AND eS < sS) THEN
                months := months - 1;
            END IF;
        -- 恢复原本的方向（如果 direction 是 -1，结果应为负）
            months := months * direction;
        -- 根据请求单位决定返回值：
        --  - 如果是 MONTH，直接返回 months（整月差，带符号）
        --  - 如果是 YEAR，取整（TRUNC），因为“整年”定义为 12 个整月（不是四舍五入）
         --    注意 TRUNC 会向 0 方向截断：比如 months = -15，对 YEAR 会返回 TRUNC(-15/12) = -1
            IF v_unit = 'MONTH' THEN
                RETURN months;
            ELSE
                RETURN TRUNC(months / 12);
            END IF;
        END;
    END IF;

    v_diff := p_ts2 - p_ts1;
    v_day    := EXTRACT(DAY    FROM v_diff);
    v_hour   := EXTRACT(HOUR   FROM v_diff);
    v_minute := EXTRACT(MINUTE FROM v_diff);
    v_second := EXTRACT(SECOND FROM v_diff);

    IF v_unit = 'SECOND' THEN
        RETURN TRUNC(v_day*86400 + v_hour*3600 + v_minute*60 + v_second);
    ELSIF v_unit = 'MINUTE' THEN
        RETURN v_day*1440 + v_hour*60 + v_minute;
    ELSIF v_unit = 'HOUR' THEN
        RETURN v_day*24 + v_hour;
    ELSIF v_unit = 'DAY' THEN
        RETURN v_day;
    ELSIF v_unit = 'WEEK' THEN
        RETURN TRUNC(v_day / 7);
    END IF;
    RETURN NULL;

    END apply_timestampdiff_unit;


   FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN VARCHAR2, p_date2 IN VARCHAR2)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
        v_ts2 TIMESTAMP;
    BEGIN
    BEGIN v_ts1 := str_to_timestamp(p_date1); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    BEGIN v_ts2 := str_to_timestamp(p_date2); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    RETURN apply_timestampdiff_unit(p_unit, v_ts1, v_ts2);
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN VARCHAR2, p_date2 IN DATE)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
    BEGIN
    BEGIN v_ts1 := str_to_timestamp(p_date1); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    RETURN apply_timestampdiff_unit(p_unit, v_ts1, CAST(p_date2 AS TIMESTAMP));
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN VARCHAR2, p_date2 IN TIMESTAMP)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts1 TIMESTAMP;
    BEGIN
    BEGIN v_ts1 := str_to_timestamp(p_date1); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    RETURN apply_timestampdiff_unit(p_unit, v_ts1, p_date2);
    END timestampdiff;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN VARCHAR2,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, p_date1, clob_to_varchar(p_date2));
    END timestampdiff;


    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN TIMESTAMP, p_date2 IN VARCHAR2)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts2 TIMESTAMP;
    BEGIN
    BEGIN v_ts2 := str_to_timestamp(p_date2); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    RETURN apply_timestampdiff_unit(p_unit, p_date1, v_ts2);
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN TIMESTAMP, p_date2 IN DATE)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN apply_timestampdiff_unit(p_unit, p_date1, CAST(p_date2 AS TIMESTAMP));
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN TIMESTAMP, p_date2 IN TIMESTAMP)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN apply_timestampdiff_unit(p_unit, p_date1, p_date2);
    END timestampdiff;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN TIMESTAMP,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, p_date1, clob_to_varchar(p_date2));
    END timestampdiff;



    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN DATE, p_date2 IN VARCHAR2)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
        v_ts2 TIMESTAMP;
    BEGIN
    BEGIN v_ts2 := str_to_timestamp(p_date2); EXCEPTION WHEN OTHERS THEN RETURN NULL; END;
    RETURN apply_timestampdiff_unit(p_unit, CAST(p_date1 AS TIMESTAMP), v_ts2);
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN DATE, p_date2 IN DATE)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN apply_timestampdiff_unit(p_unit, CAST(p_date1 AS TIMESTAMP), CAST(p_date2 AS TIMESTAMP));
    END timestampdiff;

    FUNCTION timestampdiff(p_unit IN VARCHAR2, p_date1 IN DATE, p_date2 IN TIMESTAMP)
    RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN apply_timestampdiff_unit(p_unit, CAST(p_date1 AS TIMESTAMP), p_date2);
    END timestampdiff;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN DATE,
        p_date2 IN CLOB
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, p_date1, clob_to_varchar(p_date2));
    END timestampdiff;



    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN VARCHAR2
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, clob_to_varchar(p_date1), p_date2);
    END timestampdiff;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN DATE
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, clob_to_varchar(p_date1), p_date2);
    END timestampdiff;

    FUNCTION timestampdiff(
        p_unit  IN VARCHAR2,
        p_date1 IN CLOB,
        p_date2 IN TIMESTAMP
    ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, clob_to_varchar(p_date1), p_date2);
    END timestampdiff;
        FUNCTION timestampdiff(
            p_unit  IN VARCHAR2,
            p_date1 IN CLOB,
            p_date2 IN CLOB
        ) RETURN NUMBER DETERMINISTIC PARALLEL_ENABLE AS
    BEGIN
    RETURN timestampdiff(p_unit, clob_to_varchar(p_date1), clob_to_varchar(p_date2));
    END timestampdiff;
END;


-- SQL --  在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- SQL --  创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- SQL --  创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;


