## 统一SQL脚本升级工具

统一SQL自定义对象脚本可以通过升级工具进行执行，打入目标数据库。

建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 `unisql-upgrade-<version>.jar` 升级工具jar包位于sql 目录下。执行日志生成在logs 目录下的unisql-upgrade.log文件中。 具体使用方法：

具体使用方法：

```shell
java -jar unisql-upgrade-<version>.jar -S 源端数据库类型 -T 目标端数据库类型 -h 数据库IP -p 数据库端口 -U 数据库用户名 -W 数据库密码 -d 要连接的数据库名称 [-all] [OPTION]... 

options:
  -S, --source   ,是否必须:是, 源端数据库类型(ORACLE、MYSQL)
  -T, --target   ,是否必须:是, 目标端数据库类型(当源为ORACLE时，目标库取值范围:POSTGRESQL、TDSQL_MYSQL、OCEAN_BASE_MYSQL、TDSQL_PG_ORACLE、GAUSSDB_ORACLE、TDSQL_PG；当源为MYSQL时，目标库取值范围:GAUSSDB500_ORACLE、ORACLE_19C、OCEAN_BASE_ORACLE、GAUSSDB_ORACLE、GAUSSDB_MYSQL_B、DM)
  -h, --host     ,是否必须:是, 数据库IP
  -p, --port     ,是否必须:是, 数据库端口
  -U, --username ,是否必须:是, 数据库用户名
  -W, --password ,是否必须:是, 数据库密码
  -d, --dbname   ,是否必须:是, 要连接的数据库名称。(暂不支持大小写敏感)
  -s, --schema   ,是否必须:否, 将sql脚本打入到哪个schema(TDSQL_MYSQL、OCEAN_BASE_MYSQL则为database)下(默认: unisql )。暂不支持大小写敏感
  -v, --version  ,是否必须:否, 升级到指定版本(版本号见官网的版本发布历史章节，格式：xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)。默认为当前安装包最新版本)
  -all, --all    ,是否必须:否, 是否执行全量脚本选项，具有最高优先级(高于-v)，第一次接入时可以选择执行全量脚本，否则进行增量脚本的迭代升级
  -help, --help   显示 jar 命令的用法和所有可用的选项
```



## 注意：

1. 业务使用的用户或后续新增的用户，需要确保有访问database和schema的权限。 ``TDSQL_MYSQL、OCEAN_BASE_MYSQL`` 新增用户后，需要为新用户分配统一SQL数据库的函数执行权限。分配方法如下，需要root用户来执行： ``call unisql.GrantUnisqlPermissions();`` 如果初始化时指定了非unisql数据库。则 ``call 指定的数据库.GrantUnisqlPermissions();``
2. ``TDSQL_MYSQL`` 连接需要用真实端口号，不要用代理端口号。
3. 统一sql依赖的自定义对象默认创建在 `unisql` 的schema下(目标库为TDSQL_MYSQL、OCEAN_BASE_MYSQL则为unisql数据库)。
4. 如果想创建在指定的schema (TDSQL_MYSQL、OCEAN_BASE_MYSQL则为database)可以使用脚本升级工具的 ``--schema`` 参数指定（后续升级时也需要和第一次设置时相同，同时统一SQL配置文件 ``unisql.conf`` 中 ``unisql.schema`` 配置项也需要同步变更为指定的schema或database）。
5. 全量脚本可以通过-all选项执行。
6. 增量脚本升级前提，schema/database已存在且有执行权限
7. 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema(TDSQL_MYSQL、OCEAN_BASE_MYSQL则为database)下(默认是unisql)，具体脚本见如下各个源端到目标端的脚本。
8. 输出日志编码格式为UTF-8
9. 用户名、密码、schema不支持中文，如果中间有空格用双引号包裹(内容两边双引号会被识别去除，因此本身内容不支持双引号)
10. 环境必须要有jre（java version>=1.8）


### PostgreSQL 目标库脚本

脚本目录为 `oracle2postgresql` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time timestamp(0));
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### TDSQL_MYSQL 目标库脚本

脚本目录为 `oracle2tdsql_mysql` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的database下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time datetime);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### OCEAN_BASE_MYSQL 目标库脚本

脚本目录为 `oracle2ocean_base_mysql` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的database下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time datetime);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### GAUSSDB_ORACLE 目标库脚本

脚本目录为 `oracle2gaussdb_oracle` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time date);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### GAUSSDB500_ORACLE 目标库脚本

脚本目录为 `mysql2gaussdb500_oracle` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time date);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### TDSQL_PG_ORACLE(Oracle模式) 目标库脚本

脚本目录为 `oracle2tdsql_pg_oracle` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time date);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### TDSQL_PG目标库脚本

脚本目录为 `oracle2tdsql_pg` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是24.2.6版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 `xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- unisql_version表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。
create table unisql_version (id int primary key,version varchar(20),update_time date);
insert into unisql_version values(1,'xx.xx.xx.xxx',now());
```

### ORACLE_19C 目标库脚本

脚本目录为 `mysql2oracle_19c` ，建议使用超级用户执行，或者通过具有 CREATE 、EXECUTE、GRANT、SELECT、UPDATE、INSERT权限的用户来执行。 如果是25.1.1版本之前用户，第一次使用升级工具且是增量执行时，需要手动维护统一SQL版本信息表到指定的schema下(默认是unisql),版本号为 ``xx(年份).xx(RP版本).xx(增量版本).xxx(补丁版本)`` 见版本发布历史章节。 需要填写升级前使用的实际版本号。

```
-- UNISQL_VERSION表用于记录统一SQL版本信息,version为统一SQL版本号，update_time为更新时间。（插入的version版本号需要填写升级前使用的实际版本号）
create table UNISQL_VERSION (id int primary key,version varchar(20),update_time date);
insert into UNISQL_VERSION values(1,'xx.xx.xx.xxx',sysdate);
```
