-- SQL --  mysql2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持 ） 25.3.2.2版本脚本
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value ANYELEMENT)
    RETURNS ANYELEMENT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;

    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- SQL --  mysql2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value TEXT)
    RETURNS TEXT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;
    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;


-- SQL --  创建用于支持mysql的substring_index函数
CREATE OR REPLACE FUNCTION unisql.substring_index(
    str TEXT,       -- 原字符串
    delim TEXT,     -- 分隔符
    count INT       -- 截取次数
) RETURNS TEXT AS $$
DECLARE
result TEXT := '';
    elem TEXT;
    elem_count INT := 0;
    total_elem INT := 0;
    arr TEXT[];
    first_elem BOOLEAN := TRUE; -- 标记是否为第一个元素，避免开头加分隔符

begin

    -- 空值/空分隔符处理（与 MySQL 一致 null 优先于''）
    IF str IS NULL OR delim IS NULL OR count IS NULL THEN
        RETURN NULL;
    ELSIF delim = '' OR str = '' OR count = '' THEN
        RETURN '';
END IF;

    -- 拆分字符串为数组
    arr := string_to_array(str, delim);

    -- 统计数组总元素数
SELECT COUNT(*) INTO total_elem FROM unnest(arr) AS t;

-- 处理 count=0 的情况（返回空字符串）
IF count = 0 THEN
        RETURN '';
END IF;

    -- 正数：从左截取前 N 个元素
    IF count > 0 THEN
        -- 若 count 超过总元素数，直接返回原字符串
        IF count >= total_elem THEN
            RETURN str;
END IF;
        -- 遍历前 count 个元素并拼接
FOR elem IN SELECT unnest(arr) LIMIT count LOOP

    		IF first_elem THEN
                result := elem;
first_elem := FALSE;
ELSE
                result := result || delim || elem;
END IF;
END LOOP;

    -- 负数：从右截取后 ABS(count) 个元素
    ELSIF count < 0 THEN
        DECLARE
take_count INT := ABS(count);
BEGIN
            -- 若 take_count 超过总元素数，直接返回原字符串
            IF take_count >= total_elem THEN
                RETURN str;
END IF;
            -- 遍历从 (total_elem - take_count + 1) 开始的元素并拼接
FOR elem IN SELECT unnest(arr) OFFSET (total_elem - take_count) LOOP
                IF first_elem THEN
                result := elem;
first_elem := FALSE;
ELSE
                result := result || delim || elem;
END IF;
END LOOP;
END;
END IF;

RETURN result;
END;
$$ LANGUAGE plpgsql immutable ;
