-- SQL -- 创建regexp_instr自定义函数，REGEXP_INSTR( string text, pattern text ) -> integer
CREATE OR REPLACE FUNCTION unisql.regexp_instr(text, text)
RETURNS integer
AS $$
DECLARE
v_pos integer;
  v_pattern text;
BEGIN
  IF $1 IS NULL OR $1 = '' OR $2 IS NULL OR $2 = '' THEN
    RETURN NULL;
  END IF;
  v_pattern := '(' || $2 || ')';
  v_pos := (SELECT position((SELECT (regexp_matches($1, v_pattern, 'pg'))[1] OFFSET 0 LIMIT 1) IN $1));
  IF v_pos IS NOT NULL THEN
    RETURN v_pos;
END IF;
RETURN 0;
END;
$$
LANGUAGE plpgsql;

-- SQL -- 创建regexp_instr自定义函数，REGEXP_INSTR( string text, pattern text, position int ) -> integer
CREATE OR REPLACE FUNCTION unisql.regexp_instr(text, text, integer)
RETURNS integer
AS $$
DECLARE
v_pos integer;
  v_pattern text;
BEGIN
  IF $1 IS NULL OR $1 = '' OR $2 IS NULL OR $2 = '' OR $3 IS NULL THEN
    RETURN NULL;
  END IF;
  IF $3 < 1 THEN
    RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';
  END IF;
  v_pattern := '(' || $2 || ')';
SELECT position((SELECT (regexp_matches(substr($1, $3), v_pattern, 'pg'))[1] OFFSET 0 LIMIT 1) IN substr($1, $3))
INTO v_pos;
IF v_pos IS NOT NULL THEN
    RETURN v_pos + $3 - 1;
END IF;
RETURN 0;
END;
$$
LANGUAGE plpgsql;

-- SQL -- 创建regexp_instr自定义函数，REGEXP_INSTR( string text, pattern text, position int, occurence int ) -> integer
CREATE OR REPLACE FUNCTION unisql.regexp_instr(
    subject TEXT,
    pattern TEXT,
    start_position INTEGER ,
    nth_occurrence INTEGER
)
RETURNS INTEGER AS $$
DECLARE
parts TEXT[];
    match_pos INTEGER := 0;
    i INTEGER := 1;
    match_record RECORD;
    match_record_array TEXT[]:= '{}';
    match_cursor CURSOR FOR
SELECT (regexp_matches(SUBSTRING(subject,start_position), pattern, 'pg'))[1];
BEGIN
    IF subject IS NULL OR subject = '' OR
       pattern IS NULL OR pattern = '' OR
       start_position IS NULL  OR
       nth_occurrence IS NULL
    THEN
        RETURN NULL;
    END IF;
    IF start_position < 1 THEN
      RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';
    END IF;
    IF nth_occurrence < 1 THEN
      RAISE EXCEPTION 'argument ''occurence'' must be a number greater than 0';
    END IF;
    IF start_position > LENGTH(subject) THEN
        RETURN 0;
    END IF;
    parts := regexp_split_to_array(SUBSTRING(subject,start_position), pattern);
    IF array_length(parts, 1) <= nth_occurrence THEN
        RETURN 0;
    END IF;
OPEN match_cursor;
LOOP
FETCH match_cursor INTO match_record;
        EXIT WHEN NOT FOUND;
        match_record_array := array_append(match_record_array, match_record.regexp_matches);
END LOOP;
CLOSE match_cursor;
FOR i IN 1..nth_occurrence loop
        match_pos := match_pos + LENGTH(parts[i]);
        IF i < nth_occurrence then
          match_pos := match_pos + LENGTH(match_record_array[i]);
        END IF;
END LOOP;
RETURN match_pos + start_position;
END;
$$ LANGUAGE plpgsql;

-- SQL -- 创建regexp_instr自定义函数，REGEXP_INSTR( string text, pattern text, position int, occurence int, return_opt int ) -> integer
CREATE OR REPLACE FUNCTION unisql.regexp_instr(
    subject TEXT,
    pattern TEXT,
    start_position INTEGER,
    nth_occurrence INTEGER ,
    return_option INTEGER
)
RETURNS INTEGER AS $$
DECLARE
parts TEXT[];
    match_pos INTEGER := 0;
    i INTEGER := 1;
    match_record RECORD;
    match_record_array TEXT[]:= '{}';
    match_cursor CURSOR FOR
SELECT (regexp_matches(SUBSTRING(subject,start_position), pattern, 'pg'))[1];
BEGIN
    IF subject IS NULL OR subject = '' OR
       pattern IS NULL OR pattern = '' OR
       start_position IS NULL  OR
       nth_occurrence IS NULL  OR
       return_option IS NULL
    THEN
        RETURN NULL;
    END IF;
    IF start_position < 1 THEN
      RAISE EXCEPTION 'argument ''position'' must be a number greater than 0';
    END IF;
    IF nth_occurrence < 1 THEN
      RAISE EXCEPTION 'argument ''occurence'' must be a number greater than 0';
    END IF;
    IF return_option != 0 AND return_option != 1 THEN
      RAISE EXCEPTION 'argument ''return_opt'' must be 0 or 1';
    END IF;
    IF start_position > LENGTH(subject) THEN
        RETURN 0;
    END IF;
    parts := regexp_split_to_array(SUBSTRING(subject,start_position), pattern);
    IF array_length(parts, 1) <= nth_occurrence THEN
        RETURN 0;
    END IF;
OPEN match_cursor;
LOOP
FETCH match_cursor INTO match_record;
	        EXIT WHEN NOT FOUND;
	        match_record_array := array_append(match_record_array, match_record.regexp_matches);
END LOOP;
CLOSE match_cursor;
FOR i IN 1..nth_occurrence loop
        match_pos := match_pos + LENGTH(parts[i]);
        IF (i < nth_occurrence AND return_option = 0 ) OR return_option =1 then
          match_pos := match_pos + LENGTH(match_record_array[i]);
        END IF;
END LOOP;
RETURN match_pos + start_position;
END;
$$ LANGUAGE plpgsql;