-- SQL --  统一SQL - oracleToGaussdb-oracle 支持 to_number(number) 函数，临时修复缺陷：LIGHTDB-3308，只有在gaussdb-oracleV505.0版本才执行
-- 为什么加在public而不是在unisql下面？？
-- 因为： 因为数据库已经有to_number函数，本函数是给系统函数添加一个重载
-- 所以实际调用的时候是不带schema的调用，而public默认在search_path里面，
DECLARE
    v_banner VARCHAR2(100);
    v_has_target BOOLEAN := FALSE;
    BEGIN
    SELECT banner
    INTO v_banner
    FROM v$version
    WHERE banner LIKE 'gaussdb%'
      AND ROWNUM = 1;
IF INSTR(v_banner, '505.0.0') > 0 THEN
        v_has_target := TRUE;
END IF;
IF v_has_target THEN
    EXECUTE IMMEDIATE '
        CREATE OR REPLACE FUNCTION public.to_number(p_num NUMBER)
        RETURNS NUMBER
        AS $$
        BEGIN
            RETURN $1;
        END;
        $$ LANGUAGE plpgsql STRICT IMMUTABLE;
    ';
    RAISE NOTICE 'banner包含"505.0.0"（实际banner：%），已创建函数', v_banner;
ELSE
    RAISE NOTICE 'banner不包含"505.0.0"（实际banner：%），不创建函数', v_banner;
END IF;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE NOTICE '未查询到版本信息';
    WHEN OTHERS THEN
	    RAISE NOTICE '执行失败：%', SQLERRM;
END;