#!/bin/bash
# SEE部署专用文件
X86_SO="unisql.linux.x86_64.so"
X86_DEBUG_SO="unisql.linux.x86_64.debug.so"

AARCH_SO="unisql.linux.aarch64.so"
AARCH_DEBUG_SO="unisql.linux.aarch64.debug.so"

mkdir -p ${workspace}

# 使用 sed 去掉结尾的斜杠
workspace=$(echo "$workspace" | sed 's:/*$::')

INSTALL_TXT="${workspace}/install.txt"

# 错误输出函数
error_exit() {
    echo -e "ERROR: $1" >&2
    exit 1
}

# 定义函数 log_install_info
log_install_info() {
    # 记录安装路径
    echo "Installation Path: ${workspace}" >> ${INSTALL_TXT}

    # 记录安装时间
    echo "Installation Time: $(date)" >> ${INSTALL_TXT}

    # 添加空行
    echo "" >> ${INSTALL_TXT}
}

# 调用函数记录安装信息
log_install_info

# 复制配置目录
if [ ! -d "${workspace}/config" ]; then
    cp -r "tmp/${app_fold}/config" "${workspace}"
else
    echo "目录 ${workspace}/config 已存在，跳过复制."
fi

# 去掉多余的/
# 复制SQL
rm -rf ${workspace}/sql
cp -r tmp/${app_fold}/sql ${workspace}

# 复制动态库和头文件
rm -f ${workspace}/unisql.linux.aarch64*.so
rm -f ${workspace}/unisql.linux.x86_64*.so
rm -f ${workspace}/*.h
cp tmp/${app_fold}/c/aarch64/lib/unisql.linux.aarch64*.so ${workspace}
cp tmp/${app_fold}/c/x86_64/lib/unisql.linux.x86_64*.so ${workspace}
cp tmp/${app_fold}/c/x86_64/include/*.h ${workspace}
chmod +x ${workspace}/unisql.linux.aarch64*.so
chmod +x ${workspace}/unisql.linux.x86_64*.so

# 复制动态代理
rm -f ${workspace}/sql-convert-runtime-*.jar
cp tmp/${app_fold}/*.jar ${workspace}
rm -f ${workspace}/sql-convert-runtime-native-linux-*.jar

# 复制版本号
cp tmp/${app_fold}/VERSION ${workspace}

# ==================== 架构检测 ====================
# 获取系统架构（兼容 Linux/macOS）
ARCH=$(uname -m)
case "$ARCH" in
    x86_64|amd64)  # amd64 是 x86_64 的别名（部分系统显示）
        TARGET_SO=${X86_SO}
        if [ ! -f ${workspace}/${TARGET_SO} ]; then
            TARGET_SO=${X86_DEBUG_SO}
        fi

        if [ ! -f ${workspace}/${TARGET_SO} ]; then
            error_exit "动态库${workspace}/${TARGET_SO}未找到，请检查安装包是否完整"
        fi
        ;;
    aarch64|arm64) # arm64 是 aarch64 的别名（macOS 显示）
        TARGET_SO=${AARCH_SO}
        if [ ! -f ${workspace}/${TARGET_SO} ]; then
            TARGET_SO=${AARCH_DEBUG_SO}
        fi

        if [ ! -f ${workspace}/${TARGET_SO} ]; then
            error_exit "动态库${workspace}/${TARGET_SO}未找到，请检查安装包是否完整"
        fi
        ;;
    *)
        error_exit "不支持的系统架构: $ARCH，仅支持 x86_64/amd64 或 aarch64/arm64"
        ;;
esac

# 添加so的路径配置
if [ ! -f ${workspace}/config/unisql.conf ]; then
   error_exit "${workspace}/config/unisql.conf未找到，请检查安装包是否完整"
fi
echo "" >> ${workspace}/config/unisql.conf
echo "unisql.lib.full-path=${workspace}/${TARGET_SO}" >> ${workspace}/config/unisql.conf
echo ""

# 清理临时文件夹
rm -rf ${workspace}/tmp
rm -rf ${workspace}/${app_fold}
