/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.constant.Version;
import com.hundsun.lightdb.unisql.golang.GlobalStaticParameter;
import com.hundsun.lightdb.unisql.golang.GoParserFactory;
import com.hundsun.lightdb.unisql.golang.IGoParser;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.SqlState;
import com.hundsun.lightdb.unisql.golang.SyntaxAnalyseResult;
import com.hundsun.lightdb.unisql.golang.TransformerInternal;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.ColumnMetadata;
import com.hundsun.lightdb.unisql.model.ConnectionConfig;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.TableMeta;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformer {
    private static final Logger log = LoggerFactory.getLogger(Transformer.class);
    private static boolean DEBUG;
    public static boolean COLLECT_PARAMS;
    public static boolean SEND_TO_COMPARE_SERVER;
    public static boolean SEND_MQ_TO_COMPARE_SERVER;
    public static GlobalStaticParameter globalStaticParameter;
    private static final Pattern PATTERN_ORACLE19C_META_NAME_REPLACER;

    public static void setConfigration() {
        try {
            UnisqlProperties properties = UnisqlProperties.getInstance();
            DEBUG = properties.isDebug();
            globalStaticParameter = new GlobalStaticParameter();
            if (properties.isSkip()) {
                globalStaticParameter.setGlobalSkip(1);
            }
            if (properties.isMysqlBackslashEscapes()) {
                globalStaticParameter.setMysqlBackslashEscapes(1);
            }
            if (properties.isErrorSkip()) {
                globalStaticParameter.setGlobalErrorSkip(1);
            }
            long goGc = properties.getGOGC();
            globalStaticParameter.setGoGc(goGc);
            long goMemLimit = properties.getGOMEMLIMIT();
            globalStaticParameter.setGoMemLimit(goMemLimit);
            if (DEBUG) {
                globalStaticParameter.setUniSqlDebugLog(1);
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getCompareServerUrl())) {
                COLLECT_PARAMS = true;
                SEND_TO_COMPARE_SERVER = true;
                globalStaticParameter.setCompareServerUrl(properties.getCompareServerUrl());
            } else {
                COLLECT_PARAMS = false;
            }
            SEND_MQ_TO_COMPARE_SERVER = MultiProperties.getSendCompareService();
            if (StringUtils.isNotBlank((CharSequence)properties.getSchema())) {
                globalStaticParameter.setSchema(properties.getSchema());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getRemoveDoublequoted()))) {
                globalStaticParameter.setRemoveDoubleQuoted(properties.getRemoveDoublequoted());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getPrintSysinfo()))) {
                globalStaticParameter.setPrintSysInfo(properties.getPrintSysinfo());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getDecodeParametersFuncNames())) {
                globalStaticParameter.setDecodeParametersFuncNames(properties.getDecodeParametersFuncNames());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getGlobalReplaceSql())) {
                globalStaticParameter.setGlobalReplaceSql(properties.getGlobalReplaceSql());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getDefaultChangeDatabaseToSchema()))) {
                globalStaticParameter.setChangeDatabaseToSchema(properties.getDefaultChangeDatabaseToSchema());
            }
            globalStaticParameter.setTableOrColumnNameRandom(properties.isTableOrColumnNameRandom());
            globalStaticParameter.setChangeBackQuotesToDoubleQuotes(properties.isChangeBackQuotesToDoubleQuotes());
            if (StringUtils.isNotBlank((CharSequence)properties.getKeywordDoubleQuotes())) {
                globalStaticParameter.setKeywordDoubleQuotes(properties.getKeywordDoubleQuotes());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getOnUpdateCurrentimestampColumn())) {
                globalStaticParameter.setKeyOnUpdateColumn(properties.getOnUpdateCurrentimestampColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getOnUpdateCurrentimestampColumn())) {
                globalStaticParameter.setKeyOnUpdateColumn(properties.getOnUpdateCurrentimestampColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getAutoIncrementColumn())) {
                globalStaticParameter.setAutoIncrementColumn(properties.getAutoIncrementColumn());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getTableColumnMetaDataSchemas())) {
                globalStaticParameter.setTableColumnMetadataSchemas(properties.getTableColumnMetaDataSchemas());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getTableColumnReplaceDatatype())) {
                globalStaticParameter.setTableColumnReplaceDatatype(properties.getTableColumnReplaceDatatype());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.getDatatypeNumberReplaceInteger()))) {
                globalStaticParameter.setDatatypeNumberReplaceInteger(properties.getDatatypeNumberReplaceInteger());
            }
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(properties.isRemoveTablespace()))) {
                globalStaticParameter.setUnisqlRemoveTablespace(properties.isRemoveTablespace());
            }
            globalStaticParameter.setUnisqlSkipExceptionKeywords(properties.getSkipExceptionKeywords());
            globalStaticParameter.setUnisqlBindVariableMode(properties.getUnisqlBindVariableMode());
            if (SEND_MQ_TO_COMPARE_SERVER && StringUtils.isNotBlank((CharSequence)properties.getUnsqlExcludeRulesDirectory())) {
                Utils.parseExcludeFile(properties.getUnsqlExcludeRulesDirectory());
            }
            if (properties.isOpenCache()) {
                globalStaticParameter.setIsCache(1);
            }
            if (properties.getUnisqlCleanGttQuery()) {
                globalStaticParameter.setNeedCleanGtt(1);
            } else {
                globalStaticParameter.setNeedCleanGtt(0);
            }
        }
        catch (Exception e) {
            log.error(ErrorMessages.format(ErrorMessages.LTU0004, e.getMessage()), (Throwable)e);
        }
    }

    public static void cleanCache() {
        TransformerInternal.cleanCache();
    }

    public static String parse(String sql, String source, String target) {
        return Transformer.parse(sql, source, target, new VariableParameter());
    }

    public static String parse(String sql, String source, String target, long sessionId) {
        VariableParameter variable = new VariableParameter();
        variable.setSessionId(sessionId);
        return Transformer.parse(sql, source, target, variable);
    }

    public static String parse(String sql, String source, String target, VariableParameter variableParameter) {
        return Transformer.parse(sql, source, target, variableParameter, null);
    }

    public static String parse(String sql, String source, String target, VariableParameter variableParameter, ReturnParameter parameter) {
        if (log.isDebugEnabled()) {
            log.debug("\u8f6c\u6362\u524d {}", (Object)sql);
        }
        variableParameter.setSourceDialect(source);
        variableParameter.setTargetDialect(target);
        variableParameter.setSourceSql(sql);
        ReturnParameter returnParameter = TransformerInternal.parsePro(variableParameter);
        if (!SqlState.SUCCESS.getState().equals(returnParameter.getState())) {
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0006, returnParameter.getState(), returnParameter.getMessage(), sql));
        }
        if (parameter != null) {
            parameter.setTargetSql(returnParameter.getTargetSql());
            parameter.setAutoIncrementColumnIndex(returnParameter.getAutoIncrementColumnIndex());
            parameter.setColumnCountSum(returnParameter.getColumnCountSum());
            parameter.setBindVariableOrder(returnParameter.getBindVariableOrder());
            parameter.setState(returnParameter.getState());
            parameter.setMessage(returnParameter.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8f6c\u6362\u540e {}", (Object)returnParameter.getTargetSql());
        }
        return returnParameter.getTargetSql();
    }

    @Deprecated
    public static ReturnParameter parseUseCache(String sql, String source, String target, boolean useCache) {
        return Transformer.parseUseCache(sql, source, target, useCache, VariableParameter.builder().restoreFmt(0L).build());
    }

    @Deprecated
    public static ReturnParameter parseUseCache(String sql, String source, String target, boolean useCache, VariableParameter variableParameter) {
        variableParameter.setSourceDialect(source);
        variableParameter.setTargetDialect(target);
        variableParameter.setSourceSql(sql);
        return TransformerInternal.parsePro(variableParameter);
    }

    public static void setParamInt(String paramName, int paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamInt(paramName, paramValue);
    }

    public static void setParamStr(String paramName, String paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamStr(paramName, paramValue);
    }

    public static void setParamBool(String paramName, boolean paramValue) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.SetParamBool(paramName, paramValue);
    }

    public static void setSessionParamStr(String paramName, String paramValue, long sessionId) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.UnisqlSetSessionParamStr(paramName, paramValue, sessionId);
    }

    public static ReturnParameter getDqlByDml(VariableParameter variableParameter) {
        IGoParser parser = GoParserFactory.getGoParser();
        return TransformerInternal.getDqlByDml(variableParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter initTableMetas(String tableMetas) {
        IGoParser parser = GoParserFactory.getGoParser();
        Pointer p = parser.InitTableMetas(tableMetas);
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = (ReturnParameter)JSON.parseObject((String)utf8, ReturnParameter.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    public static ReturnParameter initTableMetas(List<TableMeta> tableMetas) {
        return Transformer.initTableMetas(JsonUtils.toJson(tableMetas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnParameter initTableColumnMetas(ConnectionConfig odbcConfig) {
        IGoParser parser = GoParserFactory.getGoParser();
        Transformer.cleanGTT(odbcConfig);
        if (log.isInfoEnabled()) {
            log.info("\u52a0\u8f7d\u76ee\u6807\u5e93{}\u7684\u5143\u6570\u636e", (Object)odbcConfig.getTargetDialect());
        }
        if (DbType.ORACLE_19C.name().equalsIgnoreCase(odbcConfig.getTargetDialect()) || DbType.ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect()) || DbType.OCEAN_BASE_ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect())) {
            List<ColumnMetadata> columnMetadataList;
            try {
                columnMetadataList = Transformer.queryOracleColumnMetadata(odbcConfig);
            }
            catch (Exception e) {
                log.error("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0025, e.toString()), e);
            }
            String fileName = String.format("unisql_tmp_%s_%s_%s_%s_%s.txt", PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getTargetDialect()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getHost()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getPort()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getDbname()).replaceAll("_"), PATTERN_ORACLE19C_META_NAME_REPLACER.matcher(odbcConfig.getUser()).replaceAll("_"));
            String tmpFileContent = JsonUtils.toJson(columnMetadataList);
            String tempDir = System.getProperty("java.io.tmpdir");
            if (log.isInfoEnabled()) {
                log.info("\u5143\u6570\u636e\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55: {}", (Object)tempDir);
            }
            Path tmpFilePath = Paths.get(tempDir, new String[0]).resolve(fileName);
            if (log.isInfoEnabled()) {
                log.info("\u5143\u6570\u636e\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)tmpFilePath);
            }
            odbcConfig.setMetaDataFilePath(tmpFilePath.toString());
            try {
                Files.write(tmpFilePath, tmpFileContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                log.error("\u5199\u5165\u5143\u6570\u636e\u5230\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0025, e.toString()), e);
            }
            if (log.isInfoEnabled()) {
                log.info("\u5199\u5165\u5143\u6570\u636e\u4e34\u65f6\u6587\u4ef6\uff1a{}", (Object)tmpFilePath);
            }
        }
        Pointer p = parser.InitTableColumnMetas(JsonUtils.toJson(odbcConfig));
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            ReturnParameter returnParameter = null;
            try {
                returnParameter = (ReturnParameter)JSON.parseObject((String)utf8, ReturnParameter.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            ReturnParameter returnParameter2 = returnParameter;
            return returnParameter2;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    public static void cleanGTT(ConnectionConfig odbcConfig) {
        if (globalStaticParameter.getNeedCleanGtt() == 0) {
            return;
        }
        if (DbType.OCEAN_BASE_ORACLE.name().equalsIgnoreCase(odbcConfig.getTargetDialect())) {
            if (log.isInfoEnabled()) {
                log.info("\u6e05\u7406\u76ee\u6807\u5e93{}\u7684\u4e34\u65f6\u8868", (Object)odbcConfig.getTargetDialect());
            }
            try {
                String query = "BEGIN\r\n    FOR cur IN (\r\n        SELECT owner || '.' || table_name AS table_name\r\n        FROM all_tables \r\n        WHERE table_name LIKE 'UNISQL_GTT_UPDATE_MULTI_TABLE_%'\r\n    ) LOOP\r\n        BEGIN\r\n            EXECUTE IMMEDIATE 'DROP TABLE ' || cur.table_name;\r\n        EXCEPTION\r\n            WHEN OTHERS THEN\r\n                NULL;\r\n        END;\r\n    END LOOP;\r\n    \r\nEXCEPTION\r\n    WHEN OTHERS THEN\r\n        NULL;\r\nEND;";
                String driverName = "com.alipay.oceanbase.jdbc.Driver";
                String urlFormat = "jdbc:oceanbase://%s:%s/%s";
                Class.forName(driverName);
                String jdbcUrl = String.format(urlFormat, odbcConfig.getHost(), odbcConfig.getPort(), odbcConfig.getDbname());
                log.debug("\u4ece {} \u5e93\u4e2d\u6e05\u7406\u4e34\u65f6\u8868\uff0c\u8fde\u63a5\uff1a{}\uff0c\u7528\u6237\uff1a{}", new Object[]{odbcConfig.getTargetDialect(), jdbcUrl, odbcConfig.getUser()});
                try (Connection connection = DriverManager.getConnection(jdbcUrl, odbcConfig.getUser(), odbcConfig.getPassword());
                     Statement statement = connection.createStatement();){
                    statement.executeUpdate(query);
                }
            }
            catch (Exception e) {
                log.warn("\u6e05\u7406\u4e34\u65f6\u8868\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void checkVersion() {
        String iteratorVersion = Version.iteratorVersion();
        String svnVersion = Version.svnVersion();
        log.info("sql-convert-runtime\u7248\u672c\u53f7\u4e3a[{},{}]", (Object)iteratorVersion, (Object)svnVersion);
        String goVersionFile = "";
        IGoParser parser = null;
        Pointer p = null;
        try {
            parser = GoParserFactory.getGoParser();
            p = parser.UnisqlVersion();
            goVersionFile = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            log.info("\u7edf\u4e00SQL\u52a8\u6001\u5e93\u7248\u672c\u4fe1\u606f\u4e3a[{}]", (Object)goVersionFile);
        }
        catch (UnsatisfiedLinkError e) {
            String msg = "\u7edf\u4e00SQL\u94fe\u63a5\u5e93\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u6309\u5982\u4e0b\u6b65\u9aa4\u6392\u67e5:\n1. \u68c0\u67e5\u7edf\u4e00SQL\u7684\u52a8\u6001\u5e93\u7248\u672c\u548c\u5f53\u524d\u5f15\u7528\u7684\u7edf\u4e00SQL jar\u5305\u7248\u672c\u662f\u5426\u4e25\u683c\u4e00\u81f4\u3002\n2. \u68c0\u67e5\u64cd\u4f5c\u7cfb\u7edf\u5e73\u53f0\u662f\u5426\u7b26\u5408\u8981\u6c42\uff0clinux\u9700\u8981\u5185\u6838\u7248\u672c3.0\u4ee5\u4e0a(\u5982centos6\u4e0d\u652f\u6301)\uff0cwindows\u9700\u8981Win10,WindowsServer 2016\u53ca\u4ee5\u4e0a(\u5982win7\u4e0d\u652f\u6301\uff09\u3002\n3. \u7edf\u4e00SQL\u52a8\u6001\u5e93\u7684\u7b2c\u4e09\u65b9\u4f9d\u8d56\u662f\u5426\u5b58\u5728\uff0c\u5728linux\u4e0b\u53ef\u901a\u8fc7ldd\u547d\u4ee4\u786e\u8ba4\u4f9d\u8d56\uff0c\u5728windows\u4e0b\u9700\u8981\u63d0\u4f9bpthread.dll\u52a8\u6001\u5e93\n4. \u7edf\u4e00SQL jar\u5305\u9700\u6309\u7167\u624b\u518c\u6b63\u786e\u5f15\u7528\uff0c\u4e14\u4e0d\u80fd\u5254\u9664\u7edf\u4e00SQL\u4f9d\u8d56\u7684\u5176\u4ed6\u7b2c\u4e09\u65b9\u4f9d\u8d56\u3002";
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            if (p != null) {
                parser.FreePointer(p);
            }
        }
        Version goVersion = new Version(goVersionFile);
        String goIteratorVersion = goVersion.getIteratorVersion();
        String goSvnVersion = goVersion.getSvnVersion();
        if (!goIteratorVersion.equals(iteratorVersion)) {
            String msg = String.format("\u7edf\u4e00SQL\u52a8\u6001\u5e93\u7248\u672c\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u4f9d\u8d56\u7684\u7edf\u4e00SQL\u52a8\u6001\u5e93\u7248\u672c\u548cjar\u5305\u7248\u672c\u662f\u5426\u4e25\u683c\u4e00\u81f4\u3002 \u5f53\u524d\u52a8\u6001\u5e93\u7248\u672c\u4e3a: [%s], java runtime\u7248\u672c\u4e3a: [%s]", goIteratorVersion, iteratorVersion);
            log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public static String getTableName(VariableParameter variableParameter) {
        return TransformerInternal.getTableName(variableParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyntaxAnalyseResult CheckCompatibleScanSql(VariableParameter variableParameter) {
        IGoParser parser = GoParserFactory.getGoParser();
        String encode = variableParameter.encode();
        Pointer p = parser.CheckCompatibleScanSql(encode);
        try {
            String utf8 = p.getString(0L, Integer.MAX_VALUE, StandardCharsets.UTF_8);
            SyntaxAnalyseResult returnParameter = null;
            try {
                returnParameter = (SyntaxAnalyseResult)JSON.parseObject((String)utf8, SyntaxAnalyseResult.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0005, utf8));
            }
            SyntaxAnalyseResult syntaxAnalyseResult = returnParameter;
            return syntaxAnalyseResult;
        }
        finally {
            parser.FreePointer(p);
        }
    }

    public static ReturnParameter IdentifySqlType(VariableParameter variableParameter) {
        return TransformerInternal.IdentifySqlType(variableParameter);
    }

    private static String userInputSchemaPreprocess(String userInputSchema) {
        userInputSchema = userInputSchema.toUpperCase();
        CharSequence[] schemaArray = userInputSchema.split(",");
        for (int i = 0; i < schemaArray.length; ++i) {
            if (schemaArray[i].startsWith("'") && ((String)schemaArray[i]).endsWith("'")) continue;
            schemaArray[i] = "'" + (String)schemaArray[i] + "'";
        }
        userInputSchema = String.join((CharSequence)",", schemaArray);
        return userInputSchema;
    }

    private static List<ColumnMetadata> queryOracleColumnMetadata(ConnectionConfig connectionConfig) throws Exception {
        String sqlFormat = "";
        String driverName = "";
        String urlFormat = "";
        if (DbType.OCEAN_BASE_ORACLE.name().equalsIgnoreCase(connectionConfig.getTargetDialect())) {
            sqlFormat = "SELECT         cols.owner as schema_name,         cols.table_name AS table_name,         cols.column_name AS column_name,         cols.data_type AS data_type,         CASE                 cols.nullable WHEN 'N' THEN 'NO'                 ELSE 'YES'         END AS is_nullable,         CASE                 WHEN cons.CONSTRAINT_TYPE = 'P' THEN 'PRIMARY KEY'                 WHEN inds.UNIQUENESS = 'UNIQUE' THEN 'UNIQUE'                 ELSE NULL         END AS constraint_type,         cols.DATA_DEFAULT AS column_default,         cols.COLUMN_ID AS ordinal_position,         CASE                 WHEN cols.nullable = 'N' THEN 'YES'                 ELSE 'NO'         END AS null_constraint,         'NO' AS auto_increment,         'NO' AS on_update_current_timestamp,         indc.INDEX_NAME AS CONSTRAINT_NAME FROM         ALL_TAB_COLUMNS cols LEFT JOIN ALL_IND_COLUMNS indc ON         cols.OWNER = indc.INDEX_OWNER         AND cols.TABLE_NAME = indc.TABLE_NAME         AND cols.COLUMN_NAME = indc.COLUMN_NAME LEFT JOIN ALL_CONSTRAINTS cons ON         cons.OWNER = COLS.OWNER         AND cons.TABLE_NAME = cols.TABLE_NAME         AND cons.CONSTRAINT_NAME = indc.INDEX_NAME LEFT JOIN ALL_INDEXES inds ON         inds.OWNER = cols.OWNER         AND inds.TABLE_NAME = cols.TABLE_NAME         AND inds.INDEX_NAME = indc.INDEX_NAME WHERE         cols.owner IN ( %s ) ORDER BY         cols.TABLE_NAME,         cols.COLUMN_ID ";
            driverName = "com.alipay.oceanbase.jdbc.Driver";
            urlFormat = "jdbc:oceanbase://%s:%s/%s";
        } else if (DbType.ORACLE.name().equalsIgnoreCase(connectionConfig.getTargetDialect()) || DbType.ORACLE_19C.name().equalsIgnoreCase(connectionConfig.getTargetDialect())) {
            sqlFormat = "SELECT  cols.owner as schema_name, (cols.table_name) AS table_name, (cols.column_name) AS column_name, (cols.data_type) AS data_type, CASE cols.nullable WHEN 'N' THEN 'NO' ELSE 'YES' END AS is_nullable, CASE WHEN (  SELECT cons.CONSTRAINT_TYPE  FROM ALL_CONSTRAINTS cons  WHERE cons.OWNER = COLS.OWNER  AND cons.TABLE_NAME = cols.TABLE_NAME  AND cons.CONSTRAINT_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'P' THEN 'PRIMARY KEY' WHEN (  SELECT inds.UNIQUENESS  FROM ALL_INDEXES inds  WHERE inds.OWNER = cols.OWNER  AND inds.TABLE_NAME = cols.TABLE_NAME  AND inds.INDEX_NAME = indc.INDEX_NAME  AND rownum = 1 ) = 'UNIQUE' THEN 'UNIQUE' ELSE NULL END AS constraint_type, cols.DATA_DEFAULT AS column_default, cols.COLUMN_ID AS ordinal_position, case when cols.nullable = 'N' then 'YES' else 'NO' end as null_constraint, 'NO' AS auto_increment, 'NO' AS on_update_current_timestamp, indc.INDEX_NAME AS CONSTRAINT_NAME FROM ALL_TAB_COLUMNS cols LEFT JOIN ALL_IND_COLUMNS indc ON cols.OWNER = indc.INDEX_OWNER AND cols.TABLE_NAME = indc.TABLE_NAME AND cols.COLUMN_NAME = indc.COLUMN_NAME WHERE cols.owner in (%s) ORDER BY cols.TABLE_NAME, cols.COLUMN_ID";
            driverName = "oracle.jdbc.OracleDriver";
            urlFormat = "jdbc:oracle:thin:@%s:%s/%s";
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + connectionConfig.getTargetDialect());
        }
        Class.forName(driverName);
        String finalSchemas = "";
        if (StringUtils.isNotEmpty((CharSequence)connectionConfig.getSchemas())) {
            finalSchemas = connectionConfig.getSchemas();
        } else if (StringUtils.isNotEmpty((CharSequence)globalStaticParameter.getTableColumnMetadataSchemas())) {
            finalSchemas = globalStaticParameter.getTableColumnMetadataSchemas();
        }
        finalSchemas = StringUtils.isNotEmpty((CharSequence)finalSchemas) ? Transformer.userInputSchemaPreprocess(finalSchemas) : "sys_context('USERENV', 'CURRENT_SCHEMA')";
        log.debug("\u4eceschema\uff1a[{}]\u83b7\u53d6\u5143\u6570\u636e", (Object)finalSchemas);
        String query = String.format(sqlFormat, finalSchemas);
        String jdbcUrl = String.format(urlFormat, connectionConfig.getHost(), connectionConfig.getPort(), connectionConfig.getDbname());
        log.debug("\u4ece {} \u5e93\u4e2d\u83b7\u53d6\u5143\u6570\u636e\uff0c\u8fde\u63a5\uff1a{}\uff0c\u7528\u6237\uff1a{}", new Object[]{connectionConfig.getTargetDialect(), jdbcUrl, connectionConfig.getUser()});
        ArrayList<ColumnMetadata> metadataList = new ArrayList<ColumnMetadata>();
        try (Connection connection = DriverManager.getConnection(jdbcUrl, connectionConfig.getUser(), connectionConfig.getPassword());
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                int i = 1;
                ColumnMetadata columnMetadata = new ColumnMetadata();
                columnMetadata.setSchemaName(rs.getString(i++));
                columnMetadata.setTableName(rs.getString(i++));
                columnMetadata.setColumnName(rs.getString(i++));
                columnMetadata.setDataType(rs.getString(i++));
                columnMetadata.setIsNullable(rs.getString(i++));
                columnMetadata.setConstraintType(rs.getString(i++));
                columnMetadata.setColumnDefault(rs.getString(i++));
                columnMetadata.setOrdinalPosition(rs.getInt(i++));
                columnMetadata.setNullConstraint(rs.getString(i++));
                columnMetadata.setAutoIncrement(rs.getString(i++));
                columnMetadata.setOnUpdateCurrentTimestamp(rs.getString(i++));
                columnMetadata.setConstraintName(rs.getString(i++));
                metadataList.add(columnMetadata);
            }
        }
        log.debug("\u67e5\u8be2\u5230\u7684\u5217\u5143\u6570\u636e\u6570\u91cf\uff1a{}", (Object)metadataList.size());
        return metadataList;
    }

    public static Long createSession() {
        IGoParser parser = GoParserFactory.getGoParser();
        return parser.UnisqlCreateSession();
    }

    public static void freeSession(Long sessionId) {
        IGoParser parser = GoParserFactory.getGoParser();
        parser.UnisqlFreeSession(sessionId);
    }

    public static String getGenLastInsertIdSql() {
        return TransformerInternal.getGenLastInsertIdSql();
    }

    public static void main(String[] args) {
        ConnectionConfig connectionConfig = new ConnectionConfig();
        connectionConfig.setUser("zhouhj43183_oracle@oracle_tenant");
        connectionConfig.setPassword("zhouhj43183_oracle");
        connectionConfig.setHost("10.20.47.202");
        connectionConfig.setPort("2883");
        connectionConfig.setDbname("zhouhj43183_oracle");
        connectionConfig.setTargetDialect("OCEAN_BASE_ORACLE");
        connectionConfig.setSchemas("'zhouhj43183_oracle'");
        Transformer.initTableColumnMetas(connectionConfig);
        VariableParameter variableParameter = new VariableParameter();
        IGoParser parser = GoParserFactory.getGoParser();
        variableParameter.setSourceSql("select '\u6d59\u6c5f\u7701\u676d\u5dde\u5e02abc\u6052\u751f\u7535\u5b50123\u65e5\u671f111',122312,111 from dual");
        variableParameter.setSourceDialect("oracle");
        variableParameter.setTargetDialect("postgresql");
        variableParameter.setSessionId(123L);
        Pointer transformResultPointer = null;
        try {
            byte[] encode = variableParameter.encodeToBytes();
            Runtime runtime = Runtime.getSystemRuntime();
            Pointer transformParamPointer = Pointer.wrap((Runtime)runtime, (ByteBuffer)ByteBuffer.wrap(encode));
            transformResultPointer = parser.UnisqlTransformInternel(transformParamPointer);
            ReturnParameter returnParameter = ReturnParameter.decode(transformResultPointer);
            System.out.println(returnParameter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PATTERN_ORACLE19C_META_NAME_REPLACER = Pattern.compile("[\\\\/*?:\"<>|]");
        Transformer.setConfigration();
    }

    static class TableNameValue {
        String sourceSql;
        String tableNames;

        public TableNameValue(String sourceSql, String tableNames) {
            this.sourceSql = sourceSql;
            this.tableNames = tableNames;
        }
    }
}

