/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

public enum SqlState {
    SUCCESS("00000", "SUCCESS"),
    PARSE_ERROR("56098", "PARSE ERROR"),
    CONVERT_ERROR("57017", "CONVERT ERROR"),
    RESTORE_ERROR("55061", "RESTORE ERROR");

    private final String state;
    private final String value;

    public static String getValue(String state) {
        for (SqlState e : SqlState.values()) {
            if (!e.getState().equals(state)) continue;
            return e.getValue();
        }
        return state;
    }

    public static boolean containsErrorCode(String state) {
        if (SUCCESS.getState().equals(state)) {
            return false;
        }
        for (SqlState constant : SqlState.values()) {
            if (!constant.getState().equals(state)) continue;
            return true;
        }
        return false;
    }

    private SqlState(String state, String value) {
        this.state = state;
        this.value = value;
    }

    public String getState() {
        return this.state;
    }

    public String getValue() {
        return this.value;
    }
}

