/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import shaded.net.sf.jsqlparser.statement.Block;
import shaded.net.sf.jsqlparser.statement.Commit;
import shaded.net.sf.jsqlparser.statement.CreateFunctionalStatement;
import shaded.net.sf.jsqlparser.statement.DeclareStatement;
import shaded.net.sf.jsqlparser.statement.DescribeStatement;
import shaded.net.sf.jsqlparser.statement.ExplainStatement;
import shaded.net.sf.jsqlparser.statement.IfElseStatement;
import shaded.net.sf.jsqlparser.statement.PurgeStatement;
import shaded.net.sf.jsqlparser.statement.ResetStatement;
import shaded.net.sf.jsqlparser.statement.RollbackStatement;
import shaded.net.sf.jsqlparser.statement.SavepointStatement;
import shaded.net.sf.jsqlparser.statement.SetStatement;
import shaded.net.sf.jsqlparser.statement.ShowColumnsStatement;
import shaded.net.sf.jsqlparser.statement.ShowStatement;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.StatementVisitor;
import shaded.net.sf.jsqlparser.statement.Statements;
import shaded.net.sf.jsqlparser.statement.UnsupportedStatement;
import shaded.net.sf.jsqlparser.statement.UseStatement;
import shaded.net.sf.jsqlparser.statement.alter.Alter;
import shaded.net.sf.jsqlparser.statement.alter.AlterSession;
import shaded.net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import shaded.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import shaded.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import shaded.net.sf.jsqlparser.statement.analyze.Analyze;
import shaded.net.sf.jsqlparser.statement.comment.Comment;
import shaded.net.sf.jsqlparser.statement.create.index.CreateIndex;
import shaded.net.sf.jsqlparser.statement.create.schema.CreateSchema;
import shaded.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import shaded.net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import shaded.net.sf.jsqlparser.statement.create.table.CreateTable;
import shaded.net.sf.jsqlparser.statement.create.view.AlterView;
import shaded.net.sf.jsqlparser.statement.create.view.CreateView;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.drop.Drop;
import shaded.net.sf.jsqlparser.statement.execute.Execute;
import shaded.net.sf.jsqlparser.statement.grant.Grant;
import shaded.net.sf.jsqlparser.statement.insert.Insert;
import shaded.net.sf.jsqlparser.statement.merge.Merge;
import shaded.net.sf.jsqlparser.statement.merge.MergeInsert;
import shaded.net.sf.jsqlparser.statement.merge.MergeUpdate;
import shaded.net.sf.jsqlparser.statement.refresh.RefreshMaterializedViewStatement;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.select.WithItem;
import shaded.net.sf.jsqlparser.statement.show.ShowIndexStatement;
import shaded.net.sf.jsqlparser.statement.show.ShowTablesStatement;
import shaded.net.sf.jsqlparser.statement.truncate.Truncate;
import shaded.net.sf.jsqlparser.statement.update.Update;
import shaded.net.sf.jsqlparser.statement.upsert.Upsert;
import shaded.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import shaded.net.sf.jsqlparser.util.deparser.AlterDeParser;
import shaded.net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import shaded.net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import shaded.net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import shaded.net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import shaded.net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import shaded.net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import shaded.net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import shaded.net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import shaded.net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.DeleteDeParser;
import shaded.net.sf.jsqlparser.util.deparser.DropDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import shaded.net.sf.jsqlparser.util.deparser.GrantDeParser;
import shaded.net.sf.jsqlparser.util.deparser.InsertDeParser;
import shaded.net.sf.jsqlparser.util.deparser.RefreshMaterializedViewStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.SelectDeParser;
import shaded.net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ShowIndexStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import shaded.net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import shaded.net.sf.jsqlparser.util.deparser.UpdateDeParser;
import shaded.net.sf.jsqlparser.util.deparser.UpsertDeParser;
import shaded.net.sf.jsqlparser.util.deparser.UseStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.selectDeParser.setBuffer(buffer);
        this.selectDeParser.setExpressionVisitor(expressionDeParser);
        this.expressionDeParser.setSelectVisitor(selectDeParser);
        this.expressionDeParser.setBuffer(buffer);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(RefreshMaterializedViewStatement materializedViewStatement) {
        new RefreshMaterializedViewStatementDeParser(this.buffer).deParse(materializedViewStatement);
    }

    @Override
    public void visit(AlterView alterView) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Select select) {
        select.accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.buffer.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.buffer.append(" ONLY");
        }
        this.buffer.append(" ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.buffer);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(Analyze analyzer) {
        this.buffer.append("ANALYZE ");
        this.buffer.append(analyzer.getTable());
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(ResetStatement reset) {
        ResetStatementDeParser setStatementDeparser = new ResetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(reset);
    }

    @Override
    public void visit(Merge merge) {
        List<WithItem> withItemsList = merge.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this.expressionDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("MERGE ");
        if (merge.getOracleHint() != null) {
            this.buffer.append(merge.getOracleHint()).append(" ");
        }
        this.buffer.append("INTO ");
        merge.getTable().accept(this.selectDeParser);
        this.buffer.append(" USING ");
        merge.getFromItem().accept(this.selectDeParser);
        this.buffer.append(" ON ");
        merge.getOnCondition().accept(this.expressionDeParser);
        MergeInsert mergeInsert = merge.getMergeInsert();
        MergeUpdate mergeUpdate = merge.getMergeUpdate();
        if (merge.isInsertFirst() && mergeInsert != null) {
            this.deparseMergeInsert(mergeInsert);
        }
        if (mergeUpdate != null) {
            this.buffer.append(" WHEN MATCHED");
            if (mergeUpdate.getAndPredicate() != null) {
                this.buffer.append(" AND ");
                mergeUpdate.getAndPredicate().accept(this.expressionDeParser);
            }
            this.buffer.append(" THEN UPDATE SET ");
            StatementDeParser.deparseUpdateSets(mergeUpdate.getUpdateSets(), this.buffer, this.expressionDeParser);
            if (mergeUpdate.getWhereCondition() != null) {
                this.buffer.append(" WHERE ");
                mergeUpdate.getWhereCondition().accept(this.expressionDeParser);
            }
            if (mergeUpdate.getDeleteWhereCondition() != null) {
                this.buffer.append(" DELETE WHERE ");
                mergeUpdate.getDeleteWhereCondition().accept(this.expressionDeParser);
            }
        }
        if (!merge.isInsertFirst() && mergeInsert != null) {
            this.deparseMergeInsert(mergeInsert);
        }
        if (merge.getOutputClause() != null) {
            merge.getOutputClause().appendTo(this.buffer);
        }
    }

    private void deparseMergeInsert(MergeInsert mergeInsert) {
        this.buffer.append(" WHEN NOT MATCHED");
        if (mergeInsert.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeInsert.getAndPredicate().accept(this.expressionDeParser);
        }
        this.buffer.append(" THEN INSERT ");
        if (mergeInsert.getColumns() != null) {
            mergeInsert.getColumns().accept(this.expressionDeParser);
        }
        this.buffer.append(" VALUES ");
        mergeInsert.getValues().accept(this.expressionDeParser);
        if (mergeInsert.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeInsert.getWhereCondition().accept(this.expressionDeParser);
        }
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
        this.buffer.append(savepointStatement.toString());
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
        this.buffer.append(rollbackStatement.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        new UseStatementDeParser(this.buffer).deParse(use);
    }

    @Override
    public void visit(ShowColumnsStatement show) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(ShowIndexStatement showIndexes) {
        new ShowIndexStatementDeParser(this.buffer).deParse(showIndexes);
    }

    @Override
    public void visit(ShowTablesStatement showTables) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTables);
    }

    @Override
    public void visit(Block block) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements().getStatements()) {
                stmt.accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
        if (block.hasSemicolonAfterEnd()) {
            this.buffer.append(";");
        }
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(DescribeStatement describe) {
        this.buffer.append(describe.getDescribeType());
        this.buffer.append(" ");
        this.buffer.append(describe.getTable());
    }

    @Override
    public void visit(ExplainStatement explain) {
        this.buffer.append("EXPLAIN ");
        if (explain.getTable() != null) {
            this.buffer.append(explain.getTable());
        } else if (explain.getOptions() != null) {
            this.buffer.append(explain.getOptions().values().stream().map(ExplainStatement.Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        if (explain.getStatement() != null) {
            explain.getStatement().accept(this);
        }
    }

    @Override
    public void visit(ShowStatement show) {
        new ShowStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(DeclareStatement declare) {
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declare);
    }

    @Override
    public void visit(Grant grant) {
        GrantDeParser grantDeParser = new GrantDeParser(this.buffer);
        grantDeParser.deParse(grant);
    }

    @Override
    public void visit(CreateSchema aThis) {
        this.buffer.append(aThis.toString());
    }

    @Override
    public void visit(CreateSequence createSequence) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.buffer.append(createFunctionalStatement.toString());
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(AlterSession alterSession) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
        renameTableStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
        purgeStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
        alterSystemStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
        unsupportedStatement.appendTo(this.buffer);
    }
}

