/*
 * Decompiled with CFR 0.152.
 */
package shaded.jnr.a64asm;

import java.util.EnumMap;
import java.util.Map;
import shaded.jnr.a64asm.INST_CODE;
import shaded.jnr.a64asm.InstructionGroup;

public final class InstructionDescription {
    final INST_CODE code;
    final int opcode;
    final int mask;
    final InstructionGroup group;
    private static final Map<INST_CODE, InstructionDescription> table = new EnumMap<INST_CODE, InstructionDescription>(INST_CODE.class);
    private static final InstructionDescription[] all = new InstructionDescription[]{InstructionDescription.MAKE_INST(INST_CODE.INST_ADC_ADDSUB_CARRY, 0x1A000000, 2145451008, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_ADCS_ADDSUB_CARRY, 0x3A000000, 2145451008, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_ADD_ADDSUB_IMM, 0x11000000, 0x7F000000, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_ADD_ADDSUB_SHIFT, 0xB000000, 2132803584, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ADDS_ADDSUB_IMM, 0x31000000, 0x7F000000, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_ADD_EXT_ADDSUB_EXT, 0xB200000, 2145386496, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_ADDS_ADDSUB_EXT, 0x2B200000, 2145386496, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_ADDS_ADDSUB_SHIFT, 0x2B000000, 2132803584, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ADR_PCRELADDR, 0x10000000, -1627389952, InstructionGroup.pcreladdr), InstructionDescription.MAKE_INST(INST_CODE.INST_ADRP_PCRELADDR, -1879048192, -1627389952, InstructionGroup.pcreladdr), InstructionDescription.MAKE_INST(INST_CODE.INST_AND_LOG_IMM, 0x12000000, 2139095040, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_AND_LOG_SHIFT, 0xA000000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ANDS_LOG_IMM, 0x72000000, 2139095040, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_ANDS_LOG_SHIFT, 0x6A000000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ASR_BITFIELD, 0x13000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_ASR_DP_2SRC, 448800768, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_ASRV_DP_2SRC, 448800768, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_AT_IC_SYSTEM, -720896000, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_B_C_CONDBRANCH, 0x14000000, -67108864, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_B_BRANCH_IMM, 0x54000000, -16777200, InstructionGroup.branch_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_BCC_CONDBRANCH, 1409286147, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BCS_CONDBRANCH, 1409286146, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BEQ_CONDBRANCH, 0x54000000, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BFI_BITFIELD, 0x33000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_BFM_BITFIELD, 0x33000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_BFXIL_BITFIELD, 0x33000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_BGE_CONDBRANCH, 1409286154, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BGT_CONDBRANCH, 1409286156, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BHI_CONDBRANCH, 1409286152, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BHS_CONDBRANCH, 1409286146, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BIC_LOG_IMM, 0x12000000, 2139095040, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_BIC_LOG_SHIFT, 0xA200000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_BICS_LOG_SHIFT, 1780482048, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_BL_BRANCH_IMM, -1811939328, -67108864, InstructionGroup.branch_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_BLE_CONDBRANCH, 1409286157, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BLO_CONDBRANCH, 1409286147, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BLR_BRANCH_REG, -700514304, -993, InstructionGroup.branch_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_BLS_CONDBRANCH, 1409286153, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BLT_CONDBRANCH, 1409286155, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BMI_CONDBRANCH, 0x54000004, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BNE_CONDBRANCH, 1409286145, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BPL_CONDBRANCH, 0x54000005, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BR_BRANCH_REG, -702611456, -993, InstructionGroup.branch_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_BRK_EXCEPTION, -736100352, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_BVC_CONDBRANCH, 1409286151, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_BVS_CONDBRANCH, 1409286150, -16777185, InstructionGroup.condbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_CBNZ_COMPBRANCH, 0x35000000, 0x7F000000, InstructionGroup.compbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_CBZ_COMPBRANCH, 0x34000000, 0x7F000000, InstructionGroup.compbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_CCMN_CONDCMP_IMM, 977274880, 2145389584, InstructionGroup.condcmp_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_CCMN_CONDCMP_REG, 977272832, 2145389584, InstructionGroup.condcmp_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_CCMP_CONDCMP_IMM, 2051016704, 2145389584, InstructionGroup.condcmp_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_CCMP_CONDCMP_REG, 2051014656, 2145389584, InstructionGroup.condcmp_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_CINC_CONDSEL, 444597248, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CINV_CONDSEL, 1518338048, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CLREX_IC_SYSTEM, -721211297, -3841, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_CLS_DP_1SRC, 1522537472, 2147482624, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_CLZ_DP_1SRC, 1522536448, 2147482624, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_CMN_ADDSUB_EXT, 723517471, 2145386527, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_CMN_ADDSUB_IMM, 822083615, 2130706463, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_CMN_ADDSUB_SHIFT, 721420319, 2132803615, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_CMP_ADDSUB_EXT, 1797259295, 2145386527, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_CMP_ADDSUB_IMM, 1895825439, 2130706463, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_CMP_ADDSUB_SHIFT, 1795162143, 2132803615, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_CNEG_CONDSEL, 1518339072, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSEL_CONDSEL, 444596224, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSET_CONDSEL, 446629856, 2147422176, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSETM_CONDSEL, 1520370656, 2147422176, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSINC_CONDSEL, 444597248, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSINV_CONDSEL, 1518338048, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_CSNEG_CONDSEL, 1518339072, 2145389568, InstructionGroup.condsel), InstructionDescription.MAKE_INST(INST_CODE.INST_DC_IC_SYSTEM, -720896000, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_DCPS1_EXCEPTION, -727711743, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_DCPS2_EXCEPTION, -727711742, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_DCPS3_EXCEPTION, -727711741, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_DMB_IC_SYSTEM, -721211201, -3841, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_DRPS_BRANCH_REG, -692124704, -1, InstructionGroup.branch_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_DSB_IC_SYSTEM, -721211233, -3841, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_EON_LOG_SHIFT, 1243611136, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_EOR_LOG_IMM, 0x52000000, 2139095040, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_EOR_LOG_SHIFT, 0x4A000000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ERET_BRANCH_REG, -694221856, -1, InstructionGroup.branch_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_EXTR_EXTRACT, 327155712, 2141192192, InstructionGroup.extract), InstructionDescription.MAKE_INST(INST_CODE.INST_HINT_IC_SYSTEM, -721215457, -4065, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_HLT_EXCEPTION, -734003200, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_HVC_EXCEPTION, -738197502, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_IC_IC_SYSTEM, -720896000, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_ISB_IC_SYSTEM, -721211169, -3841, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_LDAR_LDSTEXCL, -1998586880, -1075806208, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDARB_LDSTEXCL, 148896768, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDARH_LDSTEXCL, 1222638592, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDAXP_LDSTEXCL, -2004910080, -1075806208, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_LDAXR_LDSTEXCL, -2006975488, -1075806208, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDAXRB_LDSTEXCL, 140508160, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDAXRH_LDSTEXCL, 1214249984, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDNP_LDSTNAPAIR_OFFS, 675282944, 2143289344, InstructionGroup.ldstnapair_offs), InstructionDescription.MAKE_INST(INST_CODE.INST_LDNP_LDSTNAPAIR_OFFS_V, 742391808, 1069547520, InstructionGroup.ldstnapair_offs), InstructionDescription.MAKE_INST(INST_CODE.INST_LDP_POST_INDEXED_IDST_IMM9, 683671552, 2126512128, InstructionGroup.ldst_imm9_2reg), InstructionDescription.MAKE_INST(INST_CODE.INST_LDP_PRE_INDEXED_IDST_IMM9, 700448768, 2126512128, InstructionGroup.ldst_imm9_2reg), InstructionDescription.MAKE_INST(INST_CODE.INST_LDP_LDSTPAIR_OFF_LDST_POS, 692060160, 2126512128, InstructionGroup.ldst_pos_2reg), InstructionDescription.MAKE_INST(INST_CODE.INST_LDPSW_POST_INDEXED, 1757413376, -4194304, InstructionGroup.ldstpair_indexed), InstructionDescription.MAKE_INST(INST_CODE.INST_LDPSW_PRE_INDEXED, 1774190592, -4194304, InstructionGroup.ldstpair_indexed), InstructionDescription.MAKE_INST(INST_CODE.INST_LDPSW_OFF, 1765801984, -4194304, InstructionGroup.ldstpair_off), InstructionDescription.MAKE_INST(INST_CODE.INST_LDR_IMM_POST, -1203764224, -1075837952, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDR_IMM_PRE, -1203762176, -1075835904, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDR_IMM_OFF, -1186988032, -1077936128, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDR_REG, -1201666048, -1075835904, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDR_LOADLIT, 0x18000000, -1090519040, InstructionGroup.loadlit), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRB_IMM_POST, 943719424, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRB_IMM_PRE, 943721472, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRB_IMM_OFF, 960495616, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRB_REG, 945817600, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRH_IMM_POST, 2017461248, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRH_IMM_PRE, 2017463296, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRH_IMM_OFF, 2034237440, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRH_REG, 2019559424, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSB_IMM_POST, 947913728, -6288384, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSB_IMM_PRE, 947915776, -6288384, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSB_IMM_OFF, 964689920, -8388608, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSB_REG, 950011904, -6288384, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSH_IMM_POST, 2021655552, -6288384, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSH_IMM_PRE, 2021657600, -6288384, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSH_IMM_OFF, 2038431744, -8388608, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSH_REG, 2023753728, -6288384, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSW_IMM_POST, -1199569920, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSW_IMM_PRE, -1199567872, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSW_IMM_OFF, -1182793728, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSW_REG, -1197471744, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_LDRSW_LOADLIT, -1744830464, -16777216, InstructionGroup.loadlit), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTR_LDST_UNPRIV, -1203763200, -1075835904, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTRB_LDST_UNPRIV, 943720448, -2094080, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTRH_LDST_UNPRIV, 2017462272, -2094080, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTRSB_LDST_UNPRIV, 0x38800800, -6288384, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTRSH_LDST_UNPRIV, 0x78800800, -6288384, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDTRSW_LDST_UNPRIV, -1199568896, -2094080, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_LDUR_LDST_UNSCALED, 1010827264, 1063259136, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDUR_LDST_UNSCALED_X, -1203765248, -1075835904, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDURB_LDST_UNSCALED, 943718400, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDURH_LDST_UNSCALED, 2017460224, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDURSB_LDST_UNSCALED, 0x38800000, -6288384, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDURSH_LDST_UNSCALED, 0x78800000, -6288384, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDURSW_LDST_UNSCALED, -1199570944, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_LDXP_LDSTEXCL, -2004942848, -1075806208, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_LDXR_LDSTEXCL, -2007008256, -1075806208, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDXRB_LDSTEXCL, 140475392, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LDXRH_LDSTEXCL, 1214217216, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_LSL_BITFIELD, 0x53000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_LSL_DP_2SRC, 448798720, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_LSLV_DP_2SRC, 448798720, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_LSR_BITFIELD, 0x53000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_LSR_DP_2SRC, 448799744, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_LSRV_DP_2SRC, 448799744, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_MADD_DP_3SRC, 0x1B000000, 2145419264, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_MNEG_DP_3SRC, 453049344, 2145451008, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_MOV_ADDSUB_IMM, 704644064, 2147482624, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_MOV_LOG_IMM, 838861792, 2139096032, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_MOV_LOG_SHIFT, 285213664, 2132804576, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_MOV_MOVEWIDE, 310378496, 2139095040, InstructionGroup.movewide), InstructionDescription.MAKE_INST(INST_CODE.INST_MOV_MOVEWIDE_X, 1384120320, 2139095040, InstructionGroup.movewide), InstructionDescription.MAKE_INST(INST_CODE.INST_MOVK_MOVEWIDE, 1920991232, 2139095040, InstructionGroup.movewide), InstructionDescription.MAKE_INST(INST_CODE.INST_MOVN_MOVEWIDE, 310378496, 2139095040, InstructionGroup.movewide), InstructionDescription.MAKE_INST(INST_CODE.INST_MOVZ_MOVEWIDE, 1384120320, 2139095040, InstructionGroup.movewide), InstructionDescription.MAKE_INST(INST_CODE.INST_MRS_IC_SYSTEM, -718274560, -1048576, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_MSR_IC_SYSTEM, -721403873, -462817, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_MSR_IC_SYSTEM_X, -720371712, -1048576, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_MSUB_DP_3SRC, 453017600, 2145419264, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_MUL_DP_3SRC, 453016576, 2145451008, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_MVN_LOG_SHIFT, 706741216, 2132804576, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_NEG_ADDSUB_SHIFT, 1258292192, 2132804576, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_NEGS_ADDSUB_SHIFT, 1795163104, 2132804576, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_NGC_ADDSUB_CARRY, 1509950432, 2145452000, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_NGCS_ADDSUB_CARRY, 2046821344, 2145452000, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_NOP_IC_SYSTEM, -721215457, -1, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_ORN_LOG_SHIFT, 0x2A200000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_ORR_LOG_IMM, 0x32000000, 2139095040, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_ORR_LOG_SHIFT, 0x2A000000, 2132803584, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_PRFM_LDST_POS__IMMEDIATE, -109051904, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_PRFM_LDST_REGOFF__REGISTER, -123729920, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_PRFM_LOADLIT__LITERAL, -671088640, -16777216, InstructionGroup.loadlit), InstructionDescription.MAKE_INST(INST_CODE.INST_PRFUM_LDST_UNSCALED, -125829120, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_RBIT_DP_1SRC, 1522532352, 2147482624, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_RET_BRANCH_REG, -698417152, -993, InstructionGroup.branch_reg), InstructionDescription.MAKE_INST(INST_CODE.INST_REV_DP_1SRC, 1522534400, -1024, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_REV_DP_1SRC_X, -624948224, 2147482624, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_REV16_DP_1SRC, 1522533376, 2147482624, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_REV32_DP_1SRC, -624949248, -1024, InstructionGroup.dp_1src), InstructionDescription.MAKE_INST(INST_CODE.INST_ROR_DP_2SRC, 448801792, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_ROR_EXTRACT, 327155712, 2141192192, InstructionGroup.extract), InstructionDescription.MAKE_INST(INST_CODE.INST_RORV_DP_2SRC, 448801792, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_SBC_ADDSUB_CARRY, 0x5A000000, 2145451008, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_SBCS_ADDSUB_CARRY, 0x7A000000, 2145451008, InstructionGroup.addsub_carry), InstructionDescription.MAKE_INST(INST_CODE.INST_SBFIZ_BITFIELD, 0x13000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SBFM_BITFIELD, 0x13000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SBFX_BITFIELD, 0x13000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SDIV_DP_2SRC, 448793600, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_SEV_IC_SYSTEM, -721215329, -1, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_SEVL_IC_SYSTEM, -721215297, -1, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_SMADDL_DP_3SRC, -1692401664, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_SMC_EXCEPTION, -738197501, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_SMNEGL_DP_3SRC, -1692337152, -2032640, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_SMSUBL_DP_3SRC, -1692368896, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_SMULH_DP_3SRC, -1690272768, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_SMULL_DP_3SRC, -1692369920, -2032640, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_STLR_LDSTEXCL, -2002781184, -1075806208, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_STLRB_LDSTEXCL, 144702464, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_STLRH_LDSTEXCL, 1218444288, -2064384, InstructionGroup.ldstexcl), InstructionDescription.MAKE_INST(INST_CODE.INST_STLXP_LDSTEXCL, -2011136000, -1075806208, InstructionGroup.ldstexcl_op4), InstructionDescription.MAKE_INST(INST_CODE.INST_STLXR_LDSTEXCL, -2013201408, -1075806208, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_STLXRB_LDSTEXCL, 134282240, -2064384, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_STLXRH_LDSTEXCL, 1208024064, -2064384, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_STNP_LDSTNAPAIR_OFFS, 0x28000000, 2143289344, InstructionGroup.ldstnapair_offs), InstructionDescription.MAKE_INST(INST_CODE.INST_STNP_LDSTNAPAIR_OFFS_X, 0x2C000000, 1069547520, InstructionGroup.ldstnapair_offs), InstructionDescription.MAKE_INST(INST_CODE.INST_STP_LDSTPAIR_INDEXED_POST, 0x28800000, 2143289344, InstructionGroup.ldstpair_indexed), InstructionDescription.MAKE_INST(INST_CODE.INST_STP_LDSTPAIR_INDEXED_PRE, 696254464, 2143289344, InstructionGroup.ldstpair_indexed), InstructionDescription.MAKE_INST(INST_CODE.INST_STP_LDSTPAIR_OFF, 0x29000000, 2143289344, InstructionGroup.ldstpair_off), InstructionDescription.MAKE_INST(INST_CODE.INST_STR_LDST_IMM9_PRE, -1207956480, -1084224512, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STR_LDST_IMM9_POST, -1207958528, -1075835904, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STR_LDST_POS, -1191182336, -1077936128, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_STR_LDST_REGOFF, -1205860352, -1075835904, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_STRB_LDST_IMM9_POST, 939525120, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STRB_LDST_OFFSET, 0x39000000, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_STRB_LDST_REGOFF, 941623296, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_STRB_LDST_PRE, 939527168, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STRH_LDST_IMM_PRE, 2013268992, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STRH_LDST_IMM_POST, 2013266944, -2094080, InstructionGroup.ldst_imm9), InstructionDescription.MAKE_INST(INST_CODE.INST_STRH_LDST_IMM_OFF, 0x79000000, -4194304, InstructionGroup.ldst_pos), InstructionDescription.MAKE_INST(INST_CODE.INST_STRH_LDST_REGOFF, 2015365120, -2094080, InstructionGroup.ldst_regoff), InstructionDescription.MAKE_INST(INST_CODE.INST_STTR_LDST_UNPRIV, -1207957504, -1075835904, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_STTRB_LDST_UNPRIV, 0x38000800, -2094080, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_STTRH_LDST_UNPRIV, 0x78000800, -2094080, InstructionGroup.ldst_unpriv), InstructionDescription.MAKE_INST(INST_CODE.INST_STUR_LDST_UNSCALED, 0x3C000000, 1063259136, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_STUR_LDST_UNSCALED_X, -1207959552, -1075835904, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_STURB_LDST_UNSCALED, 0x38000000, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_STURH_LDST_UNSCALED, 0x78000000, -2094080, InstructionGroup.ldst_unscaled), InstructionDescription.MAKE_INST(INST_CODE.INST_STXP_LDSTEXCL, -2011168768, -1075806208, InstructionGroup.ldstexcl_op4), InstructionDescription.MAKE_INST(INST_CODE.INST_STXR_LDSTEXCL, -2013234176, -1075806208, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_STXRB_LDSTEXCL, 134249472, -2064384, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_STXRH_LDSTEXCL, 1207991296, -2064384, InstructionGroup.ldstexcl_op3), InstructionDescription.MAKE_INST(INST_CODE.INST_SUB_ADDSUB_EXT, 1260388352, 2145386496, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_SUB_ADDSUB_IMM, 0x51000000, 0x7F000000, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_SUB_ADDSUB_SHIFT, 0x4B000000, 2132803584, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_SUBS_ADDSUB_EXT, 1797259264, 2145386496, InstructionGroup.addsub_ext), InstructionDescription.MAKE_INST(INST_CODE.INST_SUBS_ADDSUB_IMM, 0x71000000, 0x7F000000, InstructionGroup.addsub_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_SUBS_ADDSUB_SHIFT, 0x6B000000, 2132803584, InstructionGroup.addsub_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_SVC_EXCEPTION, -738197503, -2097121, InstructionGroup.exception), InstructionDescription.MAKE_INST(INST_CODE.INST_SXTB_BITFIELD, 318774272, 2143288320, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SXTH_BITFIELD, 318782464, 2143288320, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SXTW_BITFIELD, -1824490496, -1024, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_SYS_IC_SYSTEM, -720896000, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_SYSL_IC_SYSTEM, -718798848, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_TBNZ_TESTBRANCH, 0x37000000, 0x7F000000, InstructionGroup.testbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_TBZ_TESTBRANCH, 0x36000000, 0x7F000000, InstructionGroup.testbranch), InstructionDescription.MAKE_INST(INST_CODE.INST_TLBI_IC_SYSTEM, -720896000, -524288, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_TST_LOG_IMM, 1912602655, 2139095071, InstructionGroup.log_imm), InstructionDescription.MAKE_INST(INST_CODE.INST_TST_LOG_SHIFT, 1778384927, 2132803615, InstructionGroup.log_shift), InstructionDescription.MAKE_INST(INST_CODE.INST_UBFIZ_BITFIELD, 0x53000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_UBFM_BITFIELD, 0x53000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_UBFX_BITFIELD, 0x53000000, 2139095040, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_UDIV_DP_2SRC, 448792576, 2145451008, InstructionGroup.dp_2src), InstructionDescription.MAKE_INST(INST_CODE.INST_UMADDL_DP_3SRC, -1684013056, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_UMNEGL_DP_3SRC, -1683948544, -2032640, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_UMSUBL_DP_3SRC, -1683980288, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_UMULH_DP_3SRC, -1681884160, -2064384, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_UMULL_DP_3SRC, -1683981312, -2032640, InstructionGroup.dp_3src), InstructionDescription.MAKE_INST(INST_CODE.INST_UXTB_BITFIELD, 1392516096, -1024, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_UXTH_BITFIELD, 1392524288, -1024, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_UXTW_LOG_SHIFT, -750748672, 2132804576, InstructionGroup.bitfield), InstructionDescription.MAKE_INST(INST_CODE.INST_WFE_IC_SYSTEM, -721215393, -1, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_WFI_IC_SYSTEM, -721215361, -1, InstructionGroup.ic_system), InstructionDescription.MAKE_INST(INST_CODE.INST_YIELD_IC_SYSTEM, -721215425, -1, InstructionGroup.ic_system)};

    private static final InstructionDescription MAKE_INST(INST_CODE code, int opcode, int mask, InstructionGroup group) {
        InstructionDescription id = new InstructionDescription(code, opcode, mask, group);
        table.put(code, id);
        return id;
    }

    InstructionDescription(INST_CODE code, int opCode, int mask, InstructionGroup group) {
        this.code = code;
        this.opcode = opCode;
        this.mask = mask;
        this.group = group;
    }

    public static final InstructionDescription find(INST_CODE code) {
        InstructionDescription id = table.get((Object)code);
        if (id == null) {
            throw new IllegalArgumentException("no description for " + (Object)((Object)code));
        }
        return id;
    }
}

