/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.Transformer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String SELECT = "SELECT";
    public static final String DELETE = "DELETE";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static List<String> loopback = Arrays.asList("127.0.0.1", "localhost");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final char[] LOOKUP_HEX_ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error("\u52a0\u8f7d\u7c7b({})\u5931\u8d25", (Object)className, (Object)e);
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            if (ctxClassLoader != null) {
                try {
                    clazz = ctxClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException e2) {
                    logger.error("\u52a0\u8f7d\u7c7b({})\u5931\u8d25", (Object)className, (Object)e2);
                }
            }
            return clazz;
        }
    }

    /*
     * Exception decompiling
     */
    public static ByteArrayOutputStream clobToByteArrayOutputStream(Clob clob) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ByteArrayOutputStream blobToByteArrayOutputStream(Blob blob) throws IOException, SQLException {
        try (InputStream inputStream = blob.getBinaryStream();){
            ByteArrayOutputStream byteArrayOutputStream;
            try (ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();){
                byte[] buffer = new byte[1024];
                if (inputStream != null) {
                    int bytesRead;
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        byteArrayOutputStream2.write(buffer, 0, bytesRead);
                    }
                }
                byteArrayOutputStream = byteArrayOutputStream2;
            }
            return byteArrayOutputStream;
        }
    }

    public static String byteArrayOutputStreamToBase64(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.getEncoder().encodeToString(byteArray);
    }

    public static byte[] base64ToByteArray(String base64String) {
        return Base64.getDecoder().decode(base64String);
    }

    public static Clob base64ToClob(String base64String) throws SQLException {
        String decodedString = new String(Utils.base64ToByteArray(base64String));
        return new SerialClob(decodedString.toCharArray());
    }

    public static Blob base64ToBlob(String base64String) throws SQLException {
        return new SerialBlob(Utils.base64ToByteArray(base64String));
    }

    public static boolean isDDL(String sqlStatement) {
        String ddlStatement = sqlStatement.trim().toUpperCase();
        return ddlStatement.startsWith("CREATE") || ddlStatement.startsWith("ALTER") || ddlStatement.startsWith("DROP") || ddlStatement.startsWith("TRUNCATE") || ddlStatement.startsWith("RENAME") || ddlStatement.startsWith("COMMENT ON");
    }

    public static void parseExcludeFile(String path) {
        path = String.format(path + "%s", "");
        File directory = new File(path);
        if (logger.isInfoEnabled()) {
            logger.info("\u8bfb\u53d6\u76ee\u5f55: {}", (Object)path);
        }
        if (directory.exists() && directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                if (!file.isFile()) continue;
                try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                    String lineContent;
                    if (reader == null) continue;
                    while ((lineContent = reader.readLine()) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("=======line is:{}======", (Object)lineContent);
                        }
                        Transformer.initTableMetas(lineContent);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    String msg = ErrorMessages.format(ErrorMessages.LTU0014, file.toPath());
                    logger.error(msg, (Throwable)e);
                }
            }
        }
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, List<String>> getLocalAddressMap() throws SocketException {
        HashMap<String, List<String>> localAddressMap = new HashMap<String, List<String>>();
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> addressList = ni.getInetAddresses();
            ArrayList<String> address = new ArrayList<String>();
            while (addressList.hasMoreElements()) {
                InetAddress inetAddress = addressList.nextElement();
                address.add(inetAddress.getHostAddress());
            }
            localAddressMap.put(ni.getDisplayName(), address);
        }
        return localAddressMap;
    }

    /*
     * Unable to fully structure code
     */
    public static String getFirstAvailableIp() {
        addressMap = null;
        try {
            addressMap = Utils.getLocalAddressMap();
        }
        catch (SocketException e) {
            return null;
        }
        var1 = addressMap.entrySet().iterator();
        block2: while (true) {
            if (!var1.hasNext()) {
                return null;
            }
            address = var1.next();
            if ("lo".equals(address.getKey())) continue;
            addressList = address.getValue();
            var4 = addressList.iterator();
            do {
                if (var4.hasNext()) ** break;
                continue block2;
            } while (!Utils.verifyIpv4(addr = var4.next()));
            break;
        }
        return addr;
    }

    public static boolean verifyIpv4(String ip) {
        Matcher matcher = IPV4_PATTERN.matcher(ip);
        return matcher.find() && !loopback.contains(ip);
    }

    public static String encodeHex(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        char[] encodedData = new char[lengthEncode];
        for (int i = 0; i < lengthData; ++i) {
            int temp = binaryData[i];
            if (temp < 0) {
                temp += 256;
            }
            encodedData[i * 2] = LOOKUP_HEX_ALPHABET[temp >> 4];
            encodedData[i * 2 + 1] = LOOKUP_HEX_ALPHABET[temp & 0xF];
        }
        return new String(encodedData);
    }

    public static boolean isPlsqlBlock(String sql) {
        String trimmedSQL = sql.trim();
        String plsqlRegex = "(?is)^(declare|begin|create\\s+(or\\s+replace\\s+)?((editionable|noneditionable)\\s+)?(type|procedure|package|function|trigger))\\s.*";
        Pattern pattern = Pattern.compile(plsqlRegex);
        return pattern.matcher(trimmedSQL).matches();
    }
}

