/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.expression.StringValue;
import shaded.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import shaded.net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.schema.Column;
import shaded.net.sf.jsqlparser.statement.insert.Insert;
import shaded.net.sf.jsqlparser.statement.select.Values;

public class SqlParserExtractor {
    private static final Logger log = LoggerFactory.getLogger(SqlParserExtractor.class);

    public static ExtractResult extractConstValues(String insertSql) {
        try {
            Insert insert = (Insert)CCJSqlParserUtil.parse(insertSql);
            ExpressionList<Column> columnNamesExprList = insert.getColumns();
            ArrayList<String> columns = new ArrayList<String>();
            if (columnNamesExprList == null || columnNamesExprList.isEmpty()) {
                return null;
            }
            for (Column columnNamesExpr : columnNamesExprList) {
                columns.add(columnNamesExpr.getColumnName());
            }
            ArrayList<List<String>> valueGroups = new ArrayList<List<String>>();
            if (insert.getSelect() instanceof Values) {
                ExpressionList<?> exprList = ((Values)insert.getSelect()).getExpressions();
                if (exprList instanceof ParenthesedExpressionList) {
                    ParenthesedExpressionList expressionList = (ParenthesedExpressionList)exprList;
                    valueGroups.add(SqlParserExtractor.extractConstSingleGroup(expressionList));
                } else {
                    for (Expression expr : exprList) {
                        if (!(expr instanceof ParenthesedExpressionList)) continue;
                        ParenthesedExpressionList expressionList = (ParenthesedExpressionList)expr;
                        valueGroups.add(SqlParserExtractor.extractConstSingleGroup(expressionList));
                    }
                }
            }
            return new ExtractResult(columns, valueGroups);
        }
        catch (Exception e) {
            log.warn("SQL\u89e3\u6790\u5931\u8d25: {}", (Object)insertSql, (Object)e);
            return null;
        }
    }

    private static List<String> extractConstSingleGroup(ExpressionList<Expression> exprList) {
        ArrayList<String> values = new ArrayList<String>();
        for (Expression expr : exprList) {
            String value = null;
            value = expr instanceof StringValue ? ((StringValue)expr).getNotExcapedValue() : null;
            values.add(value);
        }
        return values;
    }

    public static class ExtractResult {
        private final List<String> columnNames;
        private final List<List<String>> valueGroups;

        public ExtractResult(List<String> columnNames, List<List<String>> valueGroups) {
            this.columnNames = columnNames;
            this.valueGroups = valueGroups;
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        public List<List<String>> getValueGroups() {
            return this.valueGroups;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\u5217\u540d\uff1a").append(this.columnNames).append("\n");
            sb.append("\u503c\u7ec4\u6570\u91cf\uff1a").append(this.valueGroups.size()).append("\n");
            for (int i = 0; i < this.valueGroups.size(); ++i) {
                sb.append("\u7b2c").append(i + 1).append("\u7ec4\u503c\uff1a").append(this.valueGroups.get(i)).append("\n");
            }
            return sb.toString();
        }
    }
}

