/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.multijdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlStatement;
import com.hundsun.lightdb.unisql.proxy.multijdbc.MultiConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class MultiStatement
implements Statement {
    private static Logger log = LoggerFactory.getLogger(MultiConnection.class);
    private Connection nativeConnection;
    private final Statement delegate;
    private final List<UnisqlStatement> delegateMulti;
    private final Set<DbType> multiDbTypes;
    private final ConnectionInfoDTO dataBaseInfo;
    private final UnisqlProperties properties = UnisqlProperties.getInstance();
    protected final boolean debug = this.properties.isDebug();
    private DbType sourceDbType;
    private String sourceDbName;

    public MultiStatement(Connection nativeConnection, Statement delegate, List<UnisqlStatement> delegateMulti, DbType sourceDbType, String sourceDbName, Set<DbType> multiDbTypes, ConnectionInfoDTO dataBaseInfo) {
        this.nativeConnection = nativeConnection;
        this.delegate = delegate;
        this.delegateMulti = delegateMulti;
        this.sourceDbType = sourceDbType;
        this.sourceDbName = sourceDbName;
        this.multiDbTypes = multiDbTypes;
        this.dataBaseInfo = dataBaseInfo;
    }

    public Statement getDelegate() {
        return this.delegate;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.close();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getMaxFieldSize();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setMaxFieldSize(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getMaxRows();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setMaxRows(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setEscapeProcessing(enable);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getQueryTimeout();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setQueryTimeout(seconds);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.cancel();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getWarnings();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.clearWarnings();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setCursorName(name);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String traceId = MultiplexContext.setRealMultiplexTraceId();
        MultiQueryResultDTO multiQueryResult = MultiplexContext.createMultiQueryResult(traceId, this.sourceDbType, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
        multiQueryResult.setBizSql(sql);
        multiQueryResult.setTransformedBizSql(sql);
        multiQueryResult.setRawBizBindVarReplacedSql(sql);
        multiQueryResult.setBizBindVarReplacedSql(sql);
        return MultiplexContext.executeMultiplex(this.nativeConnection, this.delegate, this.delegateMulti, multiQueryResult);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getResultSet();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getUpdateCount();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getMoreResults();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setFetchDirection(direction);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getFetchDirection();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setFetchSize(rows);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getFetchSize();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getResultSetConcurrency();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getResultSetType();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.addBatch(sql);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.clearBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        int[] executeBatch = this.delegate.executeBatch();
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return executeBatch;
    }

    @Override
    public Connection getConnection() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getConnection();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getMoreResults(current);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getGeneratedKeys();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeUpdate(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        int update = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return update;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeUpdate(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        int executeUpdate = this.delegate.executeUpdate(sql, columnIndexes);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return executeUpdate;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeUpdate(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        int executeUpdate = this.delegate.executeUpdate(sql, columnNames);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return executeUpdate;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.execute(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        boolean execute = this.delegate.execute(sql, autoGeneratedKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return execute;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.execute(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        boolean execute = this.delegate.execute(sql, columnIndexes);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return execute;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.execute(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        boolean execute = this.delegate.execute(sql, columnNames);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return execute;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getResultSetHoldability();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.isClosed();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setPoolable(poolable);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.isPoolable();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.closeOnCompletion();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.isCloseOnCompletion();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getLargeUpdateCount();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.setLargeMaxRows(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.getLargeMaxRows();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeLargeBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        long[] largeBatch = this.delegate.executeLargeBatch();
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeBatch;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeLargeUpdate(sql);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeLargeUpdate(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeLargeUpdate(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql, columnIndexes);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (Statement statement : this.delegateMulti) {
            try {
                statement.executeLargeUpdate(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql, columnNames);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.unwrap(iface);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        for (Statement statement : this.delegateMulti) {
            try {
                statement.isWrapperFor(iface);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isWrapperFor(iface);
    }
}

