/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.alibaba.fastjson2.annotation.JSONField;
import com.hundsun.lightdb.unisql.constant.CompareKindEnum;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.MultiQueryResultSetDTO;
import com.hundsun.lightdb.unisql.utils.SqlInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class MultiQueryResultDTO {
    private static final Pattern FILEPATH_SANITIZE_PATTERN = Pattern.compile("[^a-zA-Z0-9-_\\.]");
    private Integer id;
    private String traceId;
    private Boolean realMultiplex;
    private String bizSql;
    private String transformedBizSql;
    private String rawBizBindVarReplacedSql;
    private String bizBindVarReplacedSql;
    private Integer bizSqlSequence;
    private String bizSqlOperationType;
    private String sourceDialect;
    private String targetDialect;
    private Boolean sourceMessage;
    private String multiQuerySql;
    private String compareKind;
    private Integer multiQueryRowCount = 0;
    private Integer bizSqlAffectedRows = 0;
    private MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
    private ConnectionInfoDTO syncConnectionInfo;
    private String appName;
    private String appType;
    private String username;
    private String schemaName;
    private String functionId;
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date bizSqlExecutionTime;
    private String bizSqlParameters;
    private String messageType;
    private String errorReason;
    private String multiAppHostIp;
    private Set<String> multiTargetDialects;
    private String tenantName;
    private String transactionTag;
    private String bizSqlTableName;
    private String state;
    private String url;
    private volatile Boolean compareReportGenerated;
    private volatile Boolean aggregatedReportGenerated;
    private static Set<String> SYS_TABLES = new HashSet<String>();

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public static MultiQueryResultDTO createForTraceId(String traceId) {
        MultiQueryResultDTO resultDTO = new MultiQueryResultDTO();
        resultDTO.setTraceId(traceId);
        return resultDTO;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Boolean getRealMultiplex() {
        return this.realMultiplex;
    }

    public void setRealMultiplex(Boolean realMultiplex) {
        this.realMultiplex = realMultiplex;
    }

    public String getBizSql() {
        return this.bizSql;
    }

    public void setBizSql(String bizSql) {
        this.bizSql = bizSql;
    }

    public String getTransformedBizSql() {
        return this.transformedBizSql;
    }

    public void setTransformedBizSql(String transformedBizSql) {
        this.transformedBizSql = transformedBizSql;
    }

    public Integer getBizSqlSequence() {
        return this.bizSqlSequence;
    }

    public void setBizSqlSequence(Integer bizSqlSequence) {
        this.bizSqlSequence = bizSqlSequence;
    }

    public String getBizSqlOperationType() {
        return this.bizSqlOperationType;
    }

    public void setBizSqlOperationType(String bizSqlOperationType) {
        this.bizSqlOperationType = bizSqlOperationType;
    }

    public String getSourceDialect() {
        return this.sourceDialect;
    }

    public void setSourceDialect(String sourceDialect) {
        this.sourceDialect = sourceDialect;
    }

    public String getTargetDialect() {
        return this.targetDialect;
    }

    public void setTargetDialect(String targetDialect) {
        this.targetDialect = targetDialect;
    }

    public String getMultiQuerySql() {
        return this.multiQuerySql;
    }

    public void setMultiQuerySql(String multiQuerySql) {
        this.multiQuerySql = multiQuerySql;
    }

    public String getCompareKind() {
        return this.compareKind;
    }

    public void setCompareKind(String compareKind) {
        this.compareKind = compareKind;
    }

    public Integer getMultiQueryRowCount() {
        return this.multiQueryRowCount;
    }

    public void setMultiQueryRowCount(Integer multiQueryRowCount) {
        this.multiQueryRowCount = multiQueryRowCount;
    }

    public Integer getBizSqlAffectedRows() {
        return this.bizSqlAffectedRows;
    }

    public void setBizSqlAffectedRows(Integer bizSqlAffectedRows) {
        this.bizSqlAffectedRows = bizSqlAffectedRows;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public Date getBizSqlExecutionTime() {
        return this.bizSqlExecutionTime;
    }

    public void setBizSqlExecutionTime(Date bizSqlExecutionTime) {
        this.bizSqlExecutionTime = bizSqlExecutionTime;
    }

    public String getBizSqlParameters() {
        return this.bizSqlParameters;
    }

    public void setBizSqlParameters(String bizSqlParameters) {
        this.bizSqlParameters = bizSqlParameters;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void addErrorReason(String errorReason) {
        this.errorReason = StringUtils.isNotBlank(this.errorReason) ? this.errorReason + "\r\n\u989d\u5916\u7684\u5f02\u5e38\u4fe1\u606f\uff1a" + errorReason : errorReason;
    }

    public String getMultiAppHostIp() {
        return this.multiAppHostIp;
    }

    public void setMultiAppHostIp(String multiAppHostIp) {
        this.multiAppHostIp = multiAppHostIp;
    }

    public Set<String> getMultiTargetDialects() {
        return this.multiTargetDialects;
    }

    public void setMultiTargetDialects(Set<String> multiTargetDialects) {
        this.multiTargetDialects = multiTargetDialects;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTransactionTag() {
        return this.transactionTag;
    }

    public void setTransactionTag(String transactionTag) {
        this.transactionTag = transactionTag;
    }

    public String getBizSqlTableName() {
        return this.bizSqlTableName;
    }

    public void setBizSqlTableName(String bizSqlTableName) {
        if (StringUtils.length(bizSqlTableName) > 2 && bizSqlTableName.charAt(0) == '\"' && bizSqlTableName.charAt(bizSqlTableName.length() - 1) == '\"') {
            bizSqlTableName = bizSqlTableName.substring(1, bizSqlTableName.length() - 1);
        }
        this.bizSqlTableName = bizSqlTableName = MultiQueryResultDTO.sortTableNames(bizSqlTableName);
    }

    public static String sortTableNames(String bizSqlTableName) {
        if (StringUtils.isNotBlank(bizSqlTableName) && bizSqlTableName.indexOf(",") > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String singleTable : bizSqlTableName.split(",")) {
                treeSet.add(singleTable);
            }
            bizSqlTableName = String.join((CharSequence)",", treeSet);
        }
        return bizSqlTableName;
    }

    public String getBizBindVarReplacedSql() {
        return this.bizBindVarReplacedSql;
    }

    public void setBizBindVarReplacedSql(String bizBindVarReplacedSql) {
        this.bizBindVarReplacedSql = bizBindVarReplacedSql;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "MultiQueryResultDTO{traceId='" + this.traceId + '\'' + ", realMultiplex=" + this.realMultiplex + ", bizSql='" + this.bizSql + '\'' + ", transformedBizSql='" + this.transformedBizSql + '\'' + ", bizSqlSequence=" + this.bizSqlSequence + ", bizSqlOperationType='" + this.bizSqlOperationType + '\'' + ", sourceDialect='" + this.sourceDialect + '\'' + ", targetDialect='" + this.targetDialect + '\'' + ", multiQuerySql='" + this.multiQuerySql + '\'' + ", compareKind='" + this.compareKind + '\'' + ", multiQueryRowCount=" + this.multiQueryRowCount + ", bizSqlAffectedRows=" + this.bizSqlAffectedRows + ", multiQueryResultSet=" + this.multiQueryResultSet + ", syncConnectionInfo=" + this.syncConnectionInfo + ", appName='" + this.appName + '\'' + ", appType='" + this.appType + '\'' + ", username='" + this.username + '\'' + ", schemaName='" + this.schemaName + '\'' + ", functionId='" + this.functionId + '\'' + ", bizSqlExecutionTime=" + this.bizSqlExecutionTime + ", bizSqlParameters='" + this.bizSqlParameters + '\'' + ", messageType='" + this.messageType + '\'' + ", errorReason='" + this.errorReason + '\'' + ", multiAppHostIp='" + this.multiAppHostIp + '\'' + ", multiDbTypes=" + this.multiTargetDialects + ", tenantName='" + this.tenantName + '\'' + ", transactionTag='" + this.transactionTag + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public void unescapeHtml4() {
        this.bizSql = StringEscapeUtils.unescapeHtml4(this.bizSql);
        this.multiQuerySql = StringEscapeUtils.unescapeHtml4(this.multiQuerySql);
        this.transformedBizSql = StringEscapeUtils.unescapeHtml4(this.transformedBizSql);
        this.bizBindVarReplacedSql = StringEscapeUtils.unescapeHtml4(this.bizBindVarReplacedSql);
        this.multiQuerySql = StringEscapeUtils.unescapeHtml4(this.multiQuerySql);
        this.errorReason = StringEscapeUtils.unescapeHtml4(this.errorReason);
        if (Objects.nonNull(this.getSyncConnectionInfo())) {
            ConnectionInfoDTO connectionInfo = this.getSyncConnectionInfo();
            connectionInfo.setUrl(StringEscapeUtils.unescapeHtml4(connectionInfo.getUrl()));
        }
    }

    public String buildCacheKey() {
        return String.format("%s:%s:%s:%s:%d", this.traceId, this.appName, this.sourceDialect, this.compareKind, this.bizSqlSequence);
    }

    public String buildSpillFileName() {
        String rawFileName = String.format("%s_%s_%s_%s_%d_%s_%s", this.traceId, this.appName, this.sourceDialect, this.compareKind, this.bizSqlSequence, this.targetDialect, this.schemaName);
        return FILEPATH_SANITIZE_PATTERN.matcher(rawFileName).replaceAll("_");
    }

    public String groupByAppNameCompareKindSqlSequence() {
        return String.join((CharSequence)":", this.traceId, this.appName, this.compareKind, String.valueOf(this.bizSqlSequence));
    }

    public boolean isSourceMessage() {
        return Objects.equals(this.sourceDialect, this.targetDialect);
    }

    public Boolean needGenerateAggregatedReport() {
        return !Boolean.TRUE.equals(this.aggregatedReportGenerated) && !CompareKindEnum.isBeforeQuery(this.compareKind);
    }

    public void setAggregatedReportGenerated(Boolean aggregatedReportGenerated) {
        this.aggregatedReportGenerated = aggregatedReportGenerated;
    }

    public boolean isCompareReportGenerated() {
        return Boolean.TRUE.equals(this.compareReportGenerated);
    }

    public void setCompareReportGenerated(boolean compareReportGenerated) {
        this.compareReportGenerated = compareReportGenerated;
    }

    public String getRawBizBindVarReplacedSql() {
        return this.rawBizBindVarReplacedSql;
    }

    public void setRawBizBindVarReplacedSql(String rawBizBindVarReplacedSql) {
        this.rawBizBindVarReplacedSql = rawBizBindVarReplacedSql;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public MultiQueryResultSetDTO getMultiQueryResultSet() {
        return this.multiQueryResultSet;
    }

    public void setMultiQueryResultSet(MultiQueryResultSetDTO multiQueryResultSet) {
        this.multiQueryResultSet = multiQueryResultSet;
    }

    public ConnectionInfoDTO getSyncConnectionInfo() {
        return this.syncConnectionInfo;
    }

    public void setSyncConnectionInfo(ConnectionInfoDTO syncConnectionInfo) {
        this.syncConnectionInfo = syncConnectionInfo;
    }

    public boolean hasValidConnectionInfo() {
        return Objects.nonNull(this.syncConnectionInfo) && StringUtils.isNotBlank(this.syncConnectionInfo.getUrl()) && StringUtils.isNotBlank(this.syncConnectionInfo.getUsername()) && StringUtils.isNotBlank(this.syncConnectionInfo.getPassword());
    }

    public boolean hasColumnNames() {
        return Objects.nonNull(this.multiQueryResultSet) && CollectionUtils.isNotEmpty(this.multiQueryResultSet.getColumnNames());
    }

    public void resetForAfterQuery(SqlInfo sqlInfo) {
        this.setState(null);
        this.setErrorReason(null);
        this.setCompareKind(CompareKindEnum.AFTER_QUERY.name());
        this.setBizSqlExecutionTime(new Date());
        this.setMultiQuerySql(sqlInfo.getAfterSql());
        this.setMultiQueryResultSet(new MultiQueryResultSetDTO());
        this.setMultiQueryRowCount(null);
    }

    public static MultiQueryResultDTO deepCopyFrom(MultiQueryResultDTO src) {
        Object d;
        Object s;
        if (src == null) {
            return null;
        }
        MultiQueryResultDTO dst = new MultiQueryResultDTO();
        dst.setId(src.getId());
        dst.setTraceId(src.getTraceId());
        dst.setRealMultiplex(src.getRealMultiplex());
        dst.setBizSql(src.getBizSql());
        dst.setTransformedBizSql(src.getTransformedBizSql());
        dst.setRawBizBindVarReplacedSql(src.getRawBizBindVarReplacedSql());
        dst.setBizBindVarReplacedSql(src.getBizBindVarReplacedSql());
        dst.setBizSqlSequence(src.getBizSqlSequence());
        dst.setBizSqlOperationType(src.getBizSqlOperationType());
        dst.setSourceDialect(src.getSourceDialect());
        dst.setTargetDialect(src.getTargetDialect());
        dst.setMultiQuerySql(src.getMultiQuerySql());
        dst.setCompareKind(src.getCompareKind());
        dst.setMultiQueryRowCount(src.getMultiQueryRowCount());
        dst.setBizSqlAffectedRows(src.getBizSqlAffectedRows());
        if (src.getMultiQueryResultSet() != null) {
            s = src.getMultiQueryResultSet();
            d = new MultiQueryResultSetDTO();
            ((MultiQueryResultSetDTO)d).setBizSqlTableName(((MultiQueryResultSetDTO)s).getBizSqlTableName());
            if (((MultiQueryResultSetDTO)s).getColumnNames() != null) {
                ((MultiQueryResultSetDTO)d).setColumnNames(new ArrayList<String>(((MultiQueryResultSetDTO)s).getColumnNames()));
            }
            if (((MultiQueryResultSetDTO)s).getColumnDataTypes() != null) {
                ((MultiQueryResultSetDTO)d).setColumnDataTypes(new ArrayList<Integer>(((MultiQueryResultSetDTO)s).getColumnDataTypes()));
            }
            if (((MultiQueryResultSetDTO)s).getDataRows() != null) {
                ((MultiQueryResultSetDTO)d).setDataRows(new ArrayList<List<Object>>(((MultiQueryResultSetDTO)s).getDataRows()));
            }
            dst.setMultiQueryResultSet((MultiQueryResultSetDTO)d);
        }
        if (src.getSyncConnectionInfo() != null) {
            s = src.getSyncConnectionInfo();
            d = new ConnectionInfoDTO();
            ((ConnectionInfoDTO)d).setUrl(((ConnectionInfoDTO)s).getUrl());
            ((ConnectionInfoDTO)d).setUsername(((ConnectionInfoDTO)s).getUsername());
            ((ConnectionInfoDTO)d).setPassword(((ConnectionInfoDTO)s).getPassword());
            dst.setSyncConnectionInfo((ConnectionInfoDTO)d);
        }
        dst.setAppName(src.getAppName());
        dst.setAppType(src.getAppType());
        dst.setUsername(src.getUsername());
        dst.setSchemaName(src.getSchemaName());
        dst.setFunctionId(src.getFunctionId());
        dst.setBizSqlExecutionTime(src.getBizSqlExecutionTime());
        dst.setBizSqlParameters(src.getBizSqlParameters());
        dst.setMessageType(src.getMessageType());
        dst.setErrorReason(src.getErrorReason());
        dst.setMultiAppHostIp(src.getMultiAppHostIp());
        if (src.getMultiTargetDialects() != null) {
            dst.setMultiTargetDialects(new HashSet<String>(src.getMultiTargetDialects()));
        }
        dst.setTenantName(src.getTenantName());
        dst.setTransactionTag(src.getTransactionTag());
        dst.setBizSqlTableName(src.getBizSqlTableName());
        dst.setState(src.getState());
        dst.setAggregatedReportGenerated(src.needGenerateAggregatedReport());
        dst.setCompareReportGenerated(src.isCompareReportGenerated());
        dst.setUrl(src.getUrl());
        return dst;
    }

    public boolean bestMatch(MultiQueryResultDTO target) {
        String bizSqlTableName = target.getBizSqlTableName();
        String appName = target.getAppName();
        String compareKind = target.getCompareKind();
        String sourceDialect = target.getSourceDialect();
        String tenantName = target.getTenantName();
        String username = target.getUsername();
        String targetDialect = target.getTargetDialect();
        return this.matchTableName(bizSqlTableName.replace("\"", ""), this.bizSqlTableName.replace("\"", "")) && Objects.equals(appName, this.appName) && Objects.equals(compareKind, this.compareKind) && Objects.equals(sourceDialect, this.sourceDialect) && Objects.equals(tenantName, this.tenantName) && Objects.equals(username, this.username) && !Objects.equals(targetDialect, this.targetDialect);
    }

    private boolean matchTableName(String firstTableName, String secondTableName) {
        if (StringUtils.isBlank(firstTableName) || StringUtils.isBlank(secondTableName)) {
            return Objects.equals(firstTableName, secondTableName);
        }
        if (firstTableName.indexOf(",") == -1 && secondTableName.indexOf(",") == -1) {
            return Objects.equals(firstTableName, secondTableName);
        }
        List first = Arrays.stream(firstTableName.split(",")).sorted().distinct().filter(this::removeSysTable).collect(Collectors.toList());
        List second = Arrays.stream(secondTableName.split(",")).sorted().distinct().filter(this::removeSysTable).collect(Collectors.toList());
        return Objects.equals(String.join((CharSequence)",", first), String.join((CharSequence)",", second));
    }

    private boolean removeSysTable(String tableName) {
        return !SYS_TABLES.contains(tableName);
    }

    static {
        SYS_TABLES.add("dual");
        SYS_TABLES.add("sys_dummy");
    }
}

