/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.util.Arrays;

final class JSONWriterUTF8JDK9
extends JSONWriterUTF8 {
    JSONWriterUTF8JDK9(JSONWriter.Context ctx) {
        super(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeString(String str) {
        boolean escapeNoneAscii;
        if (!JDKUtils.UNSAFE_SUPPORT || JDKUtils.JVM_VERSION == 8) {
            super.writeString(str);
            return;
        }
        if (str == null) {
            if (this.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                this.writeString("");
                return;
            }
            this.writeNull();
            return;
        }
        byte coder = UnsafeUtils.getStringCoder(str);
        byte[] value = UnsafeUtils.getStringValue(str);
        if (coder != 0) {
            escapeNoneAscii = (this.context.features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
            int minCapacity = this.off + value.length * 4 + 2;
            if (escapeNoneAscii) {
                minCapacity += value.length * 2;
            }
            if (minCapacity - this.bytes.length > 0) {
                int oldCapacity = this.bytes.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.bytes = Arrays.copyOf(this.bytes, newCapacity);
            }
        } else {
            int minCapacity;
            byte c3;
            byte c2;
            byte c1;
            byte c0;
            boolean escape = false;
            int valueOffset = 0;
            while (valueOffset + 8 <= value.length) {
                c0 = value[valueOffset];
                c1 = value[valueOffset + 1];
                c2 = value[valueOffset + 2];
                c3 = value[valueOffset + 3];
                byte c4 = value[valueOffset + 4];
                byte c5 = value[valueOffset + 5];
                byte c6 = value[valueOffset + 6];
                byte c7 = value[valueOffset + 7];
                if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c4 == this.quote || c5 == this.quote || c6 == this.quote || c7 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c4 == 92 || c5 == 92 || c6 == 92 || c7 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32 || c4 < 32 || c5 < 32 || c6 < 32 || c7 < 32) {
                    escape = true;
                    break;
                }
                valueOffset += 8;
            }
            if (!escape) {
                while (valueOffset + 4 <= value.length) {
                    c0 = value[valueOffset];
                    c1 = value[valueOffset + 1];
                    c2 = value[valueOffset + 2];
                    c3 = value[valueOffset + 3];
                    if (c0 == this.quote || c1 == this.quote || c2 == this.quote || c3 == this.quote || c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c0 < 32 || c1 < 32 || c2 < 32 || c3 < 32) {
                        escape = true;
                        break;
                    }
                    valueOffset += 4;
                }
            }
            if (!escape && valueOffset + 2 <= value.length) {
                c0 = value[valueOffset];
                c1 = value[valueOffset + 1];
                if (c0 == this.quote || c1 == this.quote || c0 == 92 || c1 == 92 || c0 < 32 || c1 < 32) {
                    escape = true;
                } else {
                    valueOffset += 2;
                }
            }
            if (!escape && valueOffset + 1 == value.length) {
                c0 = value[valueOffset];
                escape = c0 == this.quote || c0 == 92 || c0 < 32;
            }
            if ((minCapacity = this.off + (escape ? value.length * 4 : value.length) + 2) - this.bytes.length > 0) {
                int oldCapacity = this.bytes.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity - minCapacity < 0) {
                    newCapacity = minCapacity;
                }
                if (newCapacity - MAX_ARRAY_SIZE > 0) {
                    throw new OutOfMemoryError();
                }
                this.bytes = Arrays.copyOf(this.bytes, newCapacity);
            }
            this.bytes[this.off++] = (byte)this.quote;
            if (!escape) {
                System.arraycopy(value, 0, this.bytes, this.off, value.length);
                this.off += value.length;
            } else {
                block26: for (int i = 0; i < value.length; ++i) {
                    byte ch = value[i];
                    switch (ch) {
                        case 92: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 92;
                            continue block26;
                        }
                        case 10: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 110;
                            continue block26;
                        }
                        case 13: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 114;
                            continue block26;
                        }
                        case 12: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 102;
                            continue block26;
                        }
                        case 8: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 98;
                            continue block26;
                        }
                        case 9: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 116;
                            continue block26;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = (byte)(48 + ch);
                            continue block26;
                        }
                        case 11: 
                        case 14: 
                        case 15: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = (byte)(97 + (ch - 10));
                            continue block26;
                        }
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 49;
                            this.bytes[this.off++] = (byte)(48 + (ch - 16));
                            continue block26;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 48;
                            this.bytes[this.off++] = 49;
                            this.bytes[this.off++] = (byte)(97 + (ch - 26));
                            continue block26;
                        }
                        default: {
                            if (ch == this.quote) {
                                this.bytes[this.off++] = 92;
                                this.bytes[this.off++] = (byte)this.quote;
                                continue block26;
                            }
                            if (coder == 0 && ch < 0) {
                                int c = ch & 0xFF;
                                this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                                this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                                continue block26;
                            }
                            this.bytes[this.off++] = ch;
                        }
                    }
                }
            }
            this.bytes[this.off++] = (byte)this.quote;
            return;
        }
        this.bytes[this.off++] = (byte)this.quote;
        int valueOffset = 0;
        block27: while (true) {
            int c;
            block63: {
                int uc;
                block62: {
                    block64: {
                        byte b1;
                        if (valueOffset >= value.length) {
                            this.bytes[this.off++] = (byte)this.quote;
                            return;
                        }
                        byte b0 = value[valueOffset++];
                        if ((b1 = value[valueOffset++]) == 0 && b0 >= 0) {
                            byte ch = b0;
                            switch (ch) {
                                case 92: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 92;
                                    continue block27;
                                }
                                case 10: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 110;
                                    continue block27;
                                }
                                case 13: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 114;
                                    continue block27;
                                }
                                case 12: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 102;
                                    continue block27;
                                }
                                case 8: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 98;
                                    continue block27;
                                }
                                case 9: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 116;
                                    continue block27;
                                }
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = (byte)(48 + ch);
                                    continue block27;
                                }
                                case 11: 
                                case 14: 
                                case 15: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = (byte)(97 + (ch - 10));
                                    continue block27;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 49;
                                    this.bytes[this.off++] = (byte)(48 + (ch - 16));
                                    continue block27;
                                }
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: {
                                    this.bytes[this.off++] = 92;
                                    this.bytes[this.off++] = 117;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 48;
                                    this.bytes[this.off++] = 49;
                                    this.bytes[this.off++] = (byte)(97 + (ch - 26));
                                    continue block27;
                                }
                            }
                            if (ch == this.quote) {
                                this.bytes[this.off++] = 92;
                                this.bytes[this.off++] = (byte)this.quote;
                                continue;
                            }
                            this.bytes[this.off++] = ch;
                            continue;
                        }
                        c = (b0 & 0xFF) << 0 | (b1 & 0xFF) << 8;
                        if (c < 2048) {
                            this.bytes[this.off++] = (byte)(0xC0 | c >> 6);
                            this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
                            continue;
                        }
                        if (escapeNoneAscii) {
                            this.bytes[this.off++] = 92;
                            this.bytes[this.off++] = 117;
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 12 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 8 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c >>> 4 & 0xF];
                            this.bytes[this.off++] = (byte)DIGITS[c & 0xF];
                            continue;
                        }
                        if (c < 55296 || c >= 57344) break block63;
                        int ip = valueOffset - 1;
                        if (c < 55296 || c >= 56320) break block64;
                        if (value.length - ip < 2) {
                            uc = -1;
                            break block62;
                        } else {
                            b0 = value[ip + 1];
                            b1 = value[ip + 2];
                            char d = (char)((b0 & 0xFF) << 0 | (b1 & 0xFF) << 8);
                            if (d >= '\udc00' && d < '\ue000') {
                                valueOffset += 2;
                                uc = (c << 10) + d + -56613888;
                                break block62;
                            } else {
                                this.bytes[this.off++] = 63;
                                continue;
                            }
                        }
                    }
                    if (c >= 56320 && c < 57344) {
                        this.bytes[this.off++] = 63;
                        continue;
                    }
                    uc = c;
                }
                if (uc < 0) {
                    this.bytes[this.off++] = 63;
                    continue;
                }
                this.bytes[this.off++] = (byte)(0xF0 | uc >> 18);
                this.bytes[this.off++] = (byte)(0x80 | uc >> 12 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | uc >> 6 & 0x3F);
                this.bytes[this.off++] = (byte)(0x80 | uc & 0x3F);
                continue;
            }
            this.bytes[this.off++] = (byte)(0xE0 | c >> 12);
            this.bytes[this.off++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.bytes[this.off++] = (byte)(0x80 | c & 0x3F);
        }
    }
}

