/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterJSONB;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JSONBDump;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.List;

public interface JSONB {
    public static byte[] toBytes(boolean v) {
        return new byte[]{v ? (byte)-79 : -80};
    }

    public static byte[] toBytes(int i) {
        if (i >= -16 && i <= 47) {
            return new byte[]{(byte)i};
        }
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt32(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(long i) {
        if (i >= -8L && i <= 15L) {
            return new byte[]{(byte)(-40L + (i - -8L))};
        }
        try (JSONWriter jsonWriter = JSONWriter.ofJSONB();){
            jsonWriter.writeInt64(i);
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    public static int writeInt(byte[] bytes, int off, int i) {
        if (i >= -16 && i <= 47) {
            bytes[off++] = (byte)i;
            return 1;
        }
        if (i >= -2048 && i <= 2047) {
            bytes[off++] = (byte)(56 + (i >> 8));
            bytes[off++] = (byte)i;
            return 2;
        }
        if (i >= -262144 && i <= 262143) {
            bytes[off++] = (byte)(68 + (i >> 16));
            bytes[off++] = (byte)(i >> 8);
            bytes[off++] = (byte)i;
            return 3;
        }
        bytes[off++] = 72;
        bytes[off++] = (byte)(i >>> 24);
        bytes[off++] = (byte)(i >>> 16);
        bytes[off++] = (byte)(i >>> 8);
        bytes[off++] = (byte)i;
        return 5;
    }

    public static Object parse(byte[] jsonbBytes, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, 0, jsonbBytes.length);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static JSONObject parseObject(byte[] jsonbBytes) {
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
        JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
        JSONObject object = (JSONObject)((JSONReader)reader).readObject();
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static JSONObject parseObject(byte[] jsonbBytes, JSONReader.Feature ... features) {
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
        context.config(features);
        JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
        JSONObject object = (JSONObject)((JSONReader)reader).readObject();
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static JSONArray parseArray(byte[] jsonbBytes) {
        JSONReader.Context context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider());
        JSONReaderJSONB reader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
        JSONArray array = (JSONArray)((JSONReader)reader).readArray();
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(array);
        }
        return array;
    }

    public static <T> List<T> parseArray(byte[] jsonbBytes, Type type, JSONReader.Feature ... features) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        try (JSONReader reader = JSONReader.ofJSONB(jsonbBytes, features);){
            reader.context.config(features);
            List list = (List)reader.read(paramType);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            if (objectClass == Object.class) {
                object = ((JSONReader)jsonReader).readAny();
            } else {
                ObjectReader objectReader = provider.getObjectReader(objectClass);
                object = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        JSONReaderJSONB jsonReader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);
        ObjectReader objectReader = provider.getObjectReader(objectType);
        Object object = objectReader.readJSONBObject(jsonReader, null, null, 0L);
        if (jsonReader.resolveTasks != null) {
            jsonReader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider, symbolTable);
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);
        ObjectReader objectReader = provider.getObjectReader(objectType);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider, symbolTable);
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);
        for (JSONReader.Feature feature : features) {
            ctx.features |= feature.mask;
        }
        boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectType, fieldBased);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass, Filter filter, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.config(filter, features);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            for (JSONReader.Feature feature : features) {
                context.features |= feature.mask;
            }
            if (objectClass == Object.class) {
                byte type = ((JSONReader)jsonReader).getType();
                if (type == -110) {
                    ObjectReader autoTypeObjectReader = ((JSONReader)jsonReader).checkAutoType(Object.class, 0L, 0L);
                    object = autoTypeObjectReader.readJSONBObject(jsonReader, null, null, context.features);
                } else {
                    object = ((JSONReader)jsonReader).readAny();
                }
            } else {
                boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
                object = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectType, SymbolTable symbolTable, Filter[] filters, JSONReader.Feature ... features) {
        if (jsonbBytes == null || jsonbBytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, symbolTable);
        context.config(filters, features);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            for (JSONReader.Feature feature : features) {
                context.features |= feature.mask;
            }
            if (objectType == Object.class) {
                byte type = ((JSONReader)jsonReader).getType();
                if (type == -110) {
                    ObjectReader autoTypeObjectReader = ((JSONReader)jsonReader).checkAutoType(Object.class, 0L, 0L);
                    object = autoTypeObjectReader.readJSONBObject(jsonReader, null, null, context.features);
                } else {
                    object = ((JSONReader)jsonReader).readAny();
                }
            } else {
                boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectType, fieldBased);
                object = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, TypeReference typeReference, JSONReader.Feature ... features) {
        return JSONB.parseObject(jsonbBytes, typeReference.getType(), features);
    }

    public static <T> T parseObject(byte[] jsonbBytes, Class<T> objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        try (JSONReaderJSONB jsonReader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);){
            Object object;
            for (JSONReader.Feature feature : features) {
                ctx.features |= feature.mask;
            }
            if (objectClass == Object.class) {
                byte type = ((JSONReader)jsonReader).getType();
                if (type == -110) {
                    ObjectReader autoTypeObjectReader = ((JSONReader)jsonReader).checkAutoType(Object.class, 0L, 0L);
                    object = autoTypeObjectReader.readJSONBObject(jsonReader, null, null, ctx.features);
                } else {
                    object = ((JSONReader)jsonReader).readAny();
                }
            } else {
                boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
                ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
                object = (ctx.features & JSONReader.Feature.SupportArrayToBean.mask) != 0L && ((JSONReader)jsonReader).isArray() ? objectReader.readArrayMappingJSONBObject(jsonReader, null, null, 0L) : objectReader.readJSONBObject(jsonReader, null, null, 0L);
            }
            if (jsonReader.resolveTasks != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static <T> T parseObject(byte[] jsonbBytes, Type objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, 0, jsonbBytes.length);
        for (JSONReader.Feature feature : features) {
            ctx.features |= feature.mask;
        }
        boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, off, len);
        boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectClass) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, off, len);
        boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context ctx = new JSONReader.Context(provider);
        for (JSONReader.Feature feature : features) {
            ctx.features |= feature.mask;
        }
        JSONReaderJSONB reader = new JSONReaderJSONB(ctx, jsonbBytes, off, len);
        boolean fieldBased = (ctx.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectType, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, off, len);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader(objectType);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, SymbolTable symbolTable) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, off, len, symbolTable);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectClass, SymbolTable symbolTable) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, off, len, symbolTable);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Class<T> objectClass, SymbolTable symbolTable, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, off, len, symbolTable);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static <T> T parseObject(byte[] jsonbBytes, int off, int len, Type objectClass, SymbolTable symbolTable, JSONReader.Feature ... features) {
        JSONReader reader = JSONReader.ofJSONB(jsonbBytes, off, len, symbolTable);
        reader.getContext().config(features);
        ObjectReader objectReader = reader.getObjectReader(objectClass);
        Object object = objectReader.readJSONBObject(reader, null, null, 0L);
        if (reader.resolveTasks != null) {
            reader.handleResolveTasks(object);
        }
        return object;
    }

    public static byte[] toBytes(String str) {
        byte[] value;
        int strlen;
        byte coder;
        if (str == null) {
            return new byte[]{-81};
        }
        if (JDKUtils.JVM_VERSION == 8) {
            char[] chars = JDKUtils.getCharArray(str);
            int strlen2 = chars.length;
            if (strlen2 <= 47) {
                boolean ascii = true;
                for (int i = 0; i < strlen2; ++i) {
                    if (chars[i] <= '\u007f') continue;
                    ascii = false;
                    break;
                }
                if (ascii) {
                    byte[] bytes = new byte[chars.length + 1];
                    bytes[0] = (byte)(strlen2 + 73);
                    for (int i = 0; i < strlen2; ++i) {
                        bytes[i + 1] = (byte)chars[i];
                    }
                    return bytes;
                }
            }
        } else if (JDKUtils.UNSAFE_SUPPORT && (coder = UnsafeUtils.getStringCoder(str)) == 0 && (strlen = (value = UnsafeUtils.getStringValue(str)).length) <= 47) {
            byte[] bytes = new byte[value.length + 1];
            bytes[0] = (byte)(strlen + 73);
            System.arraycopy(value, 0, bytes, 1, value.length);
            return bytes;
        }
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider), null);){
            ((JSONWriter)writer).writeString(str);
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(String str, Charset charset) {
        int type;
        if (str == null) {
            return new byte[]{-81};
        }
        if (charset == StandardCharsets.UTF_16) {
            type = 123;
        } else if (charset == StandardCharsets.UTF_16BE) {
            type = 125;
        } else if (charset == StandardCharsets.UTF_16LE) {
            type = 124;
        } else if (charset != null && "GB18030".equals(charset.name())) {
            type = 126;
        } else {
            return JSONB.toBytes(str);
        }
        byte[] utf16 = str.getBytes(charset);
        int byteslen = 2 + utf16.length;
        byteslen = utf16.length <= 47 ? (byteslen += 0) : (utf16.length <= 2047 ? ++byteslen : (utf16.length <= 262143 ? (byteslen += 2) : (byteslen += 4)));
        byte[] bytes = new byte[byteslen];
        bytes[0] = type;
        int off = 1;
        off += JSONB.writeInt(bytes, off, utf16.length);
        System.arraycopy(utf16, 0, bytes, off, utf16.length);
        return bytes;
    }

    public static byte[] toBytes(Object object) {
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider), null);){
            if (object == null) {
                ((JSONWriter)writer).writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable) {
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider), symbolTable);){
            if (object == null) {
                ((JSONWriter)writer).writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable, JSONWriter.Feature ... features) {
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features), symbolTable);){
            JSONWriter.Context ctx = writer.context;
            ctx.config(features);
            if (object == null) {
                ((JSONWriter)writer).writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (ctx.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = ctx.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((ctx.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, SymbolTable symbolTable, Filter[] filters, JSONWriter.Feature ... features) {
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features), symbolTable);){
            JSONWriter.Context ctx = writer.context;
            ctx.config(features);
            ctx.configFilter(filters);
            if (object == null) {
                ((JSONWriter)writer).writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                boolean fieldBased = (ctx.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                ObjectWriter objectWriter = ctx.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((ctx.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static byte[] toBytes(Object object, JSONWriter.Feature ... features) {
        try (JSONWriterJSONB writer = new JSONWriterJSONB(new JSONWriter.Context(JSONFactory.defaultObjectWriterProvider, features), null);){
            JSONWriter.Context context = writer.context;
            if (object == null) {
                ((JSONWriter)writer).writeNull();
            } else {
                writer.rootObject = object;
                if ((context.features & JSONWriter.Feature.ReferenceDetection.mask) != 0L) {
                    writer.refs = new IdentityHashMap(8);
                    writer.path = JSONWriter.Path.ROOT;
                    writer.refs.put(object, writer.path);
                }
                boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = context.provider.getObjectWriter(valueClass, valueClass, fieldBased);
                if ((context.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
                    objectWriter.writeArrayMappingJSONB(writer, object, null, null, 0L);
                } else {
                    objectWriter.writeJSONB(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = ((JSONWriter)writer).getBytes();
            return byArray;
        }
    }

    public static SymbolTable symbolTable(String ... names) {
        return new JSONFactory.SymbolTableImpl(names);
    }

    public static String toJSONString(byte[] jsonbBytes) {
        return new JSONBDump(jsonbBytes, false).toString();
    }

    public static String toJSONString(byte[] jsonbBytes, SymbolTable symbolTable) {
        return new JSONBDump(jsonbBytes, symbolTable, false).toString();
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        JSONWriter writer = JSONWriter.ofJSONB();
        try {
            int len;
            writer.config(features);
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.writeJSONB(writer, object, null, null, 0L);
            }
            int n = len = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JSONException("writeJSONString error", e);
            }
        }
    }

    public static byte[] fromJSONString(String str) {
        return JSONB.toBytes(JSON.parse(str));
    }

    public static byte[] fromJSONBytes(byte[] jsonUtf8Bytes) {
        JSONReader reader = JSONReader.of(jsonUtf8Bytes);
        ObjectReader objectReader = reader.getObjectReader((Type)((Object)Object.class));
        Object object = objectReader.readObject(reader, null, null, 0L);
        return JSONB.toBytes(object);
    }

    public static String typeName(byte type) {
        switch (type) {
            case -90: {
                return "OBJECT " + Integer.toString(type);
            }
            case -91: {
                return "OBJECT_END " + Integer.toString(type);
            }
            case -109: {
                return "REFERENCE " + Integer.toString(type);
            }
            case 127: {
                return "SYMBOL " + Integer.toString(type);
            }
            case -81: {
                return "NULL " + Integer.toString(type);
            }
            case -79: {
                return "TRUE " + Integer.toString(type);
            }
            case -80: {
                return "FALSE " + Integer.toString(type);
            }
            case 122: {
                return "STR_UTF8 " + Integer.toString(type);
            }
            case 123: {
                return "STR_UTF16 " + Integer.toString(type);
            }
            case 124: {
                return "STR_UTF16LE " + Integer.toString(type);
            }
            case 125: {
                return "STR_UTF16BE " + Integer.toString(type);
            }
            case -67: {
                return "INT8 " + Integer.toString(type);
            }
            case -68: {
                return "INT16 " + Integer.toString(type);
            }
            case 72: {
                return "INT32 " + Integer.toString(type);
            }
            case -66: 
            case -65: {
                return "INT64 " + Integer.toString(type);
            }
            case -74: 
            case -73: {
                return "FLOAT " + Integer.toString(type);
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: {
                return "DOUBLE " + Integer.toString(type);
            }
            case -70: 
            case -69: {
                return "BIGINT " + Integer.toString(type);
            }
            case -72: 
            case -71: {
                return "DECIMAL " + Integer.toString(type);
            }
            case -89: {
                return "LOCAL_TIME " + Integer.toString(type);
            }
            case -111: {
                return "BINARY " + Integer.toString(type);
            }
            case -88: {
                return "LOCAL_DATETIME " + Integer.toString(type);
            }
            case -82: {
                return "TIMESTAMP " + Integer.toString(type);
            }
            case -83: {
                return "TIMESTAMP_MINUTES " + Integer.toString(type);
            }
            case -84: {
                return "TIMESTAMP_SECONDS " + Integer.toString(type);
            }
            case -85: {
                return "TIMESTAMP_MILLIS " + Integer.toString(type);
            }
            case -86: {
                return "TIMESTAMP_WITH_TIMEZONE " + Integer.toString(type);
            }
            case -87: {
                return "LOCAL_DATE " + Integer.toString(type);
            }
            case -110: {
                return "TYPED_ANY " + Integer.toString(type);
            }
        }
        if (type >= -108 && type <= -92) {
            return "ARRAY " + Integer.toString(type);
        }
        if (type >= 73 && type <= 121) {
            return "STR_ASCII " + Integer.toString(type);
        }
        if (type >= -16 && type <= 47) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= 48 && type <= 63) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= 64 && type <= 71) {
            return "INT32 " + Integer.toString(type);
        }
        if (type >= -40 && type <= -17) {
            return "INT64 " + Integer.toString(type);
        }
        if (type >= -56 && type <= -41) {
            return "INT64 " + Integer.toString(type);
        }
        if (type >= -64 && type <= -57) {
            return "INT64 " + Integer.toString(type);
        }
        return Integer.toString(type);
    }

    public static interface Constants {
        public static final byte BC_CHAR = -112;
        public static final byte BC_BINARY = -111;
        public static final byte BC_TYPED_ANY = -110;
        public static final byte BC_REFERENCE = -109;
        public static final int ARRAY_FIX_LEN = 15;
        public static final byte BC_ARRAY_FIX_0 = -108;
        public static final byte BC_ARRAY_FIX_MIN = -108;
        public static final byte BC_ARRAY_FIX_MAX = -93;
        public static final byte BC_ARRAY = -92;
        public static final byte BC_OBJECT_END = -91;
        public static final byte BC_OBJECT = -90;
        public static final byte BC_LOCAL_TIME = -89;
        public static final byte BC_LOCAL_DATETIME = -88;
        public static final byte BC_LOCAL_DATE = -87;
        public static final byte BC_TIMESTAMP_WITH_TIMEZONE = -86;
        public static final byte BC_TIMESTAMP_MILLIS = -85;
        public static final byte BC_TIMESTAMP_SECONDS = -84;
        public static final byte BC_TIMESTAMP_MINUTES = -83;
        public static final byte BC_TIMESTAMP = -82;
        public static final byte BC_NULL = -81;
        public static final byte BC_FALSE = -80;
        public static final byte BC_TRUE = -79;
        public static final byte BC_DOUBLE_NUM_0 = -78;
        public static final byte BC_DOUBLE_NUM_1 = -77;
        public static final byte BC_DOUBLE_LONG = -76;
        public static final byte BC_DOUBLE = -75;
        public static final byte BC_FLOAT_INT = -74;
        public static final byte BC_FLOAT = -73;
        public static final byte BC_DECIMAL_LONG = -72;
        public static final byte BC_DECIMAL = -71;
        public static final byte BC_BIGINT_LONG = -70;
        public static final byte BC_BIGINT = -69;
        public static final byte BC_INT16 = -68;
        public static final byte BC_INT8 = -67;
        public static final byte BC_INT64 = -66;
        public static final byte BC_INT64_INT = -65;
        public static final int INT64_SHORT_MIN = -262144;
        public static final int INT64_SHORT_MAX = 262143;
        public static final int INT64_BYTE_MIN = -2048;
        public static final int INT64_BYTE_MAX = 2047;
        public static final byte BC_INT64_SHORT_MIN = -64;
        public static final byte BC_INT64_SHORT_ZERO = -60;
        public static final byte BC_INT64_SHORT_MAX = -57;
        public static final byte BC_INT64_BYTE_MIN = -56;
        public static final byte BC_INT64_BYTE_ZERO = -48;
        public static final byte BC_INT64_BYTE_MAX = -41;
        public static final byte BC_INT64_NUM_MIN = -40;
        public static final byte BC_INT64_NUM_MAX = -17;
        public static final int INT64_NUM_LOW_VALUE = -8;
        public static final int INT64_NUM_HIGH_VALUE = 15;
        public static final byte BC_INT32_NUM_0 = 0;
        public static final byte BC_INT32_NUM_1 = 1;
        public static final byte BC_INT32_NUM_16 = 16;
        public static final byte BC_INT32_NUM_MIN = -16;
        public static final byte BC_INT32_NUM_MAX = 47;
        public static final byte BC_INT32_BYTE_MIN = 48;
        public static final byte BC_INT32_BYTE_ZERO = 56;
        public static final byte BC_INT32_BYTE_MAX = 63;
        public static final byte BC_INT32_SHORT_MIN = 64;
        public static final byte BC_INT32_SHORT_ZERO = 68;
        public static final byte BC_INT32_SHORT_MAX = 71;
        public static final byte BC_INT32 = 72;
        public static final int INT32_BYTE_MIN = -2048;
        public static final int INT32_BYTE_MAX = 2047;
        public static final int INT32_SHORT_MIN = -262144;
        public static final int INT32_SHORT_MAX = 262143;
        public static final byte BC_STR_ASCII_FIX_0 = 73;
        public static final byte BC_STR_ASCII_FIX_1 = 74;
        public static final byte BC_STR_ASCII_FIX_4 = 77;
        public static final byte BC_STR_ASCII_FIX_5 = 78;
        public static final byte BC_STR_ASCII_FIX_32 = 105;
        public static final byte BC_STR_ASCII_FIX_36 = 109;
        public static final int STR_ASCII_FIX_LEN = 47;
        public static final byte BC_STR_ASCII_FIX_MIN = 73;
        public static final byte BC_STR_ASCII_FIX_MAX = 120;
        public static final byte BC_STR_ASCII = 121;
        public static final byte BC_STR_UTF8 = 122;
        public static final byte BC_STR_UTF16 = 123;
        public static final byte BC_STR_UTF16LE = 124;
        public static final byte BC_STR_UTF16BE = 125;
        public static final byte BC_STR_GB18030 = 126;
        public static final byte BC_SYMBOL = 127;
    }
}

