/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.upgrade;

import com.hundsun.lightdb.unisql.upgrade.DbType;
import com.hundsun.lightdb.unisql.upgrade.UniSqlUpgradeApplication;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandParser {
    private static final Logger log = LoggerFactory.getLogger(CommandParser.class);
    public static final String OPT_SOURCE = "S";
    public static final String OPT_TARGET = "T";
    public static final String OPT_HOST = "h";
    public static final String OPT_PORT = "p";
    public static final String OPT_USERNAME = "U";
    public static final String OPT_PASSWORD = "W";
    public static final String OPT_DBNAME = "d";
    public static final String OPT_SCHEMA = "s";
    public static final String OPT_VERSION = "v";
    public static final String OPT_ALL = "all";
    public static final String OPT_HELP = "help";
    private final String[] args;
    private String source;
    private String target;
    private String host;
    private String port;
    private String username;
    private String password;
    private String dbname;
    private String schema = "unisql";
    private String version;
    private boolean all;
    private boolean help;
    private CommandLine cmd;

    public CommandParser(String[] args) throws ParseException {
        this.args = args;
        this.parse(args);
    }

    private void parse(String[] args) throws ParseException {
        Options options = CommandParser.options();
        DefaultParser parser = new DefaultParser();
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            if (log.isErrorEnabled()) {
                log.error("\u975e\u6cd5\u53c2\u6570 [{}]. \u8bf7\u901a\u8fc7 java -jar unisql-upgrade-<version>.jar \u2013help \u67e5\u770b\u53ef\u7528\u7684\u9009\u9879", (Object)e.getOption());
            }
            throw e;
        }
        catch (MissingArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error("{}. \u8bf7\u901a\u8fc7 java -jar unisql-upgrade-<version>.jar \u2013help \u67e5\u770b\u53ef\u7528\u7684\u9009\u9879", (Object)e.getMessage());
            }
            throw e;
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                log.error("\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            throw e;
        }
        this.help = this.cmd.hasOption("help");
        this.all = this.cmd.hasOption("all");
        this.source = this.cmd.getOptionValue("S");
        this.target = this.cmd.getOptionValue("T");
        this.host = this.cmd.getOptionValue("h");
        this.port = this.cmd.getOptionValue("p");
        this.dbname = this.cmd.getOptionValue("d");
        this.username = this.cmd.getOptionValue("U");
        this.password = this.cmd.getOptionValue("W");
        if (this.cmd.getOptionValue("s") != null) {
            this.schema = this.cmd.getOptionValue("s");
        }
        this.version = this.cmd.getOptionValue("v");
    }

    public static void printHelp() {
        log.info("Usage:");
        log.info("java -jar unisql-upgrade-<version>.jar -S \u6e90\u7aef\u6570\u636e\u5e93\u7c7b\u578b -T \u76ee\u6807\u7aef\u6570\u636e\u5e93\u7c7b\u578b -h \u6570\u636e\u5e93IP -p \u6570\u636e\u5e93\u7aef\u53e3 -U \u6570\u636e\u5e93\u7528\u6237\u540d -W \u6570\u636e\u5e93\u5bc6\u7801 -d \u8981\u8fde\u63a5\u7684\u6570\u636e\u5e93\u540d\u79f0 [-all] [OPTION]... ");
        log.info("\n");
        log.info("options:");
        log.info("  -S, --source   ,\u662f\u5426\u5fc5\u987b:\u662f, \u6e90\u7aef\u6570\u636e\u5e93\u7c7b\u578b(ORACLE\u3001MYSQL)");
        log.info("  -T, --target   ,\u662f\u5426\u5fc5\u987b:\u662f, \u76ee\u6807\u7aef\u6570\u636e\u5e93\u7c7b\u578b(\u5f53\u6e90\u4e3aORACLE\u65f6\uff0c\u76ee\u6807\u5e93\u53d6\u503c\u8303\u56f4:POSTGRESQL\u3001TDSQL_MYSQL\u3001OCEAN_BASE_MYSQL\u3001TDSQL_PG_ORACLE\u3001GAUSSDB_ORACLE\u3001TDSQL_PG\u3001GOLDENDB_MYSQL\uff1b\u5f53\u6e90\u4e3aMYSQL\u65f6\uff0c\u76ee\u6807\u5e93\u53d6\u503c\u8303\u56f4:GAUSSDB500_ORACLE\u3001ORACLE_19C\u3001OCEAN_BASE_ORACLE\u3001GAUSSDB_ORACLE\u3001GAUSSDB_MYSQL_B\u3001TDSQL_PG\u3001DM)");
        log.info("  -h, --host     ,\u662f\u5426\u5fc5\u987b:\u662f, \u6570\u636e\u5e93IP");
        log.info("  -p, --port     ,\u662f\u5426\u5fc5\u987b:\u662f, \u6570\u636e\u5e93\u7aef\u53e3");
        log.info("  -U, --username ,\u662f\u5426\u5fc5\u987b:\u662f, \u6570\u636e\u5e93\u7528\u6237\u540d");
        log.info("  -W, --password ,\u662f\u5426\u5fc5\u987b:\u662f, \u6570\u636e\u5e93\u5bc6\u7801");
        log.info("  -d, --dbname   ,\u662f\u5426\u5fc5\u987b:\u662f, \u8981\u8fde\u63a5\u7684\u6570\u636e\u5e93\u540d\u79f0\u3002(\u6682\u4e0d\u652f\u6301\u5927\u5c0f\u5199\u654f\u611f)");
        log.info("  -s, --schema   ,\u662f\u5426\u5fc5\u987b:\u5426, \u5c06sql\u811a\u672c\u6253\u5165\u5230\u54ea\u4e2aschema(TDSQL_MYSQL\u3001OCEAN_BASE_MYSQL\u5219\u4e3adatabase)\u4e0b(\u9ed8\u8ba4: unisql )\u3002\u6682\u4e0d\u652f\u6301\u5927\u5c0f\u5199\u654f\u611f");
        log.info("  -v, --version  ,\u662f\u5426\u5fc5\u987b:\u5426, \u5347\u7ea7\u5230\u6307\u5b9a\u7248\u672c(\u7248\u672c\u53f7\u89c1\u5b98\u7f51\u7684\u7248\u672c\u53d1\u5e03\u5386\u53f2\u7ae0\u8282\uff0c\u683c\u5f0f\uff1axx(\u5e74\u4efd).xx(RP\u7248\u672c).xx(\u589e\u91cf\u7248\u672c).xxx(\u8865\u4e01\u7248\u672c)\u3002\u9ed8\u8ba4\u4e3a\u5f53\u524d\u5b89\u88c5\u5305\u6700\u65b0\u7248\u672c)");
        log.info("  -all, --all    ,\u662f\u5426\u5fc5\u987b:\u5426, \u662f\u5426\u6267\u884c\u5168\u91cf\u811a\u672c\u9009\u9879\uff0c\u5177\u6709\u6700\u9ad8\u4f18\u5148\u7ea7(\u9ad8\u4e8e-v)\uff0c\u7b2c\u4e00\u6b21\u63a5\u5165\u65f6\u53ef\u4ee5\u9009\u62e9\u6267\u884c\u5168\u91cf\u811a\u672c\uff0c\u5426\u5219\u8fdb\u884c\u589e\u91cf\u811a\u672c\u7684\u8fed\u4ee3\u5347\u7ea7");
        log.info("  -help, --help   \u663e\u793a jar \u547d\u4ee4\u7684\u7528\u6cd5\u548c\u6240\u6709\u53ef\u7528\u7684\u9009\u9879");
        log.info("\n");
    }

    public static Options options() {
        Options options = new Options();
        options.addOption("S", "source", true, "\u6e90\u7aef\u6570\u636e\u5e93\u7c7b\u578b(ORACLE\u3001MYSQL)");
        options.addOption("T", "target", true, "\u76ee\u6807\u7aef\u6570\u636e\u5e93\u7c7b\u578b(\u5f53\u6e90\u4e3aORACLE\u65f6\uff0c\u76ee\u6807\u5e93\u53d6\u503c\u8303\u56f4:POSTGRESQL\u3001TDSQL_MYSQL\u3001OCEAN_BASE_MYSQL\u3001TDSQL_PG_ORACLE\u3001GAUSSDB_ORACLE\uff1b\u5f53\u6e90\u4e3aMYSQL\u65f6\uff0c\u76ee\u6807\u5e93\u53d6\u503c\u8303\u56f4:GAUSSDB500_ORACLE\u3001ORACLE_19C\u3001OCEAN_BASE_ORACLE\u3001GAUSSDB_ORACLE\u3001GAUSSDB_MYSQL_B\u3001DM)");
        options.addOption("h", "host", true, "\u6570\u636e\u5e93IP");
        options.addOption("p", "port", true, "\u6570\u636e\u5e93\u7aef\u53e3");
        options.addOption("U", "username", true, "\u6570\u636e\u5e93\u7528\u6237\u540d");
        options.addOption("W", "password", true, "\u6570\u636e\u5e93\u5bc6\u7801");
        options.addOption("d", "dbname", true, "\u8981\u8fde\u63a5\u7684\u6570\u636e\u5e93\u540d\u79f0\u3002(\u6682\u4e0d\u652f\u6301\u5927\u5c0f\u5199\u654f\u611f)");
        options.addOption("s", "schema", true, "\u5c06sql\u811a\u672c\u6253\u5165\u5230\u54ea\u4e2aschema(TDSQL_MYSQL\u3001OCEAN_BASE_MYSQL\u5219\u4e3adatabase)\u4e0b(\u9ed8\u8ba4: unisql )\u3002\u6682\u4e0d\u652f\u6301\u5927\u5c0f\u5199\u654f\u611f");
        options.addOption("v", "version", true, "\u5347\u7ea7\u5230\u6307\u5b9a\u7248\u672c(\u7248\u672c\u53f7\u89c1\u5b98\u7f51\u7684\u7248\u672c\u53d1\u5e03\u5386\u53f2\u7ae0\u8282\uff0c\u683c\u5f0f\uff1axx(\u5e74\u4efd).xx(RP\u7248\u672c).xx(\u589e\u91cf\u7248\u672c).xxx(\u8865\u4e01\u7248\u672c)\u3002\u9ed8\u8ba4\u4e3a\u5f53\u524d\u5b89\u88c5\u5305\u6700\u65b0\u7248\u672c)");
        options.addOption("all", "all", false, "\u662f\u5426\u6267\u884c\u5168\u91cf\u811a\u672c\u9009\u9879\uff0c\u5177\u6709\u6700\u9ad8\u4f18\u5148\u7ea7(\u9ad8\u4e8e-v)\uff0c\u7b2c\u4e00\u6b21\u63a5\u5165\u65f6\u53ef\u4ee5\u9009\u62e9\u6267\u884c\u5168\u91cf\u811a\u672c\uff0c\u5426\u5219\u8fdb\u884c\u589e\u91cf\u811a\u672c\u7684\u8fed\u4ee3\u5347\u7ea7");
        options.addOption("help", "help", false, "\u663e\u793a jar \u547d\u4ee4\u7684\u7528\u6cd5\u548c\u6240\u6709\u53ef\u7528\u7684\u9009\u9879");
        return options;
    }

    public boolean hasHelpOption() {
        return this.help;
    }

    public boolean hasAllOption() {
        return this.all;
    }

    public boolean validateRequiredOptions() {
        return this.source != null && this.target != null && this.host != null && this.port != null && this.dbname != null && this.username != null && this.password != null;
    }

    public boolean checkParameters() {
        if (!DbType.ORACLE.name().equalsIgnoreCase(this.source) && !DbType.MYSQL.name().equalsIgnoreCase(this.source)) {
            if (log.isErrorEnabled()) {
                log.error("\u6e90\u7aef\u6570\u636e\u5e93\u7c7b\u578b\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
            }
            return false;
        }
        try {
            DbType.of((String)this.target);
        }
        catch (IllegalArgumentException e) {
            if (log.isErrorEnabled()) {
                log.error("\u76ee\u6807\u7aef\u6570\u636e\u5e93\u7c7b\u578b\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
            }
            return false;
        }
        if (!CommandParser.isValidIpv4((String)this.host)) {
            if (log.isErrorEnabled()) {
                log.error("IP\u5730\u5740\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
            }
            return false;
        }
        if (!CommandParser.isValidPort((String)this.port)) {
            if (log.isErrorEnabled()) {
                log.error("\u7aef\u53e3\u53f7\u8f93\u5165\u4e0d\u6b63\u786e\uff01");
            }
            return false;
        }
        if (this.version != null) {
            try {
                UniSqlUpgradeApplication.formatVersionToFourSegments((String)this.version);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u7248\u672c\u53f7\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIpv4(String ip) {
        String ipv4Pattern = "^(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[0-1]?[0-9][0-9]?)$";
        return ip != null && ip.matches(ipv4Pattern);
    }

    public static boolean isValidPort(String port) {
        try {
            int portNumber = Integer.parseInt(port);
            return portNumber >= 0 && portNumber <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.dbname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getVersion() {
        return this.version;
    }
}

