-- Oracle19c 授权方案改为创建执行完SQL语句后，增加创建所有用户对unisql下表视图访问执行权限，和对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
-- 创建unisql模式
DECLARE
    v_count NUMBER;
BEGIN
    SELECT COUNT(*) INTO v_count FROM DBA_USERS WHERE USERNAME = upper('UNISQL');

    IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER UNISQL IDENTIFIED BY "unisql_pwd123"';
    END IF;
    EXECUTE IMMEDIATE 'ALTER USER UNISQL QUOTA UNLIMITED ON USERS';
END;

-- mysql8ToOracle19c 内置函数转换：Oracle 中没有 find_in_set 的对应改写方式，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.FIND_IN_SET(p_str IN VARCHAR2, p_list IN VARCHAR2)
RETURN NUMBER IS
    l_position NUMBER := 0;
    l_start_pos NUMBER := 1;
    l_comma_pos NUMBER;
    l_element VARCHAR2(32767);
BEGIN

    IF p_str IS NULL OR p_list IS NULL THEN
        RETURN NULL;
    END IF;


    IF p_list = '' THEN
        RETURN 0;
    END IF;


    IF INSTR(p_str, ',') > 0 THEN
        RETURN 0;
    END IF;


    LOOP
        l_comma_pos := INSTR(p_list, ',', l_start_pos);
        IF l_comma_pos = 0 THEN
            l_element := SUBSTR(p_list, l_start_pos);
        ELSE
            l_element := SUBSTR(p_list, l_start_pos, l_comma_pos - l_start_pos);
        END IF;


        IF l_element = p_str THEN
            RETURN l_position + 1;
        END IF;

        l_position := l_position + 1;
        EXIT WHEN l_comma_pos = 0;
        l_start_pos := l_comma_pos + 1;
    END LOOP;

    RETURN 0;
END FIND_IN_SET;

-- mysql8ToOracle19c 内置函数转换：Oracle 中没有 SUBSTRING_INDEX 的对应改写方式，使用自定义函数实现
CREATE OR REPLACE FUNCTION unisql.SUBSTRING_INDEX(str VARCHAR2, delimiter VARCHAR2, occurrence NUMBER) RETURN VARCHAR2 IS
    result VARCHAR2(4000);
    pos NUMBER;
    current_count NUMBER := 0;
    start_pos NUMBER;
    abs_occurrence NUMBER;

    positions DBMS_UTILITY.NUMBER_ARRAY;
    i NUMBER;
BEGIN
    IF occurrence = 0 THEN
        RETURN '';
    ELSIF occurrence > 0 THEN
        start_pos := 1;
        WHILE current_count < occurrence LOOP
            pos := INSTR(str, delimiter, start_pos);
            IF pos = 0 THEN
                result := str;
                EXIT;
            END IF;
            result := SUBSTR(str, 1, pos - 1);
            start_pos := pos + LENGTH(delimiter);
            current_count := current_count + 1;
        END LOOP;
    ELSE
        abs_occurrence := ABS(occurrence);
        start_pos := 1;

        LOOP
            pos := INSTR(str, delimiter, start_pos);
            IF pos = 0 THEN
                EXIT;
            END IF;
            current_count := current_count + 1;
            positions(current_count) := pos;
            start_pos := pos + LENGTH(delimiter);
        END LOOP;

        i := current_count - abs_occurrence + 1;
        IF i <= 0 THEN
            result := str;
        ELSE
            result := SUBSTR(str, positions(i) + LENGTH(delimiter));
        END IF;
    END IF;
    RETURN result;
END SUBSTRING_INDEX;

-- mysql8ToOracle19c 内置函数转换：该函数用于转 IF(cond, expr1, expr2) ，输入 cond 输出 0 或 1
CREATE OR REPLACE FUNCTION unisql.is_nonzero(input_val IN VARCHAR2) RETURN NUMBER 
IS
  num_val NUMBER;
  trimmed_val VARCHAR2(4000);
BEGIN

  IF input_val IS NULL THEN
    RETURN 0;
  END IF;


  trimmed_val := TRIM(input_val);


  IF trimmed_val IS NULL THEN
    RETURN 0;
  END IF;


  BEGIN
    num_val := TO_NUMBER(trimmed_val);
  EXCEPTION
    WHEN VALUE_ERROR THEN
      RETURN 0;
  END;


  IF num_val = 0 THEN
    RETURN 0;
  ELSE
    RETURN 1;
  END IF;
END is_nonzero;

-- 在赋权前就需要创建unisql_version版本号信息维护表，以便能够被赋权
DECLARE
v_count NUMBER;
BEGIN
SELECT COUNT(*) INTO v_count from ALL_TABLES WHERE OWNER = upper('UNISQL') AND TABLE_NAME = 'UNISQL_VERSION';

IF v_count = 0 THEN
        EXECUTE IMMEDIATE 'create table UNISQL.UNISQL_VERSION (id int primary key,version varchar(20),update_time date)';
END IF;
END;

-- 创建所有用户对unisql下表访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('TABLE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT, INSERT, UPDATE, DELETE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下视图访问权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('VIEW')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT SELECT ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;

-- 创建所有用户对unisql下PROCEDURE、FUNCTION、PACKAGE访问执行权限
BEGIN
FOR obj IN (
    SELECT object_name
    FROM all_objects
    WHERE owner = upper('UNISQL')
      AND object_type IN ('PROCEDURE', 'FUNCTION', 'PACKAGE')
  ) LOOP
    EXECUTE IMMEDIATE 'GRANT EXECUTE ON UNISQL.' || obj.object_name || ' TO PUBLIC';
END LOOP;
END;


