-- 创建substr函数,参数类型分别为text, numeric,numeric
CREATE OR REPLACE FUNCTION unisql.substr(text, numeric,numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
    processed_index INT;
    processed_length INT;
begin
     IF $1 = '' THEN
        RETURN NULL;
END IF;
    processed_text := $1;
    IF TRUNC($2) = 0 THEN
        processed_index := 1;
    ELSIF TRUNC($2) < 0 THEN
        processed_index := LENGTH(processed_text) + TRUNC($2)::INT + 1;
        IF processed_index < 1 THEN
            RETURN NULL;
END IF;
ELSE
        processed_index := TRUNC($2)::INT;
END IF;
   processed_length := TRUNC($3);
   IF processed_length < 1 then
        return null;
END IF;
RETURN pg_catalog.substr(processed_text, processed_index,processed_length);
END;
$$;


-- 创建substr函数,参数类型分别为text,numeric,text
CREATE OR REPLACE FUNCTION unisql.substr(text,numeric,text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' OR $3 = ''  THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2, $3::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text,text,numeric
CREATE OR REPLACE FUNCTION unisql.substr(text,text,numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' OR $2 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric,$3);
END;
$$;


-- 创建substr函数,参数类型分别为numeric,text,numeric
CREATE OR REPLACE FUNCTION unisql.substr(numeric,text,numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF  $2 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric,$3::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text,text,numeric
CREATE OR REPLACE FUNCTION unisql.substr(text,text,numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' OR $2 = ''  THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric, $3);
END;
$$;


-- 创建substr函数,参数类型分别为text,text,text
CREATE OR REPLACE FUNCTION unisql.substr(text,text,text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' OR $2 = '' OR $3 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric,$3::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为numeric,numeric,numeric
CREATE OR REPLACE FUNCTION unisql.substr(numeric,numeric,numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
begin
    processed_text :=  rtrim(to_char($1, 'FM99999999999999999999999999999999999999.99999999999999999999999999999999999999'),'.');
RETURN unisql.substr(processed_text, $2,$3);
END;
$$;


-- 创建substr函数,参数类型分别为numeric, numeric,text
CREATE OR REPLACE FUNCTION unisql.substr(numeric, numeric,text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
begin
    IF $3 = '' THEN
        RETURN NULL;
END IF;
    processed_text :=  rtrim(to_char($1, 'FM99999999999999999999999999999999999999.99999999999999999999999999999999999999'),'.');
RETURN unisql.substr(processed_text, $2,$3::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为numeric, text, numeric
CREATE OR REPLACE FUNCTION unisql.substr(numeric, text, numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
begin
    IF $2 = '' THEN
        RETURN NULL;
END IF;
    processed_text :=  rtrim(to_char($1, 'FM99999999999999999999999999999999999999.99999999999999999999999999999999999999'),'.');
RETURN unisql.substr(processed_text, $2::numeric,$3);
END;
$$;



-- 创建substr函数,参数类型分别为numeric, text, text
CREATE OR REPLACE FUNCTION unisql.substr(numeric, text, text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
begin
    IF $2 = '' OR $3='' THEN
        RETURN NULL;
END IF;
    processed_text :=  rtrim(to_char($1, 'FM99999999999999999999999999999999999999.99999999999999999999999999999999999999'),'.');
RETURN unisql.substr(processed_text, $2::numeric,$3::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text, numeric
CREATE OR REPLACE FUNCTION unisql.substr(text, numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
    processed_index INT;
begin
    IF $1 = '' THEN
        RETURN NULL;
END IF;
    processed_text := $1;
    IF TRUNC($2) = 0 THEN
        processed_index := 1;
    ELSIF TRUNC($2) < 0 THEN
        processed_index := LENGTH(processed_text) + TRUNC($2)::INT + 1;
        IF processed_index < 1 THEN
            RETURN NULL;
END IF;
ELSE
        processed_index := TRUNC($2)::INT;
END IF;
RETURN pg_catalog.substr(processed_text, processed_index);
END;
$$;


-- 创建substr函数,参数类型分别为numeric, numeric
CREATE OR REPLACE FUNCTION unisql.substr(numeric, numeric)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
DECLARE
processed_text TEXT;
begin
    processed_text :=  rtrim(to_char($1, 'FM99999999999999999999999999999999999999.99999999999999999999999999999999999999'),'.');
RETURN unisql.substr(processed_text, $2);
END;
$$;


-- 创建substr函数,参数类型分别为numeric, text
CREATE OR REPLACE FUNCTION unisql.substr(numeric, text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $2 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text, text
CREATE OR REPLACE FUNCTION unisql.substr(text, text)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' or  $2 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text, int4
CREATE OR REPLACE FUNCTION unisql.substr(text, int4)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric);
END;
$$;


-- 创建substr函数,参数类型分别为text,int4,int4
CREATE OR REPLACE FUNCTION unisql.substr(text,int4,int4)
RETURNS TEXT LANGUAGE plpgsql IMMUTABLE STRICT AS  $$
begin
    IF $1 = '' THEN
        RETURN NULL;
END IF;
RETURN unisql.substr($1, $2::numeric,$3::numeric);
END;
$$;


-- 创建unisql模式
do language 'plpgsql'
$body$
    declare
create_mark int;
begin
select count(1) into create_mark from pg_namespace where nspname='unisql';
if create_mark = 0 then
create schema unisql;
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'create schema unisql';
else
GRANT USAGE ON SCHEMA public TO PUBLIC;
GRANT USAGE ON SCHEMA unisql TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA public TO PUBLIC;
GRANT SELECT ON ALL TABLES IN SCHEMA unisql TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA public GRANT SELECT ON TABLES TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA unisql GRANT SELECT ON TABLES TO PUBLIC;
raise notice 'do not create schema unisql';
end if;
end $body$;

-- 创建dba_tables视图，需求说明202501144789 统一SQL - 支持 oracle2pg 支持 all_tables 系统表查询，修改说明:在unisql这个schema下创建系统视图dba_tables和all_tables，all_tables转换后是unisql.all_tables
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='dba_tables';
if create_mark = 0 then
CREATE OR REPLACE VIEW unisql.dba_tables AS
SELECT
    case when n.nspname::text = lower(n.nspname::text)
        then UPPER(n.nspname::text) else n.nspname::text end AS OWNER,
    case when c.relname::text = lower(c.relname::text)
        then UPPER(c.relname::text) else c.relname::text end AS TABLE_NAME,
    coalesce(UPPER(t.spcname::text), 'DEFAULT') as TABLESPACE_NAME,
    NULL::text as CLUSTER_NAME,
    NULL::text as IOT_NAME,
    NULL::text as STATUS,
    NULL::numeric as PCT_FREE,
    NULL::numeric as PCT_USED,
    NULL::numeric as INI_TRANS,
    NULL::numeric as MAX_TRANS,
    NULL::numeric as INITIAL_EXTENT,
    NULL::numeric as NEXT_EXTENT,
    NULL::numeric as MIN_EXTENTS,
    NULL::numeric as MAX_EXTENTS,
    NULL::numeric as PCT_INCREASE,
    NULL::numeric as FREELISTS,
    NULL::numeric as FREELIST_GROUPS,
    case c.relpersistence
        when 'p' then 'YES' else 'NO' end as LOGGING,
    NULL::text as BACKED_UP,
    c.reltuples::bigint as NUM_ROWS,
    c.relpages::bigint as BLOCKS,
    NULL::numeric as EMPTY_BLOCKS,
    NULL::numeric as AVG_SPACE,
    NULL::numeric as CHAIN_CNT,
    NULL::numeric as AVG_ROW_LEN,
    NULL::numeric as AVG_SPACE_FREELIST_BLOCKS,
    NULL::numeric as NUM_FREELIST_BLOCKS,
    NULL::text as DEGREE,
    NULL::text as INSTANCES,
    NULL::text as CACHE,
    NULL::text as TABLE_LOCK,
    NULL::numeric as SAMPLE_SIZE,
    coalesce(pg_stat_get_last_analyze_time(c.oid), pg_stat_get_last_autoanalyze_time(c.oid)) as LAST_ANALYZED,
    case when c.relkind = 'p' then 'YES' else 'NO' end as PARTITIONED,
    NULL::text as IOT_TYPE,
    case c.relpersistence
        when 't' then 'YES' else 'NO' end as TEMPORARY,
    NULL::text as SECONDARY,
    NULL::text as NESTED,
    NULL::text as BUFFER_POOL,
    NULL::text as FLASH_CACHE,
    NULL::text as CELL_FLASH_CACHE,
    'ENABLE' as ROW_MOVEMENT,
    NULL::text as GLOBAL_STATS,
    NULL::text as USER_STATS,
    NULL::text as DURATION,
    NULL::text as SKIP_CORRUPT,
    NULL::text as MONITORING,
    NULL::text as CLUSTER_OWNER,
    NULL::text as DEPENDENCIES,
    NULL::text as COMPRESSION,
    NULL::text as COMPRESS_FOR,
    NULL::text as DROPPED,
    NULL::text as READ_ONLY,
    NULL::text as SEGMENT_CREATED,
    NULL::text as RESULT_CACHE
FROM pg_catalog.pg_class c
JOIN pg_catalog.pg_namespace n
    ON c.relnamespace = n.oid
LEFT JOIN pg_catalog.pg_tablespace t
    ON c.reltablespace = t.oid
WHERE c.relkind IN ('r', 'f', 'p')
    AND (pg_partition_root(c.oid) IS NULL OR pg_partition_root(c.oid) = c.oid)
    AND n.nspname::text NOT LIKE 'pg_toast%';
raise notice 'create view %','unisql.dba_tables';
else
raise notice 'do not create view %','unisql.dba_tables';
end if;
end $$;


-- 创建all_tables视图，需求说明202501144789 统一SQL - 支持 oracle2pg 支持 all_tables 系统表查询，修改说明:在unisql这个schema下创建系统视图dba_tables和all_tables，all_tables转换后是unisql.all_tables
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark from information_schema.views where table_schema='unisql' and table_name='all_tables';
if create_mark = 0 then
CREATE OR REPLACE VIEW unisql.all_tables AS select * from unisql.dba_tables;
raise notice 'create view %','unisql.all_tables';
else
raise notice 'do not create view %','unisql.all_tables';
end if;
end $$;
