-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric, VARIADIC combo text[]) returns numeric as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result text, VARIADIC combo text[]) returns text as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result date, VARIADIC combo text[]) returns date as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp, VARIADIC combo text[]) returns timestamp as 
$body$
declare
	v_len integer := array_length(combo, 1);
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		if v_len >= 1 then
			for i in 1..(v_len - 1) 
			loop
				if mod(i, 2) = 1 and combo[i] is null then
					return combo[i+1];
				end if;
			end loop;
		else
			raise exception 'not enough args for function.';
		end if;
		
		if mod(v_len, 2) = 1 then
			return combo[v_len];
		else 
			return null;
		end if;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	if v_len >= 1 then
		for i in 1..(v_len - 1) 
		loop
			if mod(i, 2) = 1 and combo[i] is not null then
				sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||combo[i] || ''')::'||compare_type ||')'; 
				EXECUTE sql_query INTO excute_result;
				if excute_result then
					return combo[i+1];
				end if;
			end if;
		end loop;
	else
		raise exception 'not enough args for function.';
	end if;

	if mod(v_len, 2) = 1 then
		return combo[v_len];
	else 
		return null;
	end if;
end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result timestamp) returns timestamp as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result date) returns date as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result text) returns text as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;

-- 创建unisql.decode函数，映射对应的oracle的decode函数
create or replace function unisql.decode(expression text, search anyelement, result numeric) returns numeric as 
$body$
declare
	excute_result bool;
	sql_query text;
	compare_type text := pg_typeof(search);
begin
    if expression is null then
        if search is null then
			return result;
		end if;
		return null;
    end if;


	if search is not null then
		sql_query := 'SELECT ((''' || expression || ''')::'|| compare_type ||' = ('''||search || ''')::'||compare_type ||')'; 
		EXECUTE sql_query INTO excute_result;
		if excute_result then
			return result;
		end if;
	end if;
	
	return null;

end;
$body$ language plpgsql;