-- 解决 pb to_number(date-date)
create  or replace function public.to_number(interval) returns int4
as $$
begin
return extract(day FROM $1);
end; $$ language plpgsql STRICT IMMUTABLE;

-- oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value ANYELEMENT)
    RETURNS ANYELEMENT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;

    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- oracle2gaussdb-oracle 支持除0,将输入转换为数值，然后检查其是否为0。如果是0，则返回NULL；否则，返回原始输入（暂时只支持整数0、字符串'0','0.0000'、浮点数0.0000、进制不支持）
CREATE OR REPLACE FUNCTION unisql.null_if_zero(input_value TEXT)
    RETURNS TEXT
AS $$
DECLARE
num_value NUMERIC;
BEGIN
BEGIN
        num_value := input_value::NUMERIC;
EXCEPTION WHEN others THEN
        RETURN input_value;
END;
    IF num_value = 0 THEN
        RETURN NULL;
ELSE
        RETURN input_value;
END IF;
END;
$$ language PLPGSQL STRICT IMMUTABLE;

-- 创建dual视图
do language 'plpgsql'
$$
declare
create_mark int;
begin
select count(1) into create_mark
from information_schema.views
where table_schema = 'public'
  and table_name = 'dual';
if create_mark = 0 then
        create or replace view public.dual as
select 'X' as dummy;
raise notice 'create view %', 'public.dual';
else
        raise notice 'do not create view %', 'public.dual';
end if;
end
$$;