/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.sqlv2;

import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.sqlv2.ResultSetHandler;
import com.hundsun.lightdb.unisql.utils.DbTypeSerializeUtil;
import com.hundsun.lightdb.unisql.utils.MultiJdbcUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "HARD_CODE_PASSWORD"})
public class EnhanceSqlEngine {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceSqlEngine.class);
    private static final String H2_URL = "jdbc:h2:mem:multiplex_stage;DB_CLOSE_DELAY=-1";
    private static final String H2_USER = "sa";
    private static final String H2_PASSWORD = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
    public static boolean executeSecondaryQueries(DbType dbType, String tableName, ResultSet rs, String desc, String sql, ResultSetHandler resultSetHandler) {
        logger.info("\u5f00\u59cb\u6267\u884c\u4e8c\u6b21\u67e5\u8be2\uff0c\u76ee\u6807\u8868\u540d\uff1a{}\uff0c\u67e5\u8be2SQL\uff1a{}", (Object)tableName, (Object)sql);
        Connection h2Conn = null;
        try {
            h2Conn = EnhanceSqlEngine.getH2Connection();
            if (h2Conn == null) {
                logger.error("\u83b7\u53d6H2\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
                boolean bl = false;
                return bl;
            }
            h2Conn.setAutoCommit(false);
            logger.debug("\u6210\u529f\u83b7\u53d6H2\u8fde\u63a5\uff0c\u5df2\u7981\u7528\u81ea\u52a8\u63d0\u4ea4");
            ResultSetMetaData metaData = rs.getMetaData();
            String createTableSql = EnhanceSqlEngine.generateCreateTableSql(dbType, tableName, desc, metaData);
            if (createTableSql == null) {
                logger.error("\u751f\u6210DDL\u8bed\u53e5\u5931\u8d25\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
                boolean bl = false;
                return bl;
            }
            logger.debug("\u751f\u6210H2\u8868DDL\uff1a{}", (Object)createTableSql);
            try (Statement stmt = h2Conn.createStatement();){
                stmt.execute("DROP TABLE IF EXISTS " + tableName);
                logger.debug("\u5df2\u5220\u9664\u65e7\u8868\uff08\u82e5\u5b58\u5728\uff09\uff1a{}", (Object)tableName);
                stmt.execute(createTableSql);
                logger.debug("\u6210\u529f\u521b\u5efaH2\u8868\uff1a{}", (Object)tableName);
            }
            boolean insertSuccess = EnhanceSqlEngine.batchInsertData(h2Conn, tableName, rs);
            if (!insertSuccess) {
                logger.error("\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0c\u6267\u884c\u56de\u6eda\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
                h2Conn.rollback();
                boolean e = false;
                return e;
            }
            logger.debug("\u6570\u636e\u63d2\u5165\u6210\u529f\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
            PreparedStatement pstmt = h2Conn.prepareStatement(sql);
            ResultSet h2Rs = pstmt.executeQuery();
            logger.debug("\u6267\u884cH2\u67e5\u8be2SQL\uff1a{}", (Object)sql);
            boolean processResult = resultSetHandler.process(h2Rs);
            h2Conn.commit();
            logger.debug("\u67e5\u8be2\u5904\u7406\u5b8c\u6210\uff0c\u63d0\u4ea4\u4e8b\u52a1\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
            boolean bl = processResult;
            return bl;
        }
        catch (SQLException e) {
            logger.error("\u6267\u884c\u4e8c\u6b21\u67e5\u8be2\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u540d\uff1a{}\uff0cSQL\uff1a{}", new Object[]{tableName, sql, e});
            if (h2Conn != null) {
                try {
                    h2Conn.rollback();
                    logger.warn("\u4e8b\u52a1\u5df2\u56de\u6eda\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
                }
                catch (SQLException ex) {
                    logger.error("\u56de\u6eda\u4e8b\u52a1\u5931\u8d25\uff0c\u8868\u540d\uff1a{}", (Object)tableName, (Object)ex);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try (Statement stmt = h2Conn.createStatement();){
                stmt.execute("DROP TABLE IF EXISTS " + tableName);
                logger.debug("\u5df2\u5220\u9664\u8868\uff08\u82e5\u5b58\u5728\uff09\uff1a{}", (Object)tableName);
                h2Conn.commit();
            }
            catch (SQLException e) {
                logger.error("\u5220\u9664\u8868\u5931\u8d25\uff0c\u8868\u540d\uff1a{}", (Object)tableName, (Object)e);
            }
            logger.debug("\u4e8c\u6b21\u67e5\u8be2\u6d41\u7a0b\u7ed3\u675f\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
        }
    }

    private static Connection getH2Connection() throws SQLException {
        logger.debug("\u5f00\u59cb\u83b7\u53d6H2\u8fde\u63a5\uff0cURL\uff1a{}\uff0c\u7528\u6237\uff1a{}", (Object)H2_URL, (Object)H2_USER);
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL(H2_URL);
        dataSource.setUser(H2_USER);
        dataSource.setPassword(H2_PASSWORD);
        Connection conn = dataSource.getConnection();
        logger.debug("H2\u8fde\u63a5\u83b7\u53d6\u6210\u529f");
        return conn;
    }

    private static String generateCreateTableSql(DbType dbType, String tableName, String desc, ResultSetMetaData metaData) throws SQLException {
        logger.debug("\u5f00\u59cb\u751f\u6210DDL\uff0c\u8868\u540d\uff1a{}\uff0c\u5217\u6570\uff1a{}", (Object)tableName, (Object)metaData.getColumnCount());
        if (tableName == null || tableName.trim().isEmpty()) {
            logger.error("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE ").append(tableName).append(" (");
        int columnCount = metaData.getColumnCount();
        ArrayList<String> columnDefinitions = new ArrayList<String>();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = EnhanceSqlEngine.genColumnName(i);
            int jdbcType = DbTypeSerializeUtil.getColumnType(metaData, i);
            String columnType = EnhanceSqlEngine.getH2Type(dbType, jdbcType, metaData.getColumnDisplaySize(i));
            StringBuilder columnDef = new StringBuilder();
            columnDef.append(columnName).append(" ").append(columnType);
            columnDefinitions.add(columnDef.toString());
            logger.trace("\u751f\u6210\u5217\u5b9a\u4e49\uff1a{}", (Object)columnDef);
        }
        ddl.append(String.join((CharSequence)", ", columnDefinitions));
        ddl.append(")");
        logger.debug("DDL\u751f\u6210\u5b8c\u6210\uff0c\u8868\u540d\uff1a{}", (Object)tableName);
        return ddl.toString();
    }

    private static String genColumnName(int i) {
        return "c" + i;
    }

    private static String getH2Type(DbType dbType, int jdbcType, int columnSize) {
        String h2Type;
        switch (jdbcType) {
            case 4: {
                h2Type = "INT";
                break;
            }
            case -5: {
                h2Type = "BIGINT";
                break;
            }
            case 5: {
                h2Type = "SMALLINT";
                break;
            }
            case -6: {
                h2Type = "TINYINT";
                break;
            }
            case 6: 
            case 7: {
                h2Type = "FLOAT";
                break;
            }
            case 8: {
                h2Type = "DOUBLE";
                break;
            }
            case 2: 
            case 3: {
                h2Type = "DECIMAL(38,5)";
                break;
            }
            case -1: 
            case 12: {
                h2Type = "VARCHAR(65535)";
                break;
            }
            case 1: {
                h2Type = "CHAR(" + (columnSize > 0 ? columnSize : 1) + ")";
                break;
            }
            case -15: 
            case -9: {
                h2Type = jdbcType == -9 ? "VARCHAR(65535)" : "CHAR(" + (columnSize > 0 ? columnSize : 1) + ")";
                break;
            }
            case 91: {
                h2Type = "TIMESTAMP";
                break;
            }
            case 92: {
                h2Type = "TIME";
                break;
            }
            case 93: {
                if (dbType == DbType.POSTGRESQL || dbType == DbType.ORACLE) {
                    h2Type = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                h2Type = "TIMESTAMP";
                break;
            }
            case 2014: {
                h2Type = "TIMESTAMP WITH TIME ZONE";
                break;
            }
            case 16: {
                h2Type = "BOOLEAN";
                break;
            }
            case 2004: {
                h2Type = "BLOB";
                break;
            }
            case 2005: 
            case 2011: {
                h2Type = "CLOB";
                break;
            }
            default: {
                logger.warn("\u672a\u5339\u914d\u5230JDBC\u7c7b\u578b[{}]\uff0c\u4f7f\u7528\u9ed8\u8ba4VARCHAR\u7c7b\u578b", (Object)jdbcType);
                h2Type = "VARCHAR(255)";
            }
        }
        return h2Type;
    }

    private static boolean batchInsertData(Connection conn, String tableName, ResultSet rs) throws SQLException {
        boolean bl;
        block16: {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            logger.debug("\u5f00\u59cb\u6279\u91cf\u63d2\u5165\u6570\u636e\uff0c\u8868\u540d\uff1a{}\uff0c\u5217\u6570\uff1a{}", (Object)tableName, (Object)columnCount);
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO ").append(tableName).append(" (");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> placeholders = new ArrayList<String>();
            for (int i = 1; i <= columnCount; ++i) {
                columns.add(EnhanceSqlEngine.genColumnName(i));
                placeholders.add("?");
            }
            insertSql.append(String.join((CharSequence)", ", columns)).append(") VALUES (").append(String.join((CharSequence)", ", placeholders)).append(")");
            logger.trace("\u63d2\u5165SQL\uff1a{}", (Object)insertSql);
            PreparedStatement pstmt = conn.prepareStatement(insertSql.toString());
            try {
                int batchSize = 1000;
                int count = 0;
                int total = 0;
                while (rs.next()) {
                    for (int i = 1; i <= columnCount; ++i) {
                        MultiQueryResultDTO queryResultDTO = MultiJdbcUtils.MultiQueryResultDTO.get();
                        try {
                            Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(queryResultDTO.getTraceId(), queryResultDTO.getMultiQuerySql(), rs, metaData, i, DbType.valueOf(queryResultDTO.getTargetDialect()));
                            if (93 == metaData.getColumnType(i) && value instanceof Long) {
                                value = new Timestamp((Long)value);
                            }
                            if (value instanceof BigDecimal) {
                                BigDecimal tmp = (BigDecimal)value;
                                value = tmp.setScale(5, 1);
                            }
                            pstmt.setObject(i, value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to read column value", e);
                        }
                    }
                    pstmt.addBatch();
                    ++total;
                    if (++count % batchSize != 0) continue;
                    pstmt.executeBatch();
                    conn.commit();
                    logger.debug("\u6279\u91cf\u63d2\u5165\u5df2\u63d0\u4ea4 {} \u6761\u6570\u636e\uff0c\u8868\u540d\uff1a{}", (Object)total, (Object)tableName);
                    count = 0;
                }
                if (count > 0) {
                    pstmt.executeBatch();
                    conn.commit();
                }
                logger.info("\u6570\u636e\u63d2\u5165\u5b8c\u6210\uff0c\u5171\u63d2\u5165 {} \u6761\u8bb0\u5f55\uff0c\u8868\u540d\uff1a{}", (Object)total, (Object)tableName);
                bl = true;
                if (pstmt == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c\u8868\u540d\uff1a{}", (Object)tableName, (Object)e);
                    throw e;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    private static String escapeSql(String value) {
        if (value == null) {
            return H2_PASSWORD;
        }
        String escaped = value.replace("'", "''");
        if (!escaped.equals(value)) {
            logger.trace("SQL\u5b57\u7b26\u4e32\u8f6c\u4e49\uff1a\u539f\u5b57\u7b26\u4e32[{}] -> \u8f6c\u4e49\u540e[{}]", (Object)value, (Object)escaped);
        }
        return escaped;
    }
}

