/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.multijdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import com.hundsun.lightdb.unisql.utils.UnisqlCommonUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class MultiPreparedStatement
implements PreparedStatement {
    private static Logger log = LoggerFactory.getLogger(MultiPreparedStatement.class);
    private Connection nativeConnection;
    private final PreparedStatement delegate;
    private final List<UnisqlPreparedStatement> delegateMulti;
    private final Set<DbType> multiDbTypes;
    private final ConnectionInfoDTO dataBaseInfo;
    private String preparedSql;
    private DbType sourceDbType;
    private String sourceDbName;
    private final UnisqlProperties properties = UnisqlProperties.getInstance();
    private final boolean debug = UnisqlProperties.getInstance().isDebug();
    protected final TreeMap<Integer, PreparedParameter> comparePreparedBindingVariables;

    public MultiPreparedStatement(Connection nativeConnection, PreparedStatement delegate, List<UnisqlPreparedStatement> delegateMulti, String sql, DbType sourceDbType, String sourceDbName, Set<DbType> multiDbTypes, ConnectionInfoDTO dataBaseInfo) {
        this.nativeConnection = nativeConnection;
        this.preparedSql = sql;
        this.delegate = delegate;
        this.delegateMulti = delegateMulti;
        this.comparePreparedBindingVariables = new TreeMap();
        this.sourceDbType = sourceDbType;
        this.sourceDbName = sourceDbName;
        this.multiDbTypes = multiDbTypes;
        this.dataBaseInfo = dataBaseInfo;
    }

    public PreparedStatement getDelegate() {
        return this.delegate;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        boolean execute = this.execute();
        if (!execute) {
            throw new SQLException("SQL\u672a\u8fd4\u56de\u4efb\u4f55\u67e5\u8be2\u7ed3\u679c\u96c6");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        boolean execute = this.execute();
        if (execute) {
            throw new SQLException("SQL\u8fd4\u56de\u672a\u903e\u671f\u7684\u67e5\u8be2\u7ed3\u679c\u96c6");
        }
        return this.getUpdateCount();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNull(parameterIndex, sqlType);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setNull", parameterIndex, null, sqlType);
        this.delegate.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBoolean(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setBoolean(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBoolean", parameterIndex, x, 16);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setByte(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setByte(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setByte", parameterIndex, x, -6);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setShort(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setShort(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setShort", parameterIndex, x, 5);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setInt(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setInt(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setInt", parameterIndex, x, 4);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setLong(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setLong(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setLong", parameterIndex, x, -5);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setFloat(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setFloat(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setFloat", parameterIndex, Float.valueOf(x), 6);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setDouble(parameterIndex, x);
            }
            catch (SQLException e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setDouble(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setDouble", parameterIndex, x, 8);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBigDecimal(parameterIndex, x);
            }
            catch (SQLException e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setBigDecimal(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBigDecimal", parameterIndex, x, 3);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setString(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setString(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setString", parameterIndex, x, 12);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBytes(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setBytes(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setBytes", parameterIndex, x, -2);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setDate(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setDate(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setDate", parameterIndex, x, 91);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setTime(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setTime(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setTime", parameterIndex, x, 92);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setTimestamp(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setTimestamp(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setTimestamp", parameterIndex, x, 93);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setAsciiStream(parameterIndex, x, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1asetAsciiStream(int parameterIndex, InputStream x, int length) ");
        }
        this.delegate.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setUnicodeStream(parameterIndex, x, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setUnicodeStream(int parameterIndex, InputStream x, int length)");
        }
        this.delegate.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBinaryStream(parameterIndex, x, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setBinaryStream(int parameterIndex, InputStream x, int length)");
        }
        this.delegate.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.clearParameters();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setObject(parameterIndex, x, targetSqlType);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setObject(int parameterIndex, Object x, int targetSqlType)");
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setObject(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setObject(parameterIndex, x);
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setObject", parameterIndex, x, 2000);
    }

    public boolean executeByTraceId(String traceId) throws SQLException {
        MultiQueryResultDTO multiQueryResult = MultiplexContext.createMultiQueryResult(traceId, this.sourceDbType, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
        String fullSql = MultiplexContext.buildFullSql(this.preparedSql, this.getPreparedParameters(), multiQueryResult);
        multiQueryResult.setBizSql(this.preparedSql);
        multiQueryResult.setTransformedBizSql(this.preparedSql);
        multiQueryResult.setRawBizBindVarReplacedSql(fullSql);
        multiQueryResult.setBizBindVarReplacedSql(fullSql);
        return MultiplexContext.executePreparedMultiplex(this.nativeConnection, this.delegate, this.delegateMulti, multiQueryResult);
    }

    @Override
    public boolean execute() throws SQLException {
        String traceId = MultiplexContext.setRealMultiplexTraceId();
        return this.executeByTraceId(traceId);
    }

    @Override
    public void addBatch() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.addBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setCharacterStream(parameterIndex, reader, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setCharacterStream(int parameterIndex, Reader reader, int length)");
        }
        this.delegate.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setRef(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setRef(int parameterIndex, Ref x)");
        }
        this.delegate.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBlob(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setBlob(parameterIndex, x);
        if (Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setBlob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(Utils.blobToByteArrayOutputStream(x))).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setClob(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setClob(parameterIndex, x);
        if (Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setClob").parameterIndex(parameterIndex).x(Utils.byteArrayOutputStreamToBase64(Utils.clobToByteArrayOutputStream(x))).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setArray(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setArray(parameterIndex, x);
        if (Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                 ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(x.getArray());
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setArray").parameterIndex(parameterIndex).x(Base64.getEncoder().encodeToString(byteArray)).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getMetaData();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setDate(parameterIndex, x, cal);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setDate(int parameterIndex, Date x, Calendar cal)");
        }
        this.delegate.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setTime(parameterIndex, x, cal);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setTime(int parameterIndex, Time x, Calendar cal)");
        }
        this.delegate.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, UnisqlPreparedStatement.convertToRegularTimestamp(x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNull(parameterIndex, sqlType, typeName);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setNull(int parameterIndex, int sqlType, String typeName)");
        }
        this.delegate.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setURL(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setURL(int parameterIndex, URL x)");
        }
        this.delegate.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getParameterMetaData();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setRowId(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setRowId(int parameterIndex, RowId x)");
        }
        this.delegate.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNString(parameterIndex, value);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        MultiplexContext.collectPreparedParameter(this.comparePreparedBindingVariables, "setNString", parameterIndex, value, -9);
        this.delegate.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNCharacterStream(parameterIndex, value, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNClob(parameterIndex, value);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setNClob(parameterIndex, value);
        if (Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            try {
                PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNClob").parameterIndex(parameterIndex).x(Utils.clobToByteArrayOutputStream(value)).base64Flag(true).build();
                this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new SQLException(ErrorMessages.format(ErrorMessages.LTU0007, parameterIndex, e.getMessage()));
            }
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setClob(parameterIndex, reader, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setClob(int parameterIndex, Reader reader, long length)");
        }
        this.delegate.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBlob(parameterIndex, inputStream, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setBlob(int parameterIndex, InputStream inputStream, long length)");
        }
        this.delegate.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNClob(parameterIndex, reader, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setNClob(int parameterIndex, Reader reader, long length)");
        }
        this.delegate.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setSQLXML(parameterIndex, xmlObject);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setSQLXML(int parameterIndex, SQLXML xmlObject)");
        }
        this.delegate.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength)");
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setAsciiStream(parameterIndex, x, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setAsciiStream(int parameterIndex, InputStream x, long length)");
        }
        this.delegate.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBinaryStream(parameterIndex, x, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setBinaryStream(int parameterIndex, InputStream x, long length)");
        }
        this.delegate.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setCharacterStream(parameterIndex, reader, length);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setCharacterStream(int parameterIndex, Reader reader, long length)");
        }
        this.delegate.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setAsciiStream(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setAsciiStream(int parameterIndex, InputStream x");
        }
        this.delegate.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBinaryStream(parameterIndex, x);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setBinaryStream(int parameterIndex, InputStream x)");
        }
        this.delegate.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(value);
        String strValue = byteArrayOutputStream.toString();
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setString(parameterIndex, strValue);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setString(parameterIndex, strValue);
        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setCharacterStream").parameterIndex(parameterIndex).x(strValue).vendorTypeNumber(12).build();
        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = UnisqlCommonUtils.copyReaderToByteArrayOutputStream(value);
        String strValue = byteArrayOutputStream.toString();
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setString(parameterIndex, strValue);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setString(parameterIndex, strValue);
        PreparedParameter preparedParameter = PreparedParameter.builder().methodName("setNCharacterStream").parameterIndex(parameterIndex).x(strValue).vendorTypeNumber(12).build();
        this.comparePreparedBindingVariables.put(parameterIndex, preparedParameter);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setClob(parameterIndex, reader);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setClob(int parameterIndex, Reader reader)");
        }
        this.delegate.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setBlob(parameterIndex, inputStream);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setBlob(int parameterIndex, InputStream inputStream)");
        }
        this.delegate.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setNClob(parameterIndex, reader);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setNClob(int parameterIndex, Reader reader)");
        }
        this.delegate.setNClob(parameterIndex, reader);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setObject(parameterIndex, x, targetSqlType);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setObject(int parameterIndex, Object x, SQLType targetSqlType)");
        }
        this.delegate.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeUpdate();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeLargeUpdate();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeQuery(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeQuery(sql);
            }
            catch (SQLException e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteQuery(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                int result = preparedStatement.executeUpdate(sql);
                if (!log.isDebugEnabled()) continue;
                log.debug("multi preparedStatement executeUpdate result is {}", (Object)result);
            }
            catch (Exception e) {
                log.error("\u591a\u53d1\u76ee\u6807\u5e93executeUpdate\u5931\u8d25 [{}]", (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.close();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getMaxFieldSize();
            }
            catch (SQLException e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setMaxFieldSize(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getMaxRows();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setMaxRows(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setEscapeProcessing(enable);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setQueryTimeout(seconds);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.cancel();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getWarnings();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.clearWarnings();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setCursorName(name);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5c06\u9884\u7f16\u8bd1\u53c2\u6570\u6536\u96c6\u5230 comparePreparedBindingVariables \u53d8\u91cf\u4e2d\u505aSQL\u8fd8\u539f\uff0c\u540e\u7eed\u4f1a\u652f\u6301\uff0c\u65b9\u6cd5\u7b7e\u540d\u4e3a\uff1a setCursorName(String name)");
        }
        this.delegate.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                boolean execute = preparedStatement.execute(sql);
                if (!log.isDebugEnabled()) continue;
                log.debug("multi preparedStatement execute result is {}", (Object)execute);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getResultSet();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getUpdateCount();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getMoreResults();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setFetchDirection(direction);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getFetchDirection();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setFetchSize(rows);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getFetchSize();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getResultSetConcurrency();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getResultSetType();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.addBatch(sql);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.clearBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getConnection();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getMoreResults(current);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getGeneratedKeys();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeUpdate(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        int executeUpdate = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return executeUpdate;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeUpdate(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeUpdate(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.execute(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        boolean execute = this.delegate.execute(sql, autoGeneratedKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return execute;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.execute(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.execute(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        boolean execute = this.delegate.execute(sql, columnNames);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecute(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return execute;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getResultSetHoldability();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.isClosed();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setPoolable(poolable);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.isPoolable();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.closeOnCompletion();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.isCloseOnCompletion();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getLargeUpdateCount();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.setLargeMaxRows(max);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        this.delegate.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.getLargeMaxRows();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeBatch();
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        long[] longs = this.delegate.executeLargeBatch();
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeBatch() traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return longs;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeUpdate(sql);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeUpdate(sql, autoGeneratedKeys);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, int autoGeneratedKeys) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return this.delegate.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeUpdate(sql, columnIndexes);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql, columnIndexes);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, int[] columnIndexes) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165executeLargeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.executeLargeUpdate(sql, columnNames);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        if (log.isDebugEnabled()) {
            log.info("\u6e90\u5e93\u5f53\u524d\u672a\u652f\u6301\u6bd4\u5bf9");
        }
        long largeUpdate = this.delegate.executeLargeUpdate(sql, columnNames);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u9000\u51faexecuteLargeUpdate(String sql, String[] columnNames) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        return largeUpdate;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.unwrap(iface);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        for (PreparedStatement preparedStatement : this.delegateMulti) {
            try {
                preparedStatement.isWrapperFor(iface);
            }
            catch (Exception e) {
                log.error("\u76ee\u6807\u5e93\u6267\u884c\u5931\u8d25 traceId [{}] \u5f02\u5e38\u4fe1\u606f [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)ExceptionUtils.getStackTrace(e));
            }
        }
        return this.delegate.isWrapperFor(iface);
    }

    public List<PreparedParameter> getPreparedParameters() {
        Collection<PreparedParameter> values = this.comparePreparedBindingVariables.values();
        ArrayList<PreparedParameter> preparedParameters = new ArrayList<PreparedParameter>(values);
        return preparedParameters;
    }

    private void clearResoures(Statement currStat) throws SQLException {
        if (currStat != null) {
            currStat.close();
        }
        if (this.comparePreparedBindingVariables != null && this.comparePreparedBindingVariables.size() > 0) {
            this.comparePreparedBindingVariables.clear();
        }
    }
}

