/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.multijdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlConnection;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlStatement;
import com.hundsun.lightdb.unisql.proxy.multijdbc.MultiPreparedStatement;
import com.hundsun.lightdb.unisql.proxy.multijdbc.MultiStatement;
import com.hundsun.lightdb.unisql.utils.UnisqlCommonUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class MultiConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(MultiConnection.class);
    private final Connection delegate;
    private final List<UnisqlConnection> delegateMulti;
    private final Set<DbType> multiDbTypes;
    private final ConnectionInfoDTO dataBaseInfo;
    private DbType sourceDbType;
    private String sourceDbName;
    private String mark;

    public ConnectionInfoDTO getConnectionInfo() {
        return this.dataBaseInfo;
    }

    public MultiConnection(Connection delegate, List<UnisqlConnection> delegateMulti, DbType sourceDbType, String sourceDbName, Set<DbType> multiDbTypes, ConnectionInfoDTO dataBaseInfo) {
        this.delegate = delegate;
        this.delegateMulti = delegateMulti;
        this.sourceDbType = sourceDbType;
        this.sourceDbName = sourceDbName;
        this.multiDbTypes = multiDbTypes;
        this.dataBaseInfo = dataBaseInfo;
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public List<UnisqlConnection> getDelegateMulti() {
        return this.delegateMulti;
    }

    public Set<DbType> getMultiDbTypes() {
        return this.multiDbTypes;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("=====MultiConnection  createStatement======");
        }
        ArrayList<UnisqlStatement> unisqlStatements = new ArrayList<UnisqlStatement>();
        for (UnisqlConnection unisqlConnection : this.delegateMulti) {
            unisqlStatements.add(unisqlConnection.createStatement());
        }
        return new MultiStatement(this.delegate, this.delegate.createStatement(), unisqlStatements, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("=====MultiConnection  prepareStatement======");
        }
        MultiplexContext.setRealMultiplexTraceId();
        PreparedStatement sourcePrepared = null;
        try {
            String semiTrimmedSql = UnisqlCommonUtils.trimEndsWithSemicolon(sql);
            sourcePrepared = this.delegate.prepareStatement(semiTrimmedSql);
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u6e90\u7aef[{}]\u591a\u53d1\u9884\u7f16\u8bd1\u5931\u8d25\uff0csql[{}]", (Object)this.sourceDbType, (Object)sql);
            }
            throw new RuntimeException(String.format("\u6e90\u7aef[%s]\u591a\u53d1\u9884\u7f16\u8bd1\u5931\u8d25\uff0csql[%s]\uff0c%s", new Object[]{this.sourceDbType, sql, ExceptionUtils.getStackTrace(e)}));
        }
        ArrayList<UnisqlPreparedStatement> unisqlPreparedStatements = new ArrayList<UnisqlPreparedStatement>();
        for (UnisqlConnection unisqlConnection : this.delegateMulti) {
            try {
                unisqlPreparedStatements.add(unisqlConnection.prepareStatement(sql));
            }
            catch (Exception e) {
                UnisqlConnection connection = unisqlConnection;
                if (logger.isErrorEnabled()) {
                    logger.error("\u6e90\u7aef[{}]\u5230\u76ee\u6807\u7aef[{}]\u591a\u53d1\u9884\u7f16\u8bd1\u5931\u8d25\uff0csql[{}]", new Object[]{connection.getSourceDialect(), connection.getTargetDialect(), sql});
                }
                throw new RuntimeException(String.format("\u6e90\u7aef[%s]\u5230\u76ee\u6807\u7aef[%s]\u591a\u53d1\u9884\u7f16\u8bd1\u5931\u8d25\uff0c%s", new Object[]{connection.getSourceDialect(), connection.getTargetDialect(), ExceptionUtils.getStackTrace(e)}));
            }
        }
        return new MultiPreparedStatement(this.delegate, sourcePrepared, unisqlPreparedStatements, sql, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.delegate.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (logger.isDebugEnabled() && !autoCommit) {
            this.mark = UUID.randomUUID().toString().replace("-", "");
            logger.debug("\u5f00\u542f\u4e8b\u52a1 [{}] [{}]", (Object)this.mark, (Object)System.currentTimeMillis());
        }
        for (Connection connection : this.delegateMulti) {
            connection.setAutoCommit(autoCommit);
        }
        this.delegate.setAutoCommit(autoCommit);
        if (logger.isDebugEnabled() && autoCommit) {
            logger.debug("\u5173\u95ed\u4e8b\u52a1 [{}] [{}]", (Object)this.mark, (Object)System.currentTimeMillis());
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            boolean bl = connection.getAutoCommit();
        }
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.commit();
        }
        this.delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.rollback();
        }
        this.delegate.rollback();
    }

    @Override
    public void close() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            if (connection.isClosed()) continue;
            connection.close();
        }
        if (!this.delegate.isClosed()) {
            this.delegate.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean closed = false;
        for (Connection connection : this.delegateMulti) {
            closed |= connection.isClosed();
        }
        return closed |= this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setReadOnly(readOnly);
        }
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            boolean bl = connection.isReadOnly();
        }
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setCatalog(catalog);
        }
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setTransactionIsolation(level);
        }
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.clearWarnings();
        }
        this.delegate.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ArrayList<UnisqlStatement> statementList = new ArrayList<UnisqlStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.createStatement(resultSetType, resultSetConcurrency));
        }
        return new MultiStatement(this.delegate, this.delegate.createStatement(resultSetType, resultSetConcurrency), statementList, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ArrayList<UnisqlPreparedStatement> statementList = new ArrayList<UnisqlPreparedStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        return new MultiPreparedStatement(this.delegate, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency), statementList, sql, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.getTypeMap();
        }
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setTypeMap(map);
        }
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setHoldability(holdability);
        }
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.rollback(savepoint);
        }
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.releaseSavepoint(savepoint);
        }
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ArrayList<UnisqlStatement> statementList = new ArrayList<UnisqlStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        return new MultiStatement(this.delegate, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), statementList, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ArrayList<UnisqlPreparedStatement> statementList = new ArrayList<UnisqlPreparedStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        return new MultiPreparedStatement(this.delegate, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), statementList, sql, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ArrayList<UnisqlPreparedStatement> statementList = new ArrayList<UnisqlPreparedStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.prepareStatement(sql, autoGeneratedKeys));
        }
        return new MultiPreparedStatement(this.delegate, this.delegate.prepareStatement(sql, autoGeneratedKeys), statementList, sql, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ArrayList<UnisqlPreparedStatement> statementList = new ArrayList<UnisqlPreparedStatement>();
        for (UnisqlConnection connection : this.delegateMulti) {
            statementList.add(connection.prepareStatement(sql, columnIndexes));
        }
        return new MultiPreparedStatement(this.delegate, this.delegate.prepareStatement(sql, columnIndexes), statementList, sql, this.sourceDbType, this.sourceDbName, this.multiDbTypes, this.dataBaseInfo);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ArrayList<PreparedStatement> statementList = new ArrayList<PreparedStatement>();
        for (Connection connection : this.delegateMulti) {
            statementList.add(connection.prepareStatement(sql, columnNames));
        }
        return this.delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createClob();
        }
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createBlob();
        }
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createNClob();
        }
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createSQLXML();
        }
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean valid = this.delegate.isValid(timeout);
        if (valid) {
            for (Connection connection : this.delegateMulti) {
                if (connection.isValid(timeout)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        for (Connection connection : this.delegateMulti) {
            connection.setClientInfo(name, value);
        }
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (Connection connection : this.delegateMulti) {
            connection.setClientInfo(properties);
        }
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.getClientInfo(name);
        }
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.getClientInfo();
        }
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createArrayOf(typeName, elements);
        }
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.createArrayOf(typeName, attributes);
        }
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setSchema(schema);
        }
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.getSchema();
        }
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.abort(executor);
        }
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.setNetworkTimeout(executor, milliseconds);
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.getNetworkTimeout();
        }
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.unwrap(iface);
        }
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        for (Connection connection : this.delegateMulti) {
            connection.isWrapperFor(iface);
        }
        return this.delegate.isWrapperFor(iface);
    }
}

