/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import java.util.Objects;
import java.util.Properties;

public class JdbcProperties {
    private String url;
    private String sourceDialect;
    private String targetDialect;
    private String schemaName;
    private Properties properties;

    public JdbcProperties(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    public JdbcProperties() {
    }

    public JdbcProperties copy() {
        JdbcProperties newJdbcProperties = new JdbcProperties();
        newJdbcProperties.setUrl(this.getUrl());
        newJdbcProperties.setSourceDialect(this.getSourceDialect());
        newJdbcProperties.setTargetDialect(this.getTargetDialect());
        newJdbcProperties.setSchemaName(this.getSchemaName());
        newJdbcProperties.setProperties(this.getProperties());
        return newJdbcProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcProperties that = (JdbcProperties)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.properties);
    }

    public String getUrl() {
        return this.url;
    }

    public String getSourceDialect() {
        return this.sourceDialect;
    }

    public String getTargetDialect() {
        return this.targetDialect;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSourceDialect(String sourceDialect) {
        this.sourceDialect = sourceDialect;
    }

    public void setTargetDialect(String targetDialect) {
        this.targetDialect = targetDialect;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "JdbcProperties(url=" + this.getUrl() + ", sourceDialect=" + this.getSourceDialect() + ", targetDialect=" + this.getTargetDialect() + ", schemaName=" + this.getSchemaName() + ", properties=" + this.getProperties() + ")";
    }
}

