/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.IGoParser;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.jnr.ffi.LibraryLoader;
import shaded.jnr.ffi.Platform;
import shaded.jnr.ffi.Pointer;

public class GoParserFactory {
    private static final IGoParser INSTANCE;
    private static final Logger log;

    private static boolean windowsVersionIsSupported() {
        return !SystemUtils.IS_OS_WINDOWS_7 && !SystemUtils.IS_OS_WINDOWS_8 && !SystemUtils.IS_OS_WINDOWS_VISTA;
    }

    private static String getDynamicLibraryName(boolean isDebugLibrary) throws Exception {
        String dynamicLibraryFileSuffix;
        Platform platform = Platform.getNativePlatform();
        String osName = "";
        switch (platform.getOS()) {
            case LINUX: {
                osName = "linux";
                dynamicLibraryFileSuffix = "so";
                break;
            }
            case WINDOWS: {
                osName = "windows";
                dynamicLibraryFileSuffix = "dll";
                break;
            }
            case DARWIN: {
                osName = "mac";
                dynamicLibraryFileSuffix = "dylib";
                break;
            }
            default: {
                throw new Exception(String.format(ErrorMessages.LTU0002.getMsg(), new Object[]{platform.getOS()}));
            }
        }
        String arch = "";
        switch (platform.getCPU()) {
            case AARCH64: {
                arch = "aarch64";
                break;
            }
            case X86_64: {
                arch = "x86_64";
                break;
            }
            default: {
                throw new Exception(String.format(ErrorMessages.LTU0003.getMsg(), platform.getName()));
            }
        }
        if (platform.getOS() == Platform.OS.WINDOWS) {
            if (!GoParserFactory.windowsVersionIsSupported()) {
                throw new Exception(String.format(ErrorMessages.LTU0002.getMsg(), "\u4e0d\u652f\u6301\u4f4e\u4e8ewin10\u7684\u64cd\u4f5c\u7cfb\u7edf"));
            }
            if (isDebugLibrary) {
                return String.format("unisql.%s.debug.%s", osName, dynamicLibraryFileSuffix);
            }
            return String.format("unisql.%s.%s", osName, dynamicLibraryFileSuffix);
        }
        if (isDebugLibrary) {
            return String.format("unisql.%s.%s.debug.%s", osName, arch, dynamicLibraryFileSuffix);
        }
        return String.format("unisql.%s.%s.%s", osName, arch, dynamicLibraryFileSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findDynamicLibrary(String dynamicLibraryName) throws Exception {
        String libPath;
        UnisqlProperties properties = UnisqlProperties.getInstance();
        String fullPath = properties.getLibFullPath();
        log.info("\u8bfb\u53d6 unisql.lib.full-path \u914d\u7f6e\u503c [{}]", (Object)fullPath);
        if (StringUtils.isNotBlank(fullPath)) {
            File file = new File(fullPath);
            log.info("\u83b7\u53d6 unisql.lib.full-path \u7edd\u5bf9\u8def\u5f84 [{}]", (Object)file.getAbsolutePath());
            if (!file.exists()) {
                log.error("\u94fe\u63a5\u5e93\u4e0d\u5b58\u5728 [{}]", (Object)fullPath);
                throw new Exception(String.format(ErrorMessages.LTU0001.getMsg(), fullPath));
            }
            return file.getAbsolutePath();
        }
        InputStream in = GoParserFactory.class.getClassLoader().getResourceAsStream(dynamicLibraryName);
        if (in != null) {
            Path tmpFile;
            try {
                int bufferSize = 8192;
                byte[] buffer = new byte[8192];
                Path tmpDir = Files.createTempDirectory("unisql_lib", new FileAttribute[0]);
                tmpDir.toFile().deleteOnExit();
                tmpFile = tmpDir.resolve(dynamicLibraryName);
                try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                    int bytesRead;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                tmpFile.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new Exception(String.format(ErrorMessages.LTU0001.getMsg(), dynamicLibraryName));
            }
            libPath = tmpFile.toAbsolutePath().toString();
            log.info("\u4ecejar\u5305\u4e2d\u8bfb\u53d6\u94fe\u63a5\u5e93\u8def\u5f84 [{}]", (Object)libPath);
        } else {
            String configDir = properties.getLibDir();
            log.info("\u8bfb\u53d6 unisql.lib.dir \u914d\u7f6e\u503c: {}", (Object)configDir);
            Path path = Paths.get(configDir, dynamicLibraryName);
            if (Files.notExists(path, new LinkOption[0])) {
                String tempDir = System.getProperty("java.io.tmpdir");
                log.info("\u8bfb\u53d6 java.io.tmpdir \u914d\u7f6e\u503c: {}", (Object)tempDir);
                path = Paths.get(tempDir, dynamicLibraryName);
                if (Files.notExists(path, new LinkOption[0])) {
                    return "";
                }
            }
            libPath = path.toAbsolutePath().toString();
            log.info("\u4ece\u914d\u7f6e\u76ee\u5f55\u4e2d\u8bfb\u53d6\u94fe\u63a5\u5e93\u8def\u5f84 [{}]", (Object)libPath);
        }
        return libPath;
    }

    public static IGoParser getGoParser() {
        return INSTANCE;
    }

    public static void main(String[] args) {
        System.out.println(SystemUtils.OS_VERSION);
    }

    static {
        log = LoggerFactory.getLogger(GoParserFactory.class);
        String libraryPath = "";
        try {
            String dynamicLibraryName = GoParserFactory.getDynamicLibraryName(false);
            libraryPath = GoParserFactory.findDynamicLibrary(dynamicLibraryName);
            log.info("release \u94fe\u63a5\u5e93\u8def\u5f84 [{}]", (Object)libraryPath);
            if (libraryPath.isEmpty()) {
                dynamicLibraryName = GoParserFactory.getDynamicLibraryName(true);
                libraryPath = GoParserFactory.findDynamicLibrary(dynamicLibraryName);
                log.info("debug \u94fe\u63a5\u5e93\u8def\u5f84 [{}]", (Object)libraryPath);
            }
            if (libraryPath.isEmpty()) {
                throw new RuntimeException("unisql\u52a8\u6001\u94fe\u63a5\u5e93\u672a\u627e\u5230\uff0c\u8bf7\u901a\u8fc7\u7edf\u4e00SQL\u914d\u7f6e\u6587\u4ef6unisql.conf\u914d\u7f6eunisql.lib.full-path\u53c2\u6570\u6307\u5b9a\u52a8\u6001\u5e93\u4f4d\u7f6e\u6216\u914d\u7f6eunisql.lib.dir\u6307\u5b9a\u52a8\u6001\u5e93\u76ee\u5f55\u3002\u5982\u679c\u662fLinux\u7248\u7edf\u4e00SQL \u901a\u8fc7\u6807\u51c6\u7684Maven\u4f9d\u8d56\u5f15\u5165\uff0c\u5177\u4f53\u53c2\u8003\u7edf\u4e00SQL\u4f7f\u7528\u624b\u518c\u3002");
            }
            log.info("\u52a0\u8f7d\u94fe\u63a5\u5e93\u8def\u5f84 {}", (Object)libraryPath);
            INSTANCE = LibraryLoader.create(IGoParser.class).load(libraryPath);
            String config_path = UnisqlProperties.determineUnisqlConfigPath();
            String options = "";
            if (!StringUtils.isBlank(config_path)) {
                options = "unisql_conf_dir=" + config_path;
            }
            Pointer initResultPointer = INSTANCE.UnisqlInit(options);
            String initResult = initResultPointer.getString(0L, 1024, StandardCharsets.UTF_8);
            INSTANCE.FreePointer(initResultPointer);
            if (!"".equals(initResult)) {
                throw new Exception("\u7edf\u4e00SQL\u521d\u59cb\u5316\u5931\u8d25:" + initResult);
            }
            Transformer.checkVersion();
        }
        catch (Exception e) {
            String loadLibFailed = String.format(ErrorMessages.LTU0001.getMsg(), libraryPath);
            log.error(loadLibFailed, (Throwable)e);
            throw new RuntimeException(loadLibFailed, e);
        }
    }
}

