/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.hundsun.lightdb.unisql.golang.Encoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Decoder {
    private InputStream inputStream;

    public Decoder(byte[] data) {
        this.inputStream = new ByteArrayInputStream(data);
    }

    public int readIntValue() throws IOException {
        byte[] bytes = new byte[4];
        int length = this.inputStream.read(bytes);
        if (length != 4) {
            throw new IOException("read int value error");
        }
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }

    public int readInt() throws IOException {
        int tag = this.readIntValue();
        int type = tag >> 28;
        if (type != 1) {
            throw new IOException("type not int");
        }
        return this.readIntValue();
    }

    public String readString() throws IOException {
        int tag = this.readIntValue();
        int type = tag >> 28;
        if (type != 2) {
            throw new IOException("type not string");
        }
        int length = tag & 0xFFFFFFF;
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        int readLength = this.inputStream.read(bytes);
        if (readLength != length) {
            throw new IOException("read string value error");
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public boolean readBool() throws IOException {
        int tag = this.readIntValue();
        int type = tag >> 28;
        if (type != 3) {
            throw new IOException("type not bool");
        }
        int v = this.inputStream.read();
        if (v != 0 && v != 1) {
            throw new IOException("bool value error");
        }
        return v == 1;
    }

    public List<Integer> readIntArray() throws IOException {
        int tag = this.readIntValue();
        int type = tag >> 28;
        if (type != 5) {
            throw new IOException("type is not int array");
        }
        int length = tag & 0xFFFFFFF;
        if (length == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> intArray = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            intArray.add(this.readIntValue());
        }
        return intArray;
    }

    public long readInt64() throws IOException {
        int tag = this.readIntValue();
        int type = tag >> 28;
        if (type != 6) {
            throw new IOException("type is not int64");
        }
        byte[] bytes = new byte[8];
        int length = this.inputStream.read(bytes);
        if (length != 8) {
            throw new IOException("read int value error");
        }
        return (long)(bytes[0] & 0xFF) | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[7] & 0xFF) << 56;
    }

    public static void main(String[] args) throws IOException {
        Encoder encoder = new Encoder();
        encoder.writeInt(Integer.MIN_VALUE);
        encoder.writeInt(Integer.MAX_VALUE);
        encoder.writeInt(-1);
        encoder.writeInt(0);
        encoder.writeInt(1);
        encoder.writeString("\u5fc3\u6709\u7075\u7280\u4e00\u70b9\u901aabc\u54c8\u54c8\u54c8\u6211\u5f1fsdfwfwewfawefqwefasfasdf\u6f4d\u574a\u5e02\u5426211\u641c\u53d1\u9175\u54e6\u79c1\u53d1\u53cc\u65b9\u52a0\u5f3a\u54e6\u6211IE\u54e6\u4e3aIE\u8985\u8bf7\u95ee\u670d\u52a1\u8d39");
        encoder.writeString("124afqwer");
        encoder.writeBool(true);
        encoder.writeString("\u554a\u662f\u7684\u54e6\u8985\u53eb\u54e6\u989d\u8bf6\u6b27111\u554a\u554a\u554afsdf");
        encoder.writeBool(false);
        encoder.writeInt64(Long.MIN_VALUE);
        encoder.writeInt64(0x7FFFFFFFFFFFFFFEL);
        encoder.writeInt64(-1L);
        encoder.writeInt64(0L);
        encoder.writeInt64(1L);
        encoder.writeInt64(1234567890L);
        byte[] data = encoder.toByteArray();
        Decoder decoder = new Decoder(data);
        int version = decoder.readIntValue();
        if (version != 250201) {
            throw new IOException("version not match");
        }
        int length = decoder.readIntValue();
        System.out.printf("version: %d, length: %d\n", version, length);
        System.out.println(decoder.readInt());
        System.out.println(decoder.readInt());
        System.out.println(decoder.readInt());
        System.out.println(decoder.readInt());
        System.out.println(decoder.readInt());
        System.out.println(decoder.readString());
        System.out.println(decoder.readString());
        System.out.println(decoder.readBool());
        System.out.println(decoder.readString());
        System.out.println(decoder.readBool());
        if (decoder.readInt64() != Long.MIN_VALUE) {
            throw new IOException("int64 not match");
        }
        long value = decoder.readInt64();
        if (value != 0x7FFFFFFFFFFFFFFEL) {
            throw new IOException("int64 not match");
        }
        if (decoder.readInt64() != -1L) {
            throw new IOException("int64 not match");
        }
        if (decoder.readInt64() != 0L) {
            throw new IOException("int64 not match");
        }
        if (decoder.readInt64() != 1L) {
            throw new IOException("int64 not match");
        }
        if (decoder.readInt64() != 1234567890L) {
            throw new IOException("int64 not match");
        }
    }
}

