/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16;
import java.util.Arrays;

abstract class FieldWriterInt16<T>
extends FieldWriterImpl<T> {
    byte[][] utf8ValueCache;
    char[][] utf16ValueCache;
    volatile byte[][] jsonbValueCache;

    FieldWriterInt16(String name, int ordinal, long features, String format, String label, Class fieldClass) {
        super(name, ordinal, features, format, label, fieldClass, fieldClass);
    }

    protected void writeInt16(JSONWriter jsonWriter, short value) {
        boolean writeNonStringValueAsString;
        boolean bl = writeNonStringValueAsString = (jsonWriter.getFeatures() & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (writeNonStringValueAsString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(Short.toString(value));
            return;
        }
        if (jsonWriter.isUTF8()) {
            if (value >= -1 && value < 1039) {
                byte[] bytes = null;
                if (this.utf8ValueCache == null) {
                    this.utf8ValueCache = new byte[1040][];
                } else {
                    bytes = this.utf8ValueCache[value + 1];
                }
                if (bytes == null) {
                    int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                    byte[] original = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars((int)value, bytes.length, bytes);
                    this.utf8ValueCache[value + 1] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
        } else if (jsonWriter.isUTF16()) {
            if (value >= -1 && value < 1039) {
                char[] chars = null;
                if (this.utf16ValueCache == null) {
                    this.utf16ValueCache = new char[1040][];
                } else {
                    chars = this.utf16ValueCache[value + 1];
                }
                if (chars == null) {
                    int size = value < 0 ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
                    char[] original = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + size);
                    chars = Arrays.copyOf(original, original.length);
                    IOUtils.getChars((int)value, chars.length, chars);
                    this.utf16ValueCache[value + 1] = chars;
                }
                jsonWriter.writeNameRaw(chars);
                return;
            }
        } else if (jsonWriter.isJSONB() && value >= -1 && value < 1039) {
            byte[] bytes = null;
            if (this.jsonbValueCache == null) {
                this.jsonbValueCache = new byte[1040][];
            } else {
                bytes = this.jsonbValueCache[value + 1];
            }
            if (bytes == null) {
                if (this.nameJSONB == null) {
                    this.nameJSONB = JSONB.toBytes(this.name);
                }
                byte[] valueBytes = JSONB.toBytes(value);
                bytes = Arrays.copyOf(this.nameJSONB, this.nameJSONB.length + valueBytes.length);
                System.arraycopy(valueBytes, 0, bytes, this.nameJSONB.length, valueBytes.length);
                this.jsonbValueCache[value + 1] = bytes;
            }
            jsonWriter.writeRaw(bytes);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt32(value);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Short value;
        try {
            value = (Short)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNumberNull();
            return true;
        }
        this.writeInt16(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Short value = (Short)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNumberNull();
            return;
        }
        jsonWriter.writeInt32(value.shortValue());
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        return ObjectWriterImplInt16.INSTANCE;
    }
}

