/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class DynamicClassLoader
extends ClassLoader {
    static final String FASTJSON_PACKAGE;
    static final ClassLoader FASTJSON_CLASSLOADER;
    private static ProtectionDomain DOMAIN;
    private static Map<String, Class<?>> classMapping;
    private final ClassLoader parent;

    public DynamicClassLoader() {
        this(DynamicClassLoader.getParentClassLoader());
    }

    public DynamicClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    static ClassLoader getParentClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                contextClassLoader.loadClass(DynamicClassLoader.class.getName());
                return contextClassLoader;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return DynamicClassLoader.class.getClassLoader();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> mappingClass = classMapping.get(name);
        if (mappingClass != null) {
            return mappingClass;
        }
        return super.loadClass(name, resolve);
    }

    public Class<?> defineClassPublic(String name, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(name, b, off, len, DOMAIN);
    }

    public boolean isExternalClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        for (ClassLoader current = this; current != null; current = current.getParent()) {
            if (current != classLoader) continue;
            return false;
        }
        return true;
    }

    static {
        Class[] classes;
        classMapping = new HashMap();
        FASTJSON_PACKAGE = JSON.class.getPackage().getName() + ".";
        FASTJSON_CLASSLOADER = JSON.class.getClassLoader();
        for (Class clazz : classes = new Class[]{Object.class, Type.class, Fnv.class, JSONReader.class, FieldReader.class, ObjectReader.class, ObjectReaderAdapter.class, JSONWriter.class, JSONWriter.Context.class, FieldWriter.class, PropertyPreFilter.class, PropertyFilter.class, NameFilter.class, ValueFilter.class, ObjectWriter.class, ObjectWriterAdapter.class, List.class, Map.class, Supplier.class}) {
            classMapping.put(clazz.getName(), clazz);
        }
        DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return DynamicClassLoader.class.getProtectionDomain();
            }
        });
    }
}

