/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Arrays;

class ObjectReaderImplBoolValueArray
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplBoolValueArray INSTANCE = new ObjectReaderImplBoolValueArray();
    static final long TYPE_HASH = Fnv.hashCode64("[Z");

    ObjectReaderImplBoolValueArray() {
    }

    @Override
    public Class getObjectClass() {
        return boolean[].class;
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            boolean[] values = new boolean[16];
            int size = 0;
            while (!jsonReader.nextIfMatch(']')) {
                int minCapacity = size + 1;
                if (minCapacity - values.length > 0) {
                    int oldCapacity = values.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values = Arrays.copyOf(values, newCapacity);
                }
                values[size++] = jsonReader.readBoolValue();
            }
            jsonReader.nextIfMatch(',');
            return Arrays.copyOf(values, size);
        }
        if (jsonReader.isString()) {
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(jsonReader.info("not support input " + str));
        }
        throw new JSONException(jsonReader.info("TODO"));
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        long typeHashCode;
        if (jsonReader.nextIfMatch((byte)-110) && (typeHashCode = jsonReader.readTypeHashCode()) != TYPE_HASH) {
            throw new JSONException("not support autoType : " + jsonReader.getString());
        }
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        boolean[] array = new boolean[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = jsonReader.readBoolValue();
        }
        return array;
    }
}

