/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.CompareKindEnum;
import com.hundsun.lightdb.unisql.constant.CompareReportStateEnum;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiQueryResultSetDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.sqlv2.EnhanceSqlEngine;
import com.hundsun.lightdb.unisql.sqlv2.ResultSetHandler;
import com.hundsun.lightdb.unisql.utils.DbTypeSerializeUtil;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OraclePreparedStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.h2.jdbc.JdbcResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class MultiJdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(MultiJdbcUtils.class);
    private static int FETCHSIZE = 1000;
    public static final ThreadLocal<MultiQueryResultDTO> MultiQueryResultDTO = new ThreadLocal();

    public static void doPreparedQuery(Connection connection, String sql, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) {
        MultiJdbcUtils.doPreparedQuery(connection, sql, Collections.emptyList(), queryResultDTO, multiFutures, sourceQuery);
    }

    public static void doPreparedQuery(Connection connection, String multiQuerySql, List<PreparedParameter> preparedParameters, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) {
        queryResultDTO.setMultiQuerySql(multiQuerySql);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (StringUtils.isNotBlank((CharSequence)MultiProperties.getQueryResultPushUrl())) {
            queryResultDTO.setMessageType("http");
        } else {
            queryResultDTO.setMessageType("pulsar");
        }
        try {
            preparedStatement = connection.prepareStatement(multiQuerySql);
            preparedStatement.setFetchSize(FETCHSIZE);
            if (CollectionUtils.isNotEmpty(preparedParameters)) {
                block15: for (PreparedParameter preparedParameter : preparedParameters) {
                    int sqlDataType = preparedParameter.getVendorTypeNumber();
                    switch (sqlDataType) {
                        case 12: {
                            preparedStatement.setString(preparedParameter.getParameterIndex(), (String)preparedParameter.getX());
                            continue block15;
                        }
                        case 3: {
                            preparedStatement.setBigDecimal(preparedParameter.getParameterIndex(), (BigDecimal)preparedParameter.getX());
                            continue block15;
                        }
                        case 4: {
                            preparedStatement.setInt(preparedParameter.getParameterIndex(), (Integer)preparedParameter.getX());
                            continue block15;
                        }
                        case -5: {
                            preparedStatement.setLong(preparedParameter.getParameterIndex(), (Long)preparedParameter.getX());
                            continue block15;
                        }
                        case 91: {
                            preparedStatement.setDate(preparedParameter.getParameterIndex(), (Date)preparedParameter.getX());
                            continue block15;
                        }
                        case 93: {
                            preparedStatement.setTimestamp(preparedParameter.getParameterIndex(), (Timestamp)preparedParameter.getX());
                            continue block15;
                        }
                        case 2004: {
                            preparedStatement.setBlob(preparedParameter.getParameterIndex(), (Blob)preparedParameter.getX());
                            continue block15;
                        }
                        case 2005: {
                            preparedStatement.setClob(preparedParameter.getParameterIndex(), (Clob)preparedParameter.getX());
                            continue block15;
                        }
                        case -2: {
                            preparedStatement.setBytes(preparedParameter.getParameterIndex(), (byte[])preparedParameter.getX());
                            continue block15;
                        }
                    }
                    preparedStatement.setObject(preparedParameter.getParameterIndex(), preparedParameter.getX());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
            resultSet = preparedStatement.executeQuery();
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)));
            MultiplexContext.sendMessage(queryResultDTO);
            return;
        }
        List<String> rawColumnLabels = null;
        try {
            List<String> orderByColumnLabels = MultiJdbcUtils.fetchOrderByColumnLabels(resultSet);
            rawColumnLabels = MultiJdbcUtils.fetchRawColumnLabels(resultSet);
            ResultSet rawResultSet = resultSet;
            List<String> finalRawColumnLabels = rawColumnLabels;
            ResultSetHandler resultSetConsumer = sortedResultSet -> {
                if (sourceQuery.booleanValue()) {
                    MultiJdbcUtils.handleSourceQuery(finalRawColumnLabels, sortedResultSet, multiQuerySql, queryResultDTO, multiFutures, rawResultSet);
                } else {
                    MultiJdbcUtils.handleTargetQuery(finalRawColumnLabels, sortedResultSet, multiQuerySql, queryResultDTO, rawResultSet);
                }
                return true;
            };
            String orderByColumns = orderByColumnLabels.stream().collect(Collectors.joining(","));
            String tableName = "temp" + UUID.randomUUID().toString().replace("-", "");
            String orderBySql = String.format("select * from %s order by %s", tableName, orderByColumns);
            MultiQueryResultDTO.set(queryResultDTO);
            EnhanceSqlEngine.executeSecondaryQueries(DbType.of(queryResultDTO.getTargetDialect()), tableName, resultSet, "\u591a\u53d1\u67e5\u8be2\u7ed3\u679c\u96c6\u6392\u5e8f", orderBySql, resultSetConsumer);
        }
        catch (Exception e) {
            log.error("\u7ed3\u679c\u96c6\u6392\u5e8f\u51fa\u9519", (Throwable)e);
            if (sourceQuery.booleanValue()) {
                MultiJdbcUtils.handleSourceQuery(rawColumnLabels, resultSet, multiQuerySql, queryResultDTO, multiFutures, resultSet);
            }
            MultiJdbcUtils.handleTargetQuery(rawColumnLabels, resultSet, multiQuerySql, queryResultDTO, resultSet);
        }
    }

    private static List<String> fetchRawColumnLabels(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= columnCount; ++i) {
            String columnLabel = metaData.getColumnLabel(i);
            result.add(columnLabel.toLowerCase(Locale.ROOT));
        }
        return result;
    }

    private static List<String> fetchOrderByColumnLabels(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 1; i <= columnCount; ++i) {
            int columnType = DbTypeSerializeUtil.getTypeByColumnTypeName(metaData.getColumnTypeName(i));
            if (12 != columnType && 3 != columnType && 8 != columnType) continue;
            result.add(i);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(1);
        }
        return result.stream().map(String::valueOf).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getReturingData(SyncDataParamater syncData, Statement statement, String multiQuerySql, MultiQueryResultDTO queryResultDTO) {
        ResultSet rs;
        block14: {
            boolean oracleStmt2222222;
            block15: {
                rs = null;
                if (queryResultDTO == null || queryResultDTO.getSourceDialect() == null) break block14;
                if (queryResultDTO.getSourceDialect().equalsIgnoreCase(DbType.ORACLE.name())) {
                    if (statement instanceof OraclePreparedStatement) {
                        OraclePreparedStatement oracleStmt2222222 = (OraclePreparedStatement)statement;
                        rs = oracleStmt2222222.getReturnResultSet();
                    }
                } else if (queryResultDTO.getSourceDialect().equalsIgnoreCase(DbType.MYSQL.name())) {
                    rs = statement.getResultSet();
                }
                if (rs != null) break block15;
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2RETUNRING\u7ed3\u679c\u96c6\u5931\u8d25, \u7a7a\u7ed3\u679c\u96c6\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                boolean oracleStmt2222222 = false;
                if (rs == null) return oracleStmt2222222;
                MultiJdbcUtils.close(rs);
                return oracleStmt2222222;
            }
            try {
                MultiJdbcUtils.handleReturnSyncResultSet(syncData.getTableName(), syncData.getTableCols(), rs, multiQuerySql, queryResultDTO);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                oracleStmt2222222 = true;
                if (rs == null) return oracleStmt2222222;
            }
            catch (IOException e) {
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
                if (rs == null) return false;
                MultiJdbcUtils.close(rs);
                return false;
            }
            catch (Exception e2) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e2)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e2)));
                if (rs == null) return false;
                {
                    catch (Throwable throwable) {
                        if (rs == null) throw throwable;
                        MultiJdbcUtils.close(rs);
                        throw throwable;
                    }
                }
                MultiJdbcUtils.close(rs);
                return false;
            }
            MultiJdbcUtils.close(rs);
            return oracleStmt2222222;
        }
        if (rs == null) return false;
        MultiJdbcUtils.close(rs);
        return false;
    }

    private static void handleSourceQuery(List<String> rawColumnLabels, ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO, List<MultiCompletableFuture> multiFutures, ResultSet rawResultSet) {
        String targetKey = queryResultDTO.getSourceDialect() + ":\u6e90\u5e93\u4e1a\u52a1SQL\u67e5\u8be2\u7ed3\u679c\u96c6\u5f02\u6b65";
        ExecutorService pool = MultiplexContext.getOrCreateTargetPool(targetKey);
        MultiCompletableFuture multiSourceCompletableFuture = new MultiCompletableFuture(targetKey);
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            ResultSetWriter resultSetWriter = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                resultSetWriter = new ResultSetWriter(MultiProperties.isResultSetSpillThresholdEnabled(), MultiProperties.getMultiResultSetSpillThreshold(), MultiProperties.getMultiResultSetSpillFileBasedir(), queryResultDTO.buildSpillFileName());
                MultiJdbcUtils.handleResultSet(rawColumnLabels, resultSet, multiQuerySql, queryResultDTO, resultSetWriter, rawResultSet);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
                }
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5904\u7406\u5b8c\u6210", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u5199\u6587\u4ef6\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u7ed3\u679c\u96c6\u5199\u6587\u4ef6\u5931\u8d25", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)});
                }
                queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
                queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)));
                MultiplexContext.sendMessage(queryResultDTO);
                String string = String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u5e76\u53d1\u904d\u5386\u5931\u8d25", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg());
                return string;
            }
            finally {
                if (resultSetWriter != null) {
                    resultSetWriter.closeWriter();
                }
            }
        }, pool);
        multiSourceCompletableFuture.setFuture(future);
        multiFutures.add(multiSourceCompletableFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTargetQuery(List<String> rawColumnLabels, ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO, ResultSet finalResultSet) {
        ResultSetWriter resultSetWriter = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5f00\u59cb\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
            resultSetWriter = new ResultSetWriter(MultiProperties.isResultSetSpillThresholdEnabled(), MultiProperties.getMultiResultSetSpillThreshold(), MultiProperties.getMultiResultSetSpillFileBasedir(), queryResultDTO.buildSpillFileName());
            MultiJdbcUtils.handleResultSet(rawColumnLabels, resultSet, multiQuerySql, queryResultDTO, resultSetWriter, finalResultSet);
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u675f\uff0ctraceId [{}] \u67e5\u8be2SQL [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql});
            }
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u5199\u6587\u4ef6\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_RESULT_TRANSFER_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u7ed3\u679c\u96c6\u4f20\u8f93\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, e.toString()));
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u7684[{}]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25 traceId [{}] \u6267\u884cSQL [{}] \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), queryResultDTO.getTraceId(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)});
            }
            queryResultDTO.setState(CompareReportStateEnum.MULTI_QUERY_FAIL.name());
            queryResultDTO.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u7684[%s]\u67e5\u8be2\u7ed3\u679c\u96c6\u4e32\u884c\u904d\u5386\u5931\u8d25\uff0c\u591a\u53d1\u67e5\u8be2SQL\uff1a%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), CompareKindEnum.valueOf(queryResultDTO.getCompareKind()).getMsg(), multiQuerySql, ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            if (resultSetWriter != null) {
                resultSetWriter.closeWriter();
            }
        }
        MultiplexContext.sendMessage(queryResultDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleResultSet(List<String> columnNames, ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO, ResultSetWriter resultSetWriter, ResultSet rawResultSet) throws Exception {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            ArrayList<Integer> columnDataTypes = new ArrayList<Integer>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                int columnType = DbTypeSerializeUtil.getColumnType(resultSetMetaData, i + 1);
                columnDataTypes.add(columnType);
            }
            MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
            multiQueryResultSet.setColumnNames(columnNames);
            multiQueryResultSet.setColumnDataTypes(columnDataTypes);
            String traceId = queryResultDTO.getTraceId();
            boolean enableFetchLimit = MultiProperties.isMultiResultSetFetchLimitEnabled();
            int fetchLimit = MultiProperties.getMultiResultSetFetchLimit();
            int fetchCount = 0;
            while (resultSet.next()) {
                if (enableFetchLimit) {
                    if (fetchCount >= fetchLimit) {
                        multiQueryResultSet.setFetchLimit(fetchLimit);
                        break;
                    }
                    ++fetchCount;
                }
                ArrayList<Object> curRow = new ArrayList<Object>();
                for (int i = 0; i < columnCount; ++i) {
                    Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(traceId, multiQuerySql, resultSet, resultSetMetaData, i + 1, DbType.of(queryResultDTO.getTargetDialect()));
                    curRow.add(value);
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u8bfb\u53d6\u5f53\u524d\u884c\u6570\u636e\uff0ctrace_id [{}] multiQuerySql [{}] \u6e90\u65b9\u8a00 [{}] \u76ee\u6807\u65b9\u8a00 [{}] \u884c\u5185\u5bb9 [{}]", new Object[]{traceId, multiQuerySql, queryResultDTO.getSourceDialect(), queryResultDTO.getTargetDialect(), JsonUtils.toJson(curRow)});
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u5e8f\u5217\u5316\u884c\u6570\u636e traceId [{}] \u884c\u5185\u5bb9 [{}] multiQuerySql [{}]", new Object[]{traceId, JsonUtils.toJson(curRow), multiQuerySql});
                }
                resultSetWriter.writeRow(curRow, columnDataTypes);
            }
            resultSetWriter.finish(multiQueryResultSet);
            multiQueryResultSet.setBizSqlTableName(queryResultDTO.getBizSqlTableName());
            queryResultDTO.setMultiQueryRowCount(resultSetWriter.size());
            queryResultDTO.setMultiQueryResultSet(multiQueryResultSet);
            if (resultSet instanceof JdbcResultSet) {
                Statement statement = resultSet.getStatement();
                MultiJdbcUtils.close(statement);
                MultiJdbcUtils.close(resultSet);
                Connection statementConnection = statement.getConnection();
                MultiJdbcUtils.close(statementConnection);
            }
        }
        catch (SQLException e) {
            log.error("\u5904\u7406\u7ed3\u679c\u96c6\u51fa\u9519", (Throwable)e);
        }
        finally {
            MultiJdbcUtils.close(rawResultSet.getStatement());
            MultiJdbcUtils.close(rawResultSet);
        }
    }

    public static void handleReturnSyncResultSet(String syncTableName, List<String> syncColumnNames, ResultSet resultSet, String multiQuerySql, MultiQueryResultDTO queryResultDTO) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        MultiQueryResultSetDTO multiQueryResultSet = new MultiQueryResultSetDTO();
        multiQueryResultSet.setColumnNames(syncColumnNames);
        ArrayList<List<Object>> dataRows = new ArrayList<List<Object>>();
        String traceId = queryResultDTO.getTraceId();
        while (resultSet.next()) {
            ArrayList<Object> curRow = new ArrayList<Object>();
            for (int i = 0; i < columnCount; ++i) {
                Object value = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(traceId, multiQuerySql, resultSet, resultSetMetaData, i + 1, DbType.of(queryResultDTO.getTargetDialect()));
                curRow.add(value);
            }
            dataRows.add(curRow);
        }
        multiQueryResultSet.setDataRows(dataRows);
        multiQueryResultSet.setBizSqlTableName(queryResultDTO.getBizSqlTableName());
        queryResultDTO.setMultiQueryRowCount(dataRows.size());
        queryResultDTO.setMultiQueryResultSet(multiQueryResultSet);
        queryResultDTO.setBizSqlTableName(syncTableName);
    }

    public static void close(AutoCloseable autoCloseable) {
        block3: {
            try {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean checkDataBaseConnection(String url, String userName, String password) {
        boolean flag;
        block2: {
            flag = false;
            try {
                Connection connection = DriverManager.getConnection(url, userName, password);
                connection.close();
                flag = true;
            }
            catch (SQLException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("\u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef url\uff1a{} userName:{} ", (Object)url, (Object)userName);
            }
        }
        return flag;
    }

    private static final class ResultSetWriter {
        private final boolean spillThresholdEnabled;
        private final int spillThreshold;
        private final String basePath;
        private final String fileName;
        private BufferedWriter writer;
        private List<List<Object>> dataRows = new ArrayList<List<Object>>();
        private int writeCount = 0;
        private boolean spilledToFile = false;

        public ResultSetWriter(boolean spillThresholdEnabled, int spillThreshold, String basePath, String fileName) {
            this.spillThresholdEnabled = spillThresholdEnabled;
            this.spillThreshold = spillThreshold;
            this.basePath = basePath;
            this.fileName = fileName;
        }

        public void writeRow(List<Object> row, List<Integer> columnDataTypes) throws IOException {
            if (this.spillThresholdEnabled && this.writeCount >= this.spillThreshold) {
                if (!this.spilledToFile) {
                    this.spillToFile();
                }
                this.writer.write(this.serializeCsvRow(row) + "\n");
                ++this.writeCount;
            } else {
                this.dataRows.add(row);
                ++this.writeCount;
            }
        }

        private String serializeCsvRow(List<Object> row) {
            return JsonUtils.toJson(row);
        }

        private void spillToFile() throws IOException {
            String filePath = Paths.get(this.basePath, this.fileName).toString();
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8));
            for (List<Object> row : this.dataRows) {
                this.writer.write(this.serializeCsvRow(row) + "\n");
            }
            this.dataRows.clear();
            this.spilledToFile = true;
        }

        public void finish(MultiQueryResultSetDTO multiQueryResultSet) {
            try {
                if (this.spilledToFile) {
                    multiQueryResultSet.setFilePath(this.basePath + "/" + this.fileName);
                } else {
                    multiQueryResultSet.setDataRows(this.dataRows);
                }
            }
            finally {
                this.closeWriter();
            }
        }

        public int size() {
            return this.writeCount;
        }

        public void closeWriter() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\u3002\u6b64\u9519\u8bef\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u672a\u5b8c\u5168\u5199\u5165\u6587\u4ef6\u3002", (Object)(this.basePath + "/" + this.fileName), (Object)e);
                }
            }
        }
    }
}

