/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.utils;

import com.hundsun.lightdb.unisql.constant.SystemConst;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UniSqlType;
import com.hundsun.lightdb.unisql.utils.Utils;
import com.oceanbase.jdbc.extend.datatype.INTERVALDS;
import com.oceanbase.jdbc.extend.datatype.INTERVALYM;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.rowset.serial.SerialBlob;
import oracle.sql.TIMESTAMP;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTypeSerializeUtil {
    private static final Logger logger = LoggerFactory.getLogger(DbTypeSerializeUtil.class);
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String BPCHAR = "bpchar";
    public static final String CHAR = "CHAR";
    public static final String VARCHAR_LOWER = "varchar";
    public static final String VARCHAR_UPPER = "VARCHAR";
    public static final String VARCHAR_2_LOWER = "varchar2";
    public static final String VARCHAR_2_UPPER = "VARCHAR2";
    public static final String NCHAR = "NCHAR";
    public static final String NVARCHAR_2_LOWER = "nvarchar2";
    public static final String NVARCHAR_2_UPPER = "NVARCHAR2";
    private static final String CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String NUMERIC = "numeric";
    public static final String NUMBER = "NUMBER";
    public static final String DECIMAL = "DECIMAL";
    public static final String DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String SMALLINT = "SMALLINT";
    public static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String INT_8 = "int8";
    public static final String INT = "INT";
    public static final String SERIAL_LOWER = "serial";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String BIGSERIAL = "bigserial";
    public static final String BIT_UPPER = "BIT";
    public static final String BIT_LOWER = "bit";
    public static final String TINYINT = "TINYINT";
    public static final String MEDIUMINT = "MEDIUMINT";
    public static final String INT_4 = "int4";
    public static final String INT_1 = "int1";
    public static final String INT_2 = "int2";
    public static final String BINARY_FLOAT = "BINARY_FLOAT";
    public static final String FLOAT_4 = "float4";
    public static final String FLOAT_8 = "float8";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String TIMESTAMP_LOWER = "timestamp";
    public static final String TIMESTAMP_UPPER = "TIMESTAMP";
    public static final String TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String DATETIME_WITH_TIME_ZONE = "DATETIME WITH TIME ZONE";
    public static final String TIMESTAMPTZ_LOWER = "timestamptz";
    public static final String LONG = "LONG";
    public static final String TINYTEXT = "TINYTEXT";
    public static final String TEXT_LOWER = "text";
    public static final String TEXT_UPPER = "TEXT";
    public static final String MEDIUMTEXT = "MEDIUMTEXT";
    public static final String LONGTEXT = "LONGTEXT";
    public static final String JSON_UPPER = "JSON";
    public static final String JSON_LOWER = "json";
    public static final String DATE_LOWER = "date";
    public static final String DATE = "DATE";
    public static final String DATETIME_LOWER = "datetime";
    public static final String DATETIME_UPPER = "DATETIME";
    public static final String TIME_UPPER = "TIME";
    public static final String TIME_LOWER = "time";
    public static final String BLOB_LOWER = "blob";
    public static final String BLOB_UPPER = "BLOB";
    public static final String CLOB_LOWER = "clob";
    public static final String CLOB_UPPER = "CLOB";
    public static final String NCLOB_LOWER = "nclob";
    public static final String NCLOB_UPPER = "NCLOB";
    public static final String RAW_UPPER = "RAW";
    public static final String RAW_LOWER = "raw";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String BYTEA = "bytea";
    public static final String TINYBLOB = "TINYBLOB";
    public static final String MEDIUMBLOB = "MEDIUMBLOB";
    public static final String LONGBLOB = "LONGBLOB";
    public static final String INTERVAL = "interval";
    public static final String INTERVALYM = "INTERVALYM";
    public static final String INTERVAL_YEAR_TO_MONTH_UPPER = "INTERVAL YEAR TO MONTH";
    public static final String INTERVALDS = "INTERVALDS";
    public static final String INTERVAL_DAY_TO_SECOND_UPPER = "INTERVAL DAY TO SECOND";
    public static final String REAL = "REAL";
    public static final String OTHER = "OTHER";
    public static final int INTERVAL_YEAR_TO_MONTH = 9999;
    public static final int INTERVAL_DAY_TO_SECOND = 10000;
    public static final String UNHEX = "UNHEX";
    public static final String TEXTSEND = "TEXTSEND";
    public static final String HEXTORAW = "HEXTORAW";
    public static Map<String, Integer> ColumnTypeNameMapping = new HashMap<String, Integer>();
    public static final Map<Integer, String> COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING;
    private static final DecimalFormat DECIMAL_FORMAT;
    private static String MYSQL_TO_DATE;
    private static String MYSQL_TO_TIMESTAMP;
    private static String ORACLE_TO_DATE;
    private static String ORACLE_TO_DATETIME;
    private static String ORACLE_TO_TIMESTAMP;
    private static String FUNCTION_CALL;
    private static final ThreadLocal<DateFormat> DATE_FORMATTER;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER;
    private static final Set<String> MYSQL_SERIAL;

    public static int getTypeByColumnTypeName(String columnTypeName) {
        return ColumnTypeNameMapping.getOrDefault(columnTypeName, 1111);
    }

    public static boolean notValidColumnDataType(Integer columnDataType) {
        return !COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.containsKey(columnDataType);
    }

    public static final String getNameByCode(Integer columnDataType) {
        return COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.get(columnDataType);
    }

    public static Map<Integer, String> allValidColumnDataType() {
        LinkedHashMap<Integer, String> allValidColumnDataTypeMap = new LinkedHashMap<Integer, String>();
        allValidColumnDataTypeMap.put(0, "\u5168\u90e8");
        allValidColumnDataTypeMap.putAll(COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING);
        return allValidColumnDataTypeMap;
    }

    public static Object getResultSetValueBySqlTypeName(String traceId, String transferredSql, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int columnIndex, DbType targetDialect) throws Exception {
        int columnDataType = 0;
        try {
            columnDataType = DbTypeSerializeUtil.getColumnType(resultSetMetaData, columnIndex);
            switch (columnDataType) {
                case 12: {
                    return resultSet.getString(columnIndex);
                }
                case 3: {
                    Object object = resultSet.getObject(columnIndex);
                    if (Objects.isNull(object)) {
                        return null;
                    }
                    return resultSet.getBigDecimal(columnIndex);
                }
                case 8: {
                    Object value = resultSet.getObject(columnIndex);
                    if (Objects.isNull(value)) {
                        return null;
                    }
                    return new BigDecimal(String.valueOf(value));
                }
                case 91: {
                    if (targetDialect == DbType.MYSQL || targetDialect == DbType.OCEAN_BASE_ORACLE || targetDialect == DbType.DM) {
                        Date date = resultSet.getDate(columnIndex);
                        if (Objects.isNull(date)) {
                            return null;
                        }
                        return DateFormatUtils.format((java.util.Date)date, (String)TIMESTAMP_FORMAT);
                    }
                    return resultSet.getString(columnIndex);
                }
                case 93: {
                    Object value = resultSet.getObject(columnIndex);
                    if (Objects.isNull(value)) {
                        return null;
                    }
                    long epochMilli = 0L;
                    if (value instanceof TIMESTAMP) {
                        TIMESTAMP timestamp = (TIMESTAMP)value;
                        epochMilli = timestamp.timestampValue().getTime();
                    } else if (value instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)value;
                        epochMilli = date.getTime();
                    } else if (value instanceof LocalDateTime) {
                        LocalDateTime dateTime = (LocalDateTime)value;
                        ZonedDateTime zonedDateTime = dateTime.atZone(ZoneOffset.systemDefault());
                        epochMilli = zonedDateTime.toInstant().toEpochMilli();
                    } else if (value instanceof OffsetDateTime) {
                        OffsetDateTime offsetDateTime = (OffsetDateTime)value;
                        Instant instant = offsetDateTime.toInstant();
                        epochMilli = instant.toEpochMilli();
                    }
                    if (epochMilli > 0L) {
                        return epochMilli;
                    }
                    return resultSet.getString(columnIndex);
                }
                case 2004: {
                    if (targetDialect != DbType.ORACLE && targetDialect != DbType.OCEAN_BASE_ORACLE && targetDialect != DbType.GAUSSDB500_ORACLE && targetDialect != DbType.GAUSSDB_ORACLE && targetDialect != DbType.DM && targetDialect == DbType.LIGHTDB_ORACLE) {
                        Blob blob = resultSet.getBlob(columnIndex);
                        if (Objects.isNull(blob)) {
                            return null;
                        }
                        if (blob instanceof SerialBlob) {
                            SerialBlob serialBlob = (SerialBlob)blob;
                            return Utils.encodeHex(serialBlob.getBytes(1L, (int)serialBlob.length()));
                        }
                    }
                    return Utils.encodeHex(resultSet.getBytes(columnIndex));
                }
                case 2005: {
                    return resultSet.getString(columnIndex);
                }
                case 92: {
                    return resultSet.getString(columnIndex);
                }
                case -2: {
                    return Utils.encodeHex(resultSet.getBytes(columnIndex));
                }
                case 9999: {
                    Object result = resultSet.getObject(columnIndex);
                    if (Objects.isNull(result)) {
                        return null;
                    }
                    if (targetDialect == DbType.ORACLE) {
                        oracle.sql.INTERVALYM oracle = (oracle.sql.INTERVALYM)result;
                        String str = oracle.stringValue();
                        String[] yearMonth = str.split("-");
                        return DbTypeSerializeUtil.formatInterval(yearMonth[0], yearMonth[1]);
                    }
                    if (targetDialect == DbType.OCEAN_BASE_ORACLE) {
                        INTERVALYM ob = (INTERVALYM)result;
                        String str = ob.stringValue();
                        String[] yearMonth = str.split("-");
                        return DbTypeSerializeUtil.formatInterval(yearMonth[0], yearMonth[1]);
                    }
                    if (targetDialect == DbType.GAUSSDB500_ORACLE || targetDialect == DbType.GAUSSDB_ORACLE || targetDialect == DbType.LIGHTDB_ORACLE) {
                        Class<?> clazz = result.getClass();
                        Method getValue = clazz.getMethod("getValue", new Class[0]);
                        getValue.setAccessible(true);
                        return getValue.invoke(result, new Object[0]);
                    }
                    if (targetDialect == DbType.DM) {
                        DmdbIntervalYM dm = (DmdbIntervalYM)result;
                        int years = dm.getYear();
                        int months = dm.getMonth();
                        return DbTypeSerializeUtil.formatInterval(String.valueOf(years), String.valueOf(months));
                    }
                    return resultSet.getString(columnIndex);
                }
                case 10000: {
                    Object result = resultSet.getObject(columnIndex);
                    if (Objects.isNull(result)) {
                        return null;
                    }
                    if (targetDialect == DbType.ORACLE) {
                        oracle.sql.INTERVALDS ob = (oracle.sql.INTERVALDS)result;
                        String stringValue = ob.stringValue();
                        return DbTypeSerializeUtil.timeToInterval(stringValue);
                    }
                    if (targetDialect == DbType.OCEAN_BASE_ORACLE) {
                        INTERVALDS ob = (INTERVALDS)result;
                        String stringValue = ob.stringValue();
                        return DbTypeSerializeUtil.timeToInterval(stringValue);
                    }
                    if (targetDialect != DbType.DM) break;
                    DmdbIntervalDT dm = (DmdbIntervalDT)result;
                    int days = dm.getDay();
                    int hour = dm.getHour();
                    int minute = dm.getMinute();
                    int second = dm.getSecond();
                    int msec = dm.getMsec();
                    LocalTime time = LocalTime.of(hour, minute, second, (int)TimeUnit.MICROSECONDS.toNanos(msec));
                    return DbTypeSerializeUtil.formatInterval(days, time);
                }
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u83b7\u53d6\u5217\u503c\u5f02\u5e38 traceId [{}] sql [{}] \u76ee\u6807\u65b9\u8a00[{}] \u5217\u540d\u79f0[{}] \u5217\u7c7b\u578b\u540d\u79f0[{}] \u6620\u5c04\u7f16\u7801[{}]", new Object[]{traceId, transferredSql, targetDialect.name(), resultSetMetaData.getColumnName(columnIndex), resultSetMetaData.getColumnTypeName(columnIndex), columnDataType});
            }
            throw e;
        }
        if (logger.isWarnEnabled()) {
            logger.error("\u672a\u6620\u5c04\u7684\u6570\u636e\u5e93java\u7c7b\u578b traceId [{}] sql [{}] \u76ee\u6807\u65b9\u8a00[{}] \u5217\u540d\u79f0[{}] \u5217\u7c7b\u578b\u540d\u79f0[{}] \u6620\u5c04\u7f16\u7801[{}]", new Object[]{traceId, transferredSql, targetDialect.name(), resultSetMetaData.getColumnName(columnIndex), resultSetMetaData.getColumnTypeName(columnIndex), columnDataType});
        }
        return resultSet.getObject(columnIndex);
    }

    private static String timeToInterval(String stringValue) {
        String[] split = stringValue.split(" ");
        String[] timeStr = split[1].split(":");
        BigDecimal totalSeconds = new BigDecimal(timeStr[2]);
        BigDecimal secondsBig = totalSeconds.setScale(0, 1);
        int seconds = secondsBig.intValue();
        BigDecimal fractionalPart = totalSeconds.subtract(secondsBig);
        BigDecimal nanosBig = fractionalPart.multiply(new BigDecimal("1000000000"));
        int nanoseconds = nanosBig.setScale(0, 4).intValue();
        LocalTime time = LocalTime.of(Integer.parseInt(timeStr[0]), Integer.parseInt(timeStr[1]), seconds, nanoseconds);
        return DbTypeSerializeUtil.formatInterval(Integer.parseInt(split[0]), time);
    }

    public static String formatInterval(String years, String months) {
        return years + " years " + months + " mons 0 days 0 hours 0 mins 0.00 secs";
    }

    public static String formatInterval(int days, LocalTime time) {
        return "0 years 0 mons " + days + " days " + time.getHour() + " hours " + time.getMinute() + " mins " + DECIMAL_FORMAT.format((double)(TimeUnit.SECONDS.toNanos(time.getSecond()) + (long)time.getNano()) / 1.0E9) + " secs";
    }

    public static String serializeToString(int sqlDataType, Object arg, String targetDialect) throws SQLException, IOException {
        if (Objects.isNull(arg)) {
            return "NULL";
        }
        switch (sqlDataType) {
            case 1: 
            case 12: {
                return DbTypeSerializeUtil.wrapSingleQuote(arg.toString());
            }
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return arg.toString();
            }
            case 91: {
                if (MYSQL_SERIAL.contains(targetDialect) && arg instanceof java.util.Date) {
                    return String.format(MYSQL_TO_DATE, DATE_FORMATTER.get().format((java.util.Date)arg));
                }
                if (arg instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)arg;
                    if (DbType.OCEAN_BASE_ORACLE.name().equals(targetDialect)) {
                        return String.format(ORACLE_TO_DATE, DATE_FORMATTER.get().format((java.util.Date)arg));
                    }
                    return String.format(ORACLE_TO_DATETIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()));
                }
            }
            case 93: {
                if (MYSQL_SERIAL.contains(targetDialect) && arg instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)arg;
                    return String.format(MYSQL_TO_TIMESTAMP, TIMESTAMP_FORMATTER.format(timestamp.toLocalDateTime()));
                }
                if (arg instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)arg;
                    return String.format(ORACLE_TO_TIMESTAMP, TIMESTAMP_FORMATTER.format(timestamp.toLocalDateTime()));
                }
            }
            case 16: {
                if ((DbType.OCEAN_BASE_ORACLE.name().equals(targetDialect) || DbType.ORACLE_19C.name().equals(targetDialect) || DbType.ORACLE.name().equals(targetDialect)) && arg instanceof Boolean) {
                    return (Boolean)arg != false ? "1" : "0";
                }
                if (arg instanceof Number) {
                    return ((Number)arg).intValue() > 0 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                }
                return arg.toString();
            }
            case -6: {
                return arg.toString();
            }
            case 2004: {
                if (!(arg instanceof Blob)) break;
                Blob blob = (Blob)arg;
                long blobLength = blob.length();
                String encodeHex = "";
                if (blobLength > 0L) {
                    byte[] bytes = blob.getBytes(1L, (int)blobLength);
                    encodeHex = Utils.encodeHex(bytes);
                }
                return DbTypeSerializeUtil.hexToRaw(targetDialect, encodeHex);
            }
            case 2005: {
                if (!(arg instanceof Clob)) break;
                Clob clob = (Clob)arg;
                int length = (int)clob.length();
                return clob.getSubString(1L, length);
            }
            case -3: 
            case -2: {
                if (!(arg instanceof byte[])) break;
                String encodeHex = Utils.encodeHex((byte[])arg);
                return DbTypeSerializeUtil.hexToRaw(targetDialect, encodeHex);
            }
            case -15: 
            case -9: {
                return DbTypeSerializeUtil.wrapSingleQuote(arg.toString());
            }
            case 0: {
                return "NULL";
            }
            case 92: {
                if (DbType.ORACLE_19C.name().equals(targetDialect) || DbType.OCEAN_BASE_ORACLE.name().equals(targetDialect)) {
                    return String.format(ORACLE_TO_TIMESTAMP, "1970-01-01 " + arg.toString());
                }
            }
            default: {
                return DbTypeSerializeUtil.wrapSingleQuote(arg.toString());
            }
        }
        return DbTypeSerializeUtil.wrapSingleQuote(arg.toString());
    }

    private static String hexToRaw(String targetDialect, String encodeHex) {
        if (MYSQL_SERIAL.contains(targetDialect)) {
            return String.format(FUNCTION_CALL, UNHEX, encodeHex);
        }
        if (DbType.LIGHTDB_MYSQL.name().equals(targetDialect) || DbType.LIGHTDB_ORACLE.name().equals(targetDialect)) {
            return String.format(FUNCTION_CALL, TEXTSEND, encodeHex);
        }
        return String.format(FUNCTION_CALL, HEXTORAW, encodeHex);
    }

    private static String wrapSingleQuote(String input) {
        return "'" + DbTypeSerializeUtil.escapeSingleQuote(input) + "'";
    }

    private static String escapeSingleQuote(String input) {
        if (input.indexOf("'") > 0) {
            return input.replace("'", SystemConst.GLOBAL_MARK_DOUBLE_SINGLE_QUOTE);
        }
        return input;
    }

    public static int getColumnType(ResultSetMetaData metaData, int index) {
        try {
            String columnTypeName = metaData.getColumnTypeName(index);
            return DbTypeSerializeUtil.getTypeByColumnTypeName(columnTypeName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ColumnTypeNameMapping.put(CHAR, 12);
        ColumnTypeNameMapping.put(NCHAR, 12);
        ColumnTypeNameMapping.put(BPCHAR, 12);
        ColumnTypeNameMapping.put(VARCHAR_LOWER, 12);
        ColumnTypeNameMapping.put(VARCHAR_UPPER, 12);
        ColumnTypeNameMapping.put(VARCHAR_2_LOWER, 12);
        ColumnTypeNameMapping.put(VARCHAR_2_UPPER, 12);
        ColumnTypeNameMapping.put(NVARCHAR_2_LOWER, 12);
        ColumnTypeNameMapping.put(NVARCHAR_2_UPPER, 12);
        ColumnTypeNameMapping.put(CHARACTER_VARYING, 12);
        ColumnTypeNameMapping.put(LONG, 12);
        ColumnTypeNameMapping.put(TINYTEXT, 12);
        ColumnTypeNameMapping.put(TEXT_LOWER, 12);
        ColumnTypeNameMapping.put(TEXT_UPPER, 12);
        ColumnTypeNameMapping.put(MEDIUMTEXT, 12);
        ColumnTypeNameMapping.put(LONGTEXT, 12);
        ColumnTypeNameMapping.put(JSON_LOWER, 12);
        ColumnTypeNameMapping.put(JSON_UPPER, 12);
        ColumnTypeNameMapping.put(NUMERIC, 3);
        ColumnTypeNameMapping.put(NUMBER, 3);
        ColumnTypeNameMapping.put(DECIMAL, 3);
        ColumnTypeNameMapping.put(BIT_LOWER, 3);
        ColumnTypeNameMapping.put(BIT_UPPER, 3);
        ColumnTypeNameMapping.put(SMALLINT, 3);
        ColumnTypeNameMapping.put(TINYINT, 3);
        ColumnTypeNameMapping.put(INT, 3);
        ColumnTypeNameMapping.put(MEDIUMINT, 3);
        ColumnTypeNameMapping.put(INTEGER, 3);
        ColumnTypeNameMapping.put(BIGINT, 3);
        ColumnTypeNameMapping.put(INT_1, 3);
        ColumnTypeNameMapping.put(INT_2, 3);
        ColumnTypeNameMapping.put(INT_4, 3);
        ColumnTypeNameMapping.put(INT_8, 3);
        ColumnTypeNameMapping.put(SERIAL_LOWER, 3);
        ColumnTypeNameMapping.put(BIGSERIAL, 3);
        ColumnTypeNameMapping.put(FLOAT, 8);
        ColumnTypeNameMapping.put(BINARY_FLOAT, 8);
        ColumnTypeNameMapping.put(REAL, 8);
        ColumnTypeNameMapping.put(FLOAT_4, 8);
        ColumnTypeNameMapping.put(FLOAT_8, 8);
        ColumnTypeNameMapping.put(DOUBLE, 8);
        ColumnTypeNameMapping.put(BINARY_DOUBLE, 8);
        ColumnTypeNameMapping.put(DOUBLE_PRECISION, 8);
        ColumnTypeNameMapping.put(TIMESTAMP_LOWER, 93);
        ColumnTypeNameMapping.put(TIMESTAMP_UPPER, 93);
        ColumnTypeNameMapping.put(TIMESTAMP_WITH_TIME_ZONE, 93);
        ColumnTypeNameMapping.put(DATETIME_WITH_TIME_ZONE, 93);
        ColumnTypeNameMapping.put(TIMESTAMPTZ_LOWER, 93);
        ColumnTypeNameMapping.put(DATETIME_LOWER, 93);
        ColumnTypeNameMapping.put(DATETIME_UPPER, 93);
        ColumnTypeNameMapping.put(DATE, 91);
        ColumnTypeNameMapping.put(DATE_LOWER, 91);
        ColumnTypeNameMapping.put(TIME_LOWER, 92);
        ColumnTypeNameMapping.put(TIME_UPPER, 92);
        ColumnTypeNameMapping.put(BLOB_LOWER, 2004);
        ColumnTypeNameMapping.put(BLOB_UPPER, 2004);
        ColumnTypeNameMapping.put(TINYBLOB, 2004);
        ColumnTypeNameMapping.put(MEDIUMBLOB, 2004);
        ColumnTypeNameMapping.put(LONGBLOB, 2004);
        ColumnTypeNameMapping.put(CLOB_LOWER, 2005);
        ColumnTypeNameMapping.put(CLOB_UPPER, 2005);
        ColumnTypeNameMapping.put(NCLOB_LOWER, 2005);
        ColumnTypeNameMapping.put(NCLOB_UPPER, 2005);
        ColumnTypeNameMapping.put(BINARY, -2);
        ColumnTypeNameMapping.put(RAW_LOWER, -2);
        ColumnTypeNameMapping.put(RAW_UPPER, -2);
        ColumnTypeNameMapping.put(BYTEA, -2);
        ColumnTypeNameMapping.put(VARBINARY, -2);
        ColumnTypeNameMapping.put(INTERVAL, 9999);
        ColumnTypeNameMapping.put(INTERVALYM, 9999);
        ColumnTypeNameMapping.put(INTERVAL_YEAR_TO_MONTH_UPPER, 9999);
        ColumnTypeNameMapping.put(INTERVALDS, 10000);
        ColumnTypeNameMapping.put(INTERVAL_DAY_TO_SECOND_UPPER, 10000);
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING = new LinkedHashMap<Integer, String>();
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.VARCHAR.getJdbcType(), UniSqlType.VARCHAR.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.DECIMAL.getJdbcType(), UniSqlType.DECIMAL.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.DOUBLE.getJdbcType(), UniSqlType.DOUBLE.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.TIMESTAMP.getJdbcType(), UniSqlType.TIMESTAMP.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.DATE.getJdbcType(), UniSqlType.DATE.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.TIME.getJdbcType(), UniSqlType.TIME.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.CLOB.getJdbcType(), UniSqlType.CLOB.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.BLOB.getJdbcType(), UniSqlType.BLOB.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(UniSqlType.BINARY.getJdbcType(), UniSqlType.BINARY.getName());
        COMPARE_RULE_COLUMN_DATA_TYPE_MAPPING.put(1111, OTHER);
        DECIMAL_FORMAT = new DecimalFormat("0.00####");
        MYSQL_TO_DATE = "STR_TO_DATE('%s','%%Y-%%m-%%d')";
        MYSQL_TO_TIMESTAMP = "STR_TO_DATE('%s','%%Y-%%m-%%d %%H:%%i:%%s.%%f')";
        ORACLE_TO_DATE = "TO_TIMESTAMP('%s','YYYY-MM-DD')";
        ORACLE_TO_DATETIME = "TO_TIMESTAMP('%s','YYYY-MM-DD HH24:MI:SS')";
        ORACLE_TO_TIMESTAMP = "TO_TIMESTAMP('%s','YYYY-MM-DD HH24:MI:SS.FF6')";
        FUNCTION_CALL = "%s('%s')";
        DATE_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(TIMESTAMP_FORMAT);
        TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
        MYSQL_SERIAL = new HashSet<String>();
        MYSQL_SERIAL.add(DbType.MYSQL.name());
        MYSQL_SERIAL.add(DbType.OCEAN_BASE_MYSQL.name());
    }
}

